SetToggleAdapterEvent = {};
SetToggleAdapterEvent_mt = Class(SetToggleAdapterEvent, Event);
InitEventClass(SetToggleAdapterEvent, "SetToggleAdapterEvent");
function SetToggleAdapterEvent:emptyNew()
      local self = Event:new(SetToggleAdapterEvent_mt);
      self.className="SetToggleAdapterEvent";
      return self;
end;
function SetToggleAdapterEvent:new(object, active)
      local self = SetToggleAdapterEvent:emptyNew()
      self.active = active;
      self.object = object;
      return self;
end;
function SetToggleAdapterEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.active = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
function SetToggleAdapterEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.active);
end;
function SetToggleAdapterEvent:run(connection)
      self.object:setToggleAdapter(self.active, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetToggleAdapterEvent:new(self.object, self.active), nil, connection, self.object);
      end;
end;