SetAdditionalBoardsEvent = {};
SetAdditionalBoardsEvent_mt = Class(SetAdditionalBoardsEvent, Event);

InitEventClass(SetAdditionalBoardsEvent, "SetAdditionalBoardsEvent");

function SetAdditionalBoardsEvent:emptyNew()
    local self = Event:new(SetAdditionalBoardsEvent_mt);
    self.className="SetAdditionalBoardsEvent";
    return self;
end;

function SetAdditionalBoardsEvent:new(vehicle, additionalBoardsState)
    local self = SetAdditionalBoardsEvent:emptyNew()
    self.vehicle = vehicle;
	self.additionalBoardsState = additionalBoardsState;
    return self;
end;

function SetAdditionalBoardsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.additionalBoardsState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetAdditionalBoardsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.additionalBoardsState);
end;

function SetAdditionalBoardsEvent:run(connection)   
	self.vehicle:toggleAdditionalBoards(self.additionalBoardsState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetAdditionalBoardsEvent:new(self.vehicle, self.additionalBoardsState), nil, connection, self.vehicle);
    end;
end;

function SetAdditionalBoardsEvent.sendEvent(vehicle, additionalBoardsState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetAdditionalBoardsEvent:new(vehicle, additionalBoardsState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetAdditionalBoardsEvent:new(vehicle, additionalBoardsState));
		end;
	end;
end;