﻿--looseterror & TwistedGA (LazyMod Studios)
--graintrailer
-- Specialization for graintrailer
--V 3.0

graintrailer = {};

function graintrailer.prerequisitesPresent(specializations)
    return true;
end;

function graintrailer:load(xmlFile)
	self.trailertarp = SpecializationUtil.callSpecializationsFunction("trailertarp");

	self.tarp = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.tarp#index"));
	self.roll = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.roll#index"));
	
	self.tarpBar = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.tarpBar#index"));
	
	self.handle1 = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.handle1#index"));
	self.handle2 = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.handle2#index"));
	
	self.handle1Trigger = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.handle1Trigger#index"));
	self.handle2Trigger = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.handle2Trigger#index"));
	
	self.isOpen = true; 
	setVisibility(self.tarp, self.isOpen);
	
	self.isRolled = false;
	setVisibility(self.roll, self.isRolled);
	
	self.isHandle1 = false;
	setVisibility(self.handle1, self.isHandle1);
	
	self.isHandle2 = false;
	setVisibility(self.handle2, self.isHandle2);
		
	self.stand = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.stand#index"));
	self.stand_x, self.stand_y, self.stand_z = getTranslation(self.stand);
	self.standUpTranslation = self.stand_y + 0.35;
	self.standCurTranslation = self.stand_y;
	self.standDownTranslation = self.stand_y;
	self.standDown = true;
	
	--/ MP Variables
	self.Trigger1 = false;
	self.Trigger2 = false;
end;

function graintrailer:delete()
end;

function graintrailer:readStream(streamId, connection)
    self.isOpen = streamReadBool(streamId);
	self.isRolled = streamReadBool(streamId);
end;

function graintrailer:writeStream(streamId, connection)
    streamWriteBool(streamId, self.isOpen);
	streamWriteBool(streamId, self.isRolled);
end;

function graintrailer:readUpdateStream(streamId, timestamp, connection)
	if connection:getIsServer() then
		if streamReadBool(streamId) then
		end;
	end;
end;

function graintrailer:writeUpdateStream(streamId, connection, dirtyMask)
	if not connection:getIsServer() then
		if streamWriteBool(streamId, bitAND(dirtyMask, self.vehicleDirtyFlag) ~= 0) then
        end;
    end;
end;

function graintrailer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function graintrailer:keyEvent(unicode, sym, modifier, isDown)
end;

function graintrailer:update(dt)	
	if self.isClient then
		if self:getIsActive() and self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.tarp) then
				self.isOpen = not self.isOpen
				self.isRolled = not self.isRolled
				self:trailertarp(self.isOpen, self.isRolled);
			end;		
		end;
	for i, jointDesc in pairs(self.componentJoints) do
	   setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;	
	-- Set self.standDown
	if self.attacherVehicle ~= nil then
		self.standDown = false;
	else
		self.standDown = true;
	end;
-- Increase/Decrease standCurTranslation, Update Translation
	if self.standDown then
		if self.standCurTranslation > self.standDownTranslation then
			self.standCurTranslation = self.standCurTranslation - 0.01;
		end;
		setTranslation(self.stand, self.stand_x, self.standCurTranslation, self.stand_z);
	else
		if self.standCurTranslation < self.standUpTranslation then
			self.standCurTranslation = self.standCurTranslation + 0.01;
		end;
		setTranslation(self.stand, self.stand_x, self.standCurTranslation, self.stand_z);
	end;	
	end;
end;

function graintrailer:draw()
	if self.isOpen then
		g_currentMission:addExtraPrintText(g_i18n:getText("Tarp_2"),InputBinding.tarp);
	else
		g_currentMission:addExtraPrintText(g_i18n:getText("Tarp_1"),InputBinding.tarp);
	end;
end;

function graintrailer:trailertarp(currenttarp, noEventSend)
	TrailerTarpEvent.sendEvent(self,currenttarp,noEventSend);
	if currenttarp then
		self.isOpen = true;
		self.isRolled = false;
	else
		self.isOpen = false;
		self.isRolled = true;
	end;
	setVisibility(self.tarp, self.isOpen);
	setVisibility(self.roll, self.isRolled);
	 
end;

function graintrailer:onAttach(attacherVehicle)
end;

function graintrailer:onDetach()
end;

function graintrailer:onLeave()
end;

function graintrailer:onDeactivate()
end;

function graintrailer:onDeactivateSounds()
end;

TrailerTarpEvent = {};
TrailerTarpEvent_mt = Class(TrailerTarpEvent, Event);

InitEventClass(TrailerTarpEvent, "TrailerTarpEvent");

function TrailerTarpEvent:emptyNew()
    local self = Event:new(TrailerTarpEvent_mt);
    self.className="TrailerTarpEvent";
    return self;
end;

function TrailerTarpEvent:new(vehicle, currenttarp)
    local self = TrailerTarpEvent:emptyNew()
    self.vehicle = vehicle;
	self.currenttarp = currenttarp;
    return self;
end;

function TrailerTarpEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.currenttarp = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function TrailerTarpEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.currenttarp);
end;

function TrailerTarpEvent:run(connection)
	self.vehicle:trailertarp(self.currenttarp, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(TrailerTarpEvent:new(self.vehicle, self.currenttarp), nil, connection, self.vehicle);
    end;
end;

function TrailerTarpEvent.sendEvent(vehicle, currenttarp, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(TrailerTarpEvent:new(vehicle, currenttarp), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(TrailerTarpEvent:new(vehicle, currenttarp));
		end;
	end;
end;