﻿--
-- Merlo P41.7 Turbofarmer
--
-- author  Mythos
-- date  15/09/2013
-- www.ARM-team.gr
-- Copyright (C) ARM Team, All Rights Reserved.

MerloP417 = {};

function MerloP417.prerequisitesPresent(specializations)
    return true;
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:load(xmlFile)

	-- Functions
	self.MPCode = SpecializationUtil.callSpecializationsFunction("MPCode");
	
	-- Indexs
	self.outCamera = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cameras.camera1#rotateNode"));
	self.refPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.refPoint#index"));
	self.refPointS = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.refPointS#index"));
	
	self.backAtt = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.backAttacher#index"));
	self.baTransMin = getXMLFloat(xmlFile,"vehicle.backAttacher#transMin");
	self.baTransMax = getXMLFloat(xmlFile,"vehicle.backAttacher#transMax");
	
	self.oldY = 0;
	self.changeWheel = 0;
	
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:delete()
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:mouseEvent(posX, posY, isDown, isUp, button)
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:keyEvent(unicode, sym, modifier, isDown)
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:update(dt)
	
	if self:getIsActiveForInput() and self:getIsActive() then
		
		if InputBinding.hasEvent(InputBinding.MERLOP417_WHEEL_MODE) then
			self.changeWheel = self.changeWheel+1;
		end;
		
		if self.changeWheel == 0  then
			self:MPCode(2, 0, 0);
		elseif self.changeWheel == 1  then
			self:MPCode(2, 1, -50);
		elseif self.changeWheel == 2  then
			self:MPCode(2, 2, 50);
		elseif self.changeWheel == 3 then
			self.changeWheel = 0;
		end;
	
		if InputBinding.isPressed(InputBinding.MERLO_BACK_ATTACHER_UP) then
			self:MPCode(3);
		end;
		
		if InputBinding.isPressed(InputBinding.MERLO_BACK_ATTACHER_DOWN) then
			self:MPCode(4);
		end;
		
	end;
	
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:updateTick(dt)
	if self:getIsActive() then
		self:MPCode(1);
	end;
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:MPCode(mode, state, angle, noEventSend)
	MerloP417Event.sendEvent(self, mode, state, angle, noEventSend);

--______________________________________________________________________________
	if mode == 1 then
--____________________________ ADJUST OUT CAMERA HEIGHT _________________________
		local x,y,z = getWorldTranslation(self.refPoint);
		local x1,y1,z1 = getWorldTranslation(self.refPointS);
		local diff = y-y1;
		local diff1 = diff - self.oldY;
		if diff1~=0 then
			translate(self.outCamera, 0, diff1/4, 0);
		end;
		self.oldY = diff;
--______________________________________________________________________________
	elseif mode == 2 then
--___________________________________ WHEEL MODE _______________________________
		self.wheels[3].rotSpeed = Utils.degToRad(angle);
		self.wheels[4].rotSpeed = Utils.degToRad(angle);
		if state == 0  then
			self.changeWheel = 0;
		elseif state == 1  then
			self.changeWheel = 1;
		elseif state == 2  then
			self.changeWheel = 2;
		end;
--______________________________________________________________________________
	elseif mode == 3 then
--______________________________________________________________________________
		local x,y,z = getTranslation(self.backAtt);
		if y<self.baTransMax then
			translate(self.backAtt, 0,0.001,0);
		end;
--______________________________________________________________________________
	elseif mode == 4 then
--______________________________________________________________________________
		local x,y,z = getTranslation(self.backAtt);
		if y>self.baTransMin then
			translate(self.backAtt, 0,-0.001,0);
		end;
	end;

end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:draw()
	
	if self.changeWheel == 0  then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MERLOP417_WHEEL_ALL"), self.typeDesc), InputBinding.MERLOP417_WHEEL_MODE);
	elseif self.changeWheel == 1  then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MERLOP417_WHEEL_CRAB"), self.typeDesc), InputBinding.MERLOP417_WHEEL_MODE);
	elseif self.changeWheel == 2  then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MERLOP417_WHEEL_FRONT"), self.typeDesc), InputBinding.MERLOP417_WHEEL_MODE);
	end;
	
	g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MERLO_BACK_ATTACHER_UP"), self.typeDesc), InputBinding.MERLO_BACK_ATTACHER_UP);
	g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MERLO_BACK_ATTACHER_DOWN"), self.typeDesc), InputBinding.MERLO_BACK_ATTACHER_DOWN);
	
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.changeWheel = Utils.getNoNil(getXMLInt(xmlFile, key.."#changeWheel"),0);
	end;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'changeWheel="'..tostring(self.changeWheel)..'"';
	
	local nodes = nil;
	
	return attributes,nodes;
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:readStream(streamId, connection)
	self.changeWheel = streamReadInt32(streamId);
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:writeStream(streamId, connection)
	streamWriteInt32(streamId, self.changeWheel);
end;

--**********************************************************************************************************************************************************************************
MerloP417Event = {};
MerloP417Event_mt = Class(MerloP417Event, Event);

InitEventClass(MerloP417Event, "MerloP417Event");

function MerloP417Event:emptyNew()
    local self = Event:new(MerloP417Event_mt);
    self.className="MerloP417Event";
    return self;
end;

function MerloP417Event:new(vehicle, mode, state, angle)
    local self = MerloP417Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
	self.state = state;
	self.angle = angle;
    return self;
end;

function MerloP417Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadInt32(streamId);
	self.state = streamReadInt32(streamId);
	self.angle = streamReadFloat32(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function MerloP417Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, self.mode);
	streamWriteInt32(streamId, self.state);
	streamWriteFloat32(streamId, self.angle);
end;

function MerloP417Event:run(connection)
	self.vehicle:MPCode(self.mode, self.state, self.angle, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(MerloP417Event:new(self.vehicle, self.mode, self.state, self.angle), nil, connection, self.vehicle);
    end;
end;

function MerloP417Event.sendEvent(vehicle, mode, state, angle, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MerloP417Event:new(vehicle, mode, state, angle), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(MerloP417Event:new(vehicle, mode, state, angle));
		end;
	end;
end;