﻿--
-- Merlo P41.7 Turbofarmer
--
-- author  Mythos
-- date  02/08/2013
-- www.ARM-team.gr
-- Copyright (C) ARM Team, All Rights Reserved.

MerloP417 = {};

function MerloP417.prerequisitesPresent(specializations)
    return true;
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:load(xmlFile)

	-- Functions
	self.MPCode = SpecializationUtil.callSpecializationsFunction("MPCode");
	
	-- Indexs
	self.outCamera = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cameras.camera1#rotateNode"));
	self.refPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.refPoint#index"));
	self.refPointS = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.refPointS#index"));
	
	self.oldY = 0;

	self.changeWheel = 0;
	self.WheelBackup = {}
    for i=1, table.getn(self.wheels) do
		self.WheelBackup[i] = self.wheels[i].rotSpeed;
    end;
	
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:delete()
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:mouseEvent(posX, posY, isDown, isUp, button)
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:keyEvent(unicode, sym, modifier, isDown)
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:update(dt)
	
	if self:getIsActive() then
		
		if InputBinding.hasEvent(InputBinding.MERLOP417_WHEEL_MODE) then
			self.changeWheel = self.changeWheel+1;
		end;

		if self.changeWheel == 0  then
			self.wheels[1].rotSpeed = self.WheelBackup[1];
			self.wheels[2].rotSpeed = self.WheelBackup[2];
			self.wheels[3].rotSpeed = 0;
			self.wheels[4].rotSpeed = 0;
		elseif self.changeWheel == 1  then
			self.wheels[1].rotSpeed = self.WheelBackup[1];
			self.wheels[2].rotSpeed = self.WheelBackup[2];
			self.wheels[3].rotSpeed = self.WheelBackup[3];
			self.wheels[4].rotSpeed = self.WheelBackup[4];
		elseif self.changeWheel == 2  then
			self.wheels[1].rotSpeed = self.WheelBackup[1];
			self.wheels[2].rotSpeed = self.WheelBackup[2];
			self.wheels[3].rotSpeed = -self.WheelBackup[3];
			self.wheels[4].rotSpeed = -self.WheelBackup[4];
		elseif self.changeWheel == 3 then
			self.changeWheel = 0;
		end;
		
	end;
	
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:updateTick(dt)
	if self:getIsActive() then
		self:MPCode(1);
	end;
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:MPCode(mode, state, dtime, noEventSend)
	MerloP417Event.sendEvent(self, mode, state, dtime, noEventSend);

--______________________________________________________________________________
	if mode == 1 then
--_---_________________________ ADJUST OUT CAMERA HEIGHT _________________________
		local x,y,z = getWorldTranslation(self.refPoint);
		local x1,y1,z1 = getWorldTranslation(self.refPointS);
		local diff = y-y1;
		local diff1 = diff - self.oldY;
		if diff1~=0 then
			translate(self.outCamera, 0, diff1/4, 0);
		end;
		self.oldY = diff;
	end;

end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:draw()

	if self.changeWheel == 0  then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MERLOP417_WHEEL_ALL"), self.typeDesc), InputBinding.MERLOP417_WHEEL_MODE);
	elseif self.changeWheel == 1  then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MERLOP417_WHEEL_CRAB"), self.typeDesc), InputBinding.MERLOP417_WHEEL_MODE);
	elseif self.changeWheel == 2  then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("MERLOP417_WHEEL_FRONT"), self.typeDesc), InputBinding.MERLOP417_WHEEL_MODE);
	end;
	
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.changeWheel = Utils.getNoNil(getXMLInt(xmlFile, key.."#changeWheel"),0);
	end;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'changeWheel="'..tostring(self.changeWheel)..'"';
	
	local nodes = nil;
	
	return attributes,nodes;
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:readStream(streamId, connection)
	self.changeWheel = streamReadInt32(streamId);
end;

--________________________________________________________________________________________________________________________________________________________
function MerloP417:writeStream(streamId, connection)
	streamWriteInt32(streamId, self.changeWheel);
end;

--**********************************************************************************************************************************************************************************
MerloP417Event = {};
MerloP417Event_mt = Class(MerloP417Event, Event);

InitEventClass(MerloP417Event, "MerloP417Event");

function MerloP417Event:emptyNew()
    local self = Event:new(MerloP417Event_mt);
    self.className="MerloP417Event";
    return self;
end;

function MerloP417Event:new(vehicle, mode, state, dtime)
    local self = MerloP417Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
	self.state = state;
	self.dtime = dtime;
    return self;
end;

function MerloP417Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
	self.dtime = streamReadFloat32(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function MerloP417Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, self.mode);
	streamWriteBool(streamId, self.state);
	streamWriteFloat32(streamId, self.dtime);
end;

function MerloP417Event:run(connection)
	self.vehicle:MPCode(self.mode, self.state, self.dtime, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(MerloP417Event:new(self.vehicle, self.mode, self.state, self.dtime), nil, connection, self.vehicle);
    end;
end;

function MerloP417Event.sendEvent(vehicle, mode, state, dtime, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MerloP417Event:new(vehicle, mode, state, dtime), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(MerloP417Event:new(vehicle, mode, state, dtime));
		end;
	end;
end;