--
-- Autor: Hewaaa
-- Date: 24.01.2013
-- publisher: www.ls2013.org
--

MB_Vario_Gala = {};

function MB_Vario_Gala.prerequisitesPresent(specializations)
    return true; 
end;

function MB_Vario_Gala:load(xmlFile)

    self.trigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.triggerSaat#index"));
	table.insert(g_currentMission, SowingMachineFillTrigger:new(self.trigger));

	self.kWells = {};	
	
	local i = -1;
	while true do
		i = i + 1;
		local index = getXMLString(xmlFile, string.format('vehicle.kardanWelle.welle(%d)#index', i));
		if index == nil then break; end;
		local kw = {};
		kw.idz = Utils.indexToObject(self.components, index);
		kw.spd = getXMLFloat(xmlFile, string.format('vehicle.kardanWelle.welle(%d)#speed', i));
		table.insert(self.kWells, kw);
	end;

	self.MB_Vario_Gala = false;	
end;

function MB_Vario_Gala:readStream(streamId, connection)
	
end;

function MB_Vario_Gala:writeStream(streamId, connection)	
	
end;

function MB_Vario_Gala:delete()
	
end;

function MB_Vario_Gala:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MB_Vario_Gala:keyEvent(unicode, sym, modifier, isDown)
end;

function MB_Vario_Gala:update(dt)
	
	if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.MB_Vario_Gala_1) then
			self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet*(dt/10)));
		end;
		if InputBinding.isPressed(InputBinding.MB_Vario_Gala_2) then
			self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet*(dt/10)));
		end;

		if InputBinding.isPressed(InputBinding.MB_Vario_Gala_3) then
			self:setAnimationTime(2, self.animationParts[2].currentPosition+(self.animationParts[2].offSet*(dt/10)));
		end;
		if InputBinding.isPressed(InputBinding.MB_Vario_Gala_4) then
			self:setAnimationTime(2, self.animationParts[2].currentPosition-(self.animationParts[2].offSet*(dt/10)));
		end;

		if InputBinding.isPressed(InputBinding.MB_Vario_Gala_5) then
			self:setAnimationTime(3, self.animationParts[3].currentPosition+(self.animationParts[3].offSet*(dt/10)));
		end;
		if InputBinding.isPressed(InputBinding.MB_Vario_Gala_6) then
			self:setAnimationTime(3, self.animationParts[3].currentPosition-(self.animationParts[3].offSet*(dt/10)));
		end;

		if InputBinding.isPressed(InputBinding.MB_Vario_Gala_7) then
			self:setAnimationTime(4, self.animationParts[4].currentPosition+(self.animationParts[4].offSet*(dt/10)));
		end;
		if InputBinding.isPressed(InputBinding.MB_Vario_Gala_8) then
			self:setAnimationTime(4, self.animationParts[4].currentPosition-(self.animationParts[4].offSet*(dt/10)));
		end;
		if InputBinding.hasEvent(InputBinding.MB_Vario_Gala) then
			self.MB_Vario_Gala = not self.MB_Vario_Gala;
		end;
	end;

end;

function MB_Vario_Gala:updateTick(dt)

	local x,y,z = getRotation(self.wheels[4].driveNode);
	for i,welle in pairs(self.kWells) do
		setRotation(welle.idz, 0 ,0 ,x*welle.spd);			
	end;

end;

function MB_Vario_Gala:draw()
	if not self.MB_Vario_Gala then
		g_currentMission:addHelpButtonText(g_i18n:getText("MB_Vario_Gala"), InputBinding.MB_Vario_Gala);
	else
		renderText(0.78, 0.38, 0.02,  "Num 0: HUD Abschalten");
		renderText(0.78, 0.62, 0.02, 	  "Blinker Li.= KP_1");
    	renderText(0.78, 0.60, 0.02,     "Warnblinker = KP_2");
    	renderText(0.78, 0.58, 0.02,     "Blinker Re. = KP_3");
		renderText(0.78, 0.56, 0.02,     "RightDoor open = N");
		renderText(0.78, 0.54, 0.02,    "RightDoor close = J");
    	renderText(0.78, 0.52, 0.02,      "LeftDoor open = M");	
		renderText(0.78, 0.50, 0.02,     "LeftDoor close = K");
    	renderText(0.78, 0.48, 0.02,      "SideDoor open = V");	
		renderText(0.78, 0.46, 0.02,     "SideDoor close = B");
		renderText(0.78, 0.44, 0.02,      "RearDoor open = Y");
		renderText(0.78, 0.42, 0.02,     "RearDoor close = X");
	end;
end;

function MB_Vario_Gala:onLeave()
	self.MB_Vario_Gala = false;	
end;