--
-- Autor: Hewaaa
-- Date: 28.08.2013
-- publisher: www.ls2013.org
--

MB_Vario_ADAC = {};

function MB_Vario_ADAC.prerequisitesPresent(specializations)
    return true; 
end;

function MB_Vario_ADAC:load(xmlFile)

    self.trigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trigger#index"));
	table.insert(g_currentMission, GasStation:new(self.trigger));

	self.kWells = {};	
	
	local i = -1;
	while true do
		i = i + 1;
		local index = getXMLString(xmlFile, string.format('vehicle.kardanWelle.welle(%d)#index', i));
		if index == nil then break; end;
		local kw = {};
		kw.idz = Utils.indexToObject(self.components, index);
		kw.spd = getXMLFloat(xmlFile, string.format('vehicle.kardanWelle.welle(%d)#speed', i));
		table.insert(self.kWells, kw);
	end;

	self.MB_Vario_ADAC = false;	
end;

function MB_Vario_ADAC:readStream(streamId, connection)
	
end;

function MB_Vario_ADAC:writeStream(streamId, connection)	
	
end;

function MB_Vario_ADAC:delete()
	
end;

function MB_Vario_ADAC:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MB_Vario_ADAC:keyEvent(unicode, sym, modifier, isDown)
end;

function MB_Vario_ADAC:update(dt)
	
	if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.MB_Vario_ADAC_1) then
			self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet*(dt/10)));
		end;
		if InputBinding.isPressed(InputBinding.MB_Vario_ADAC_2) then
			self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet*(dt/10)));
		end;

		if InputBinding.isPressed(InputBinding.MB_Vario_ADAC_3) then
			self:setAnimationTime(2, self.animationParts[2].currentPosition+(self.animationParts[2].offSet*(dt/10)));
		end;
		if InputBinding.isPressed(InputBinding.MB_Vario_ADAC_4) then
			self:setAnimationTime(2, self.animationParts[2].currentPosition-(self.animationParts[2].offSet*(dt/10)));
		end;

		if InputBinding.isPressed(InputBinding.MB_Vario_ADAC_5) then
			self:setAnimationTime(3, self.animationParts[3].currentPosition+(self.animationParts[3].offSet*(dt/10)));
		end;
		if InputBinding.isPressed(InputBinding.MB_Vario_ADAC_6) then
			self:setAnimationTime(3, self.animationParts[3].currentPosition-(self.animationParts[3].offSet*(dt/10)));
		end;

		if InputBinding.isPressed(InputBinding.MB_Vario_ADAC_7) then
			self:setAnimationTime(4, self.animationParts[4].currentPosition+(self.animationParts[4].offSet*(dt/10)));
		end;
		if InputBinding.isPressed(InputBinding.MB_Vario_ADAC_8) then
			self:setAnimationTime(4, self.animationParts[4].currentPosition-(self.animationParts[4].offSet*(dt/10)));
		end;
		if InputBinding.hasEvent(InputBinding.MB_Vario_ADAC) then
			self.MB_Vario_ADAC = not self.MB_Vario_ADAC;
		end;
	end;

end;

function MB_Vario_ADAC:updateTick(dt)

	local x,y,z = getRotation(self.wheels[4].driveNode);
	for i,welle in pairs(self.kWells) do
		setRotation(welle.idz, 0 ,0 ,x*welle.spd);			
	end;

end;

function MB_Vario_ADAC:draw()
	if not self.MB_Vario_ADAC then
		g_currentMission:addHelpButtonText(g_i18n:getText("MB_Vario_ADAC"), InputBinding.MB_Vario_ADAC);
	else
		renderText(0.78, 0.34, 0.02,  "Num 0: HUD Abschalten");
		renderText(0.78, 0.62, 0.02, 	  "Blinker Li.= KP_1");
    	renderText(0.78, 0.60, 0.02,     "Warnblinker = KP_2");
    	renderText(0.78, 0.58, 0.02,     "Blinker Re. = KP_3");
		renderText(0.78, 0.56, 0.02,     "RightDoor open = N");
		renderText(0.78, 0.54, 0.02,    "RightDoor close = J");
    	renderText(0.78, 0.52, 0.02,      "LeftDoor open = M");	
		renderText(0.78, 0.50, 0.02,     "LeftDoor close = K");
    	renderText(0.78, 0.48, 0.02,      "SideDoor open = V");	
		renderText(0.78, 0.46, 0.02,     "SideDoor close = B");
		renderText(0.78, 0.44, 0.02,      "RearDoor open = Y");
		renderText(0.78, 0.42, 0.02,     "RearDoor close = X");
	end;
end;

function MB_Vario_ADAC:onLeave()
	self.MB_Vario_ADAC = false;	
end;