--
-- Autor: Hewaaa
-- Date: 24.01.2013
-- publisher: www.ls2013.org
--

MB_Vario_PB = {};

function MB_Vario_PB.prerequisitesPresent(specializations)
    return true; 
end;

function MB_Vario_PB:load(xmlFile)

	self.kWells = {};	

	local i = -1;
	while true do
		i = i + 1;
		local index = getXMLString(xmlFile, string.format('vehicle.kardanWelle.welle(%d)#index', i));
		if index == nil then break; end;
		local kw = {};
		kw.idz = Utils.indexToObject(self.components, index);
		kw.spd = getXMLFloat(xmlFile, string.format('vehicle.kardanWelle.welle(%d)#speed', i));
		table.insert(self.kWells, kw);
	end;

	self.MB_Vario_PB = false;	
end;

function MB_Vario_PB:readStream(streamId, connection)
	
end;

function MB_Vario_PB:writeStream(streamId, connection)	
	
end;

function MB_Vario_PB:delete()
	
end;

function MB_Vario_PB:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MB_Vario_PB:keyEvent(unicode, sym, modifier, isDown)
end;

function MB_Vario_PB:update(dt)
	
	if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.MB_Vario_PB_1) then
			self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet*(dt/10)));
		end;
		if InputBinding.isPressed(InputBinding.MB_Vario_PB_2) then
			self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet*(dt/10)));
		end;

		if InputBinding.isPressed(InputBinding.MB_Vario_PB_3) then
			self:setAnimationTime(2, self.animationParts[2].currentPosition+(self.animationParts[2].offSet*(dt/10)));
		end;
		if InputBinding.isPressed(InputBinding.MB_Vario_PB_4) then
			self:setAnimationTime(2, self.animationParts[2].currentPosition-(self.animationParts[2].offSet*(dt/10)));
		end;

		if InputBinding.isPressed(InputBinding.MB_Vario_PB_5) then
			self:setAnimationTime(3, self.animationParts[3].currentPosition+(self.animationParts[3].offSet*(dt/10)));
		end;
		if InputBinding.isPressed(InputBinding.MB_Vario_PB_6) then
			self:setAnimationTime(3, self.animationParts[3].currentPosition-(self.animationParts[3].offSet*(dt/10)));
		end;

		if InputBinding.isPressed(InputBinding.MB_Vario_PB_7) then
			self:setAnimationTime(4, self.animationParts[4].currentPosition+(self.animationParts[4].offSet*(dt/10)));
		end;
		if InputBinding.isPressed(InputBinding.MB_Vario_PB_8) then
			self:setAnimationTime(4, self.animationParts[4].currentPosition-(self.animationParts[4].offSet*(dt/10)));
		end;
		if InputBinding.hasEvent(InputBinding.MB_Vario_PB) then
			self.MB_Vario_PB = not self.MB_Vario_PB;
		end;
	end;

end;

function MB_Vario_PB:updateTick(dt)

	local x,y,z = getRotation(self.wheels[4].driveNode);
	for i,welle in pairs(self.kWells) do
		setRotation(welle.idz, 0 ,0 ,x*welle.spd);			
	end;

end;

function MB_Vario_PB:draw()
	if not self.MB_Vario_PB then
		g_currentMission:addHelpButtonText(g_i18n:getText("MB_Vario_PB"), InputBinding.MB_Vario_PB);
	else
		renderText(0.78, 0.34, 0.02,  "Num 0: HUD Abschalten");
		renderText(0.78, 0.62, 0.02, 	  "Blinker Li.= KP_1");
    	renderText(0.78, 0.60, 0.02,     "Warnblinker = KP_2");
    	renderText(0.78, 0.58, 0.02,     "Blinker Re. = KP_3");
		renderText(0.78, 0.56, 0.02,     "RightDoor open = N");
		renderText(0.78, 0.54, 0.02,    "RightDoor close = J");
    	renderText(0.78, 0.52, 0.02,      "LeftDoor open = M");	
		renderText(0.78, 0.50, 0.02,     "LeftDoor close = K");
    	renderText(0.78, 0.48, 0.02,      "SideDoor open = V");	
		renderText(0.78, 0.46, 0.02,     "SideDoor close = B");
		renderText(0.78, 0.44, 0.02,      "RearDoor open = Y");
		renderText(0.78, 0.42, 0.02,     "RearDoor close = X");
		renderText(0.78, 0.40, 0.02,       "Stadthorn = KP_7");
		renderText(0.78, 0.38, 0.02,        "Landhorn = KP_8");
		renderText(0.78, 0.36, 0.02, 	   "Pressluft = KP_9");
	end;
end;

function MB_Vario_PB:onLeave()
	self.MB_Vario_PB = false;	
end;