--
-- Bitren trailer
--
-- @author  Benjamin Biot [Bayn] 
-- @date  13/11/09
-- www.tsforum3.com
-- 

Bitren2 = {};

function Bitren2.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Bitren2:load(xmlFile)

	-- Animations and moving collisions --

	self.connectCollisions = SpecializationUtil.callSpecializationsFunction("connectCollisions");
	self.anim = SpecializationUtil.callSpecializationsFunction("anim");
  	self.charId = {};
	self.clipIndex = {};
	self.Go = {}; 
	self.Done = {};
	self.CheckDone = {};
	self.collisionArm = {}; 
	self.moveColli = {}; 
	local count = getXMLInt(xmlFile, "vehicle.animParts#count");
    self.animParts = {}
	local part = self.animParts;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.animParts.part".."%d", i);
	    local nameR = getXMLString(xmlFile, partname.."#name");
		self.charId[nameR] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.."#rootNode"));
		self.clipIndex[nameR] = getXMLString(xmlFile, partname.."#animationClip");
		self.CheckDone[nameR] = false;
		
		self.moveColli[nameR] = getXMLString(xmlFile, partname.."#moveColli");
		if self.moveColli[nameR] ~= nil then
			local Collision = {};
			Collision.collision = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.."#collision"));
			Collision.collisionAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.."#collsionAttacher"));
			Collision.armAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname.. "#armAttacher"));
			Collision.index = 0;
			self.collisionArm[nameR] = Collision;
			self:connectCollisions(nameR);
		end; 
	end; 	
	
	-- selfs --
	
	

	
end;

function Bitren2:delete()
end;

function Bitren2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Bitren2:keyEvent(unicode, sym, modifier, isDown)
end;

function Bitren2:update(dt)
				
	if self.attacherVehicle then  
		
		if InputBinding.hasEvent(InputBinding.BACHE2) then
			self.Go.bache = not self.Go.bache; 
			self.Done.bache = true; 
		end;


	-- Animations --
		if self.Go.bache ~= nil and self.Done.bache ~= false then			
		self:anim("bache",false); 
		end; 
		if self.Go.support ~= nil and self.Done.support ~= false then
		self:anim("support", false); 
		end; 		
	
	-- Display info when in range --
		
	
			
	end;
end;

function Bitren2:draw()
	if self.attacherVehicle then
		if self.CheckDone.bache then
			g_currentMission:addExtraPrintText(string.format("Key %s: Estender Lona Bitren 2", InputBinding.getKeyNamesOfDigitalAction(InputBinding.BACHE2)));			
		else
			g_currentMission:addExtraPrintText(string.format("Key %s: Retirar Lona Bitren 2", InputBinding.getKeyNamesOfDigitalAction(InputBinding.BACHE2)));
		end;
                if self.CheckDone.support then
			g_currentMission:addExtraPrintText(string.format("Key %s: Baixar Cavalete Bitren 2", InputBinding.getKeyNamesOfDigitalAction(InputBinding.KAISUPPORT2)));
		else
			g_currentMission:addExtraPrintText(string.format("Key %s: Levantar Cavalete Bitren 2", InputBinding.getKeyNamesOfDigitalAction(InputBinding.KAISUPPORT2)));
		end;
	end;
end;

function Bitren2:onDetach()
end;

function Bitren2:onAttach()
end; 

function Bitren2:anim(varName, loopCheck)
	if self.moveColli[varName] ~= nil then
		local Collision = self.collisionArm[varName];
		setJointFrame(Collision.index, 0, Collision.armAttacher);
	end;
	
	if self.Go[varName] == true and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, 1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
			disableAnimTrack(charId, 0);	
			self.Done[varName] = false;	
			self.CheckDone[varName] = true;	     
		end; 
	elseif self.Go[varName] == false and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		if loopCheck == true then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
		end; 	
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, -1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) <= 0 then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
			self.CheckDone[varName] = false;
		end;
	end;
end; 	


function Bitren2:connectCollisions(varName)
	local Collision = self.collisionArm[varName];
	local constr = JointConstructor:new();
	constr:setActors(self.rootNode, Collision.collision);
	constr:setJointTransforms(Collision.armAttacher, Collision.collisionAttacher);
	for i=1, 3 do		            
		constr:setRotationLimit(i-1, 0, 0, 0);
		constr:setTranslationLimit(i-1, true, 0, 0);
	end;
	Collision.index = constr:finalize();
end;

