if not _G.g_wrapperBaleFixEnabled then
  _G.g_wrapperBaleFixEnabled = true
  do
    local Bale_setNodeId = Bale.setNodeId
    function Bale:setNodeId(nodeId)
      Bale_setNodeId(self, nodeId)
      local baleWidth = tonumber(getUserAttribute(nodeId, "baleWidth"))
      local baleHeight = tonumber(getUserAttribute(nodeId, "baleHeight"))
      local baleLength = tonumber(getUserAttribute(nodeId, "baleLength"))
      local baleDiameter = tonumber(getUserAttribute(nodeId, "baleDiameter"))
      if baleDiameter ~= nil and baleWidth ~= nil then
        self.baleDiameter = baleDiameter
        self.baleWidth = baleWidth
      elseif baleHeight ~= nil and baleWidth ~= nil and baleLength ~= nil then
        self.baleHeight = baleHeight
        self.baleWidth = baleWidth
        self.baleLength = baleLength
      else
        local isRoundbale = Utils.getNoNil(getUserAttribute(nodeId, "isRoundbale"), false)
        if isRoundbale then
          self.baleDiameter = 1.8
          self.baleWidth = 1.2
        else
          self.baleHeight = 0.8
          self.baleWidth = 1.2
          self.baleLength = 2.2
        end
      end
    end
    local Bale_readStream = Bale.readStream
    function Bale:readStream(streamId, connection)
      Bale_readStream(self, streamId, connection)
      if self.supportsWrapping then
        self:setWrappingState(streamReadUInt8(streamId) / 255)
        setShaderParameter(self.baleMesh, "wrappingState", self.wrappingState, 0, 0, 0, false)
      end
    end
    local Bale_writeStream = Bale.writeStream
    function Bale:writeStream(streamId, connection)
      Bale_writeStream(self, streamId, connection)
      if self.supportsWrapping then
        streamWriteUInt8(streamId, Utils.clamp(self.wrappingState * 255, 0, 255))
      end
    end
    local Bale_readUpdateStream = Bale.readUpdateStream
    function Bale:readUpdateStream(streamId, timestamp, connection)
      if Bale_readUpdateStream ~= nil then
        Bale_readUpdateStream(self, streamId, timestamp, connection)
      end
      if connection:getIsServer() and self.supportsWrapping then
        self:setWrappingState(streamReadUInt8(streamId) / 255)
      end
    end
    local Bale_writeUpdateStream = Bale.writeUpdateStream
    function Bale:writeUpdateStream(streamId, connection, dirtyMask)
      if Bale_writeUpdateStream ~= nil then
        Bale_writeUpdateStream(self, streamId, connection, dirtyMask)
      end
      if not connection:getIsServer() and self.supportsWrapping then
        streamWriteUInt8(streamId, Utils.clamp(self.wrappingState * 255, 0, 255))
      end
    end
    function Bale:setWrappingState(wrappingState)
      if self.supportsWrapping then
        if self.wrappingState ~= wrappingState then
          self:raiseDirtyFlags(self.physicsObjectDirtyFlag)
        end
        self.wrappingState = wrappingState
        setShaderParameter(self.baleMesh, "wrappingState", self.wrappingState, 0, 0, 0, false)
      end
    end
  end
end
