SetWheelVariablesEvent = {};
SetWheelVariablesEvent_mt = Class(SetWheelVariablesEvent, Event);

InitEventClass(SetWheelVariablesEvent, "SetWheelVariablesEvent");

function SetWheelVariablesEvent:emptyNew()
    local self = Event:new(SetWheelVariablesEvent_mt);
    self.className="SetWheelVariablesEvent";
    return self;
end;

function SetWheelVariablesEvent:new(vehicle, motorTorque, brakePedal)
    local self = SetWheelVariablesEvent:emptyNew()
    self.vehicle = vehicle;
	self.motorTorque = motorTorque;
	self.brakePedal = brakePedal;
    return self;
end;

function SetWheelVariablesEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.motorTorque = streamReadFloat32(streamId);
	self.brakePedal = streamReadFloat32(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetWheelVariablesEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteFloat32(streamId, self.motorTorque);
	streamWriteFloat32(streamId, self.brakePedal);
end;

function SetWheelVariablesEvent:run(connection)
	self.vehicle:setWheelVariables(self.motorTorque, self.brakePedal);
end;
