-- Power Command update wheel physics event-class
UpdateWheelsPhysicsEvent = {};
UpdateWheelsPhysicsEvent_mt = Class(UpdateWheelsPhysicsEvent, Event);

InitEventClass(UpdateWheelsPhysicsEvent, "UpdateWheelsPhysicsEvent");

function UpdateWheelsPhysicsEvent:emptyNew()
    local self = Event:new(UpdateWheelsPhysicsEvent_mt);
    self.className="UpdateWheelsPhysicsEvent";
    return self;
end;

function UpdateWheelsPhysicsEvent:new(vehicle, dt, acceleration, brake)
    local self = UpdateWheelsPhysicsEvent:emptyNew()
    self.vehicle = vehicle;
	self.dt = dt;
	self.acceleration = acceleration;
	self.brake = brake;
    return self;
end;

function UpdateWheelsPhysicsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.dt = streamReadFloat32(streamId);
	self.acceleration = streamReadFloat32(streamId);
	self.brake = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function UpdateWheelsPhysicsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteFloat32(streamId, self.dt);
	streamWriteFloat32(streamId, self.acceleration);
	streamWriteBool(streamId, self.brake);
end;

function UpdateWheelsPhysicsEvent:run(connection)
	self.vehicle:updateWheelsPhysics(self.dt, self.acceleration, self.brake, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(UpdateWheelsPhysicsEvent:new(self.vehicle, self.dt, self.acceleration, self.brake), nil, connection, self.vehicle);
    end;
end;

function UpdateWheelsPhysicsEvent.sendEvent(vehicle, dt, acceleration, brake, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(UpdateWheelsPhysicsEvent:new(vehicle, dt, acceleration, brake), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(UpdateWheelsPhysicsEvent:new(vehicle, dt, acceleration, brake));
		end;
	end;
end;
