--
-- Copyright ? 2013 Joacim Sigfridsson <joxxer@msn.com>
-- This work is free. You can redistribute it and/or modify it under the
-- terms of the Do What The Fuck You Want To Public License, Version 2,
-- as published by Sam Hocevar. See http://www.wtfpl.net/ for more details.
--
--
-- BJR_PivotingAxle
-- Specialization for pivoting axle mod
--
-- @author  	JoXXer
-- @date  		01/08/13
--
-- @history		v1.0 - Initial implementation
--				v1.0.2 - 30/09/13 - Camber adjustments as suggested by dural
--

BJR_PivotingAxle = {};

function BJR_PivotingAxle.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function BJR_PivotingAxle:load(xmlFile)

	-- Front axle animation
	self.frontAxle = {};
	self.frontAxle.rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAxle#rotNode"));
	
	if self.frontAxle.rotNode ~= nil then
		local ax, ay, az = getTranslation(self.wheels[1].repr);
		self.frontAxle.origWheelYTrans = ay;
		
		local x, y, z = getTranslation(self.frontAxle.rotNode);
		
		setTranslation(self.frontAxle.rotNode, x, ay, z);
		
		self.frontAxle.origXTrans = x;
		self.frontAxle.origYTrans = ay;
		self.frontAxle.origZTrans = z;
	end;
	
	self.frontAxle.steeringPiston = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAxle#steeringPiston"));

	if self.frontAxle.steeringPiston ~= nil then
		self.frontAxle.steeringMaxTrans = getXMLFloat(xmlFile, "vehicle.frontAxle#steeringMaxTrans");
		self.frontAxle.steeringMinTrans = getXMLFloat(xmlFile, "vehicle.frontAxle#steeringMinTrans");
	
		local x, y, z = getTranslation(self.frontAxle.steeringPiston);
		self.frontAxle.steeringPistonOrigY = y;
		self.frontAxle.steeringPistonOrigZ = z;
	end;
	
	-- Animated wheels
	self.numAnimatedWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.animatedWheels#count"), 0);
	self.wheelCamberAngle = (Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animatedWheels#camberAngle"), 0))/100;
	self.fenderAngle = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.animatedWheels#fenderAngle"), 0);
	self.animatedWheel = {};
    for i=1, self.numAnimatedWheels do
        local objname = string.format("vehicle.animatedWheels.wheel" .. "%d", i);
		self.animatedWheel[i] = {};
        self.animatedWheel[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		self.animatedWheel[i].wheel = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#wheelIndex"));
		self.animatedWheel[i].fenderAttach = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#fenderAttach"));
    end;
end;

function BJR_PivotingAxle:delete()
end;

function BJR_PivotingAxle:readStream(streamId, connection)
end;

function BJR_PivotingAxle:writeStream(streamId, connection)
end;

function BJR_PivotingAxle:readUpdateStream(streamId, timestamp, connection)
end;

function BJR_PivotingAxle:writeUpdateStream(streamId, connection, dirtyMask)
end;

function BJR_PivotingAxle:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BJR_PivotingAxle:keyEvent(unicode, sym, modifier, isDown)
end;

function BJR_PivotingAxle:update(dt)
	if self:getIsActive() then
		if self.frontAxle.rotNode ~= nil and self.wheels[1].repr ~= nil and self.wheels[2].repr ~= nil then
			local ax, ay, az = getWorldTranslation(self.wheels[1].repr);
			local bx, by, bz = getWorldTranslation(self.wheels[2].repr);
			local x, y, z = worldDirectionToLocal(getParent(self.frontAxle.rotNode), bx-ax, by-ay, bz-az);
	
			setDirection(self.frontAxle.rotNode, x, y, z, 1, 0, 1);
	
			local x2,y2,z2 = getRotation(self.frontAxle.rotNode);
			
			--renderText(0.5, 0.65, 0.040, "x=" .. string.format((x2/3.14) * 180));
			--renderText(0.5, 0.75, 0.040, "y=" .. string.format((y2/3.14) * 180));
			--renderText(0.5, 0.85, 0.040, "z=" .. string.format((z2/3.14) * 180));
	
			setRotation(self.frontAxle.rotNode,x2 - math.rad(90),y2,z2 + math.rad(90));
			
			-- Front suspension
		end;
	
		-- Making the visible wheels rotate
		if self.wheels[1].repr ~= nil and self.wheels[2].repr ~= nil then
			local x,y,z = getRotation(self.wheels[1].driveNode);
			local x2,y2,z2 = getRotation(self.wheels[1].repr);
			setRotation(self.animatedWheel[1].wheel, x,y,z);
			setRotation(self.animatedWheel[1].rotNode, x2,y2,z2);
	
			local x3,y3,z3 = getRotation(self.wheels[2].driveNode);
			local x4,y4,z4 = getRotation(self.wheels[2].repr);
			setRotation(self.animatedWheel[2].wheel, x3,y3,z3);
			setRotation(self.animatedWheel[2].rotNode, x4,y4,z4);
			
			if self.frontAxle.steeringPiston ~= nil then
				local newSteeringXTrans = 0;
				
				if y2 < 0 then
					newSteeringXTrans = (self.frontAxle.steeringMinTrans/self.wheels[1].rotMin) * y2;
				elseif y2 > 0 then
					newSteeringXTrans = (self.frontAxle.steeringMaxTrans/self.wheels[1].rotMax) * y2;
				end;
				
				setTranslation(self.frontAxle.steeringPiston, -newSteeringXTrans, self.frontAxle.steeringPistonOrigY, self.frontAxle.steeringPistonOrigZ);
			end;
		end;
	
		-- Dynamic fenders
		if self.animatedWheel[1].fenderAttach ~= nil and self.animatedWheel[2].fenderAttach ~= nil then
			local x, y, z = getRotation(self.animatedWheel[1].rotNode);
			local x2, y2, z2 = getRotation(self.animatedWheel[2].rotNode);
	
			local fenderYRot = -y + math.rad(self.fenderAngle);
			local fenderY2Rot = -y2 + math.rad(-self.fenderAngle);
	
			if y > math.rad(self.fenderAngle) then
				setRotation(self.animatedWheel[1].fenderAttach, x, fenderYRot, z);
			else
				setRotation(self.animatedWheel[1].fenderAttach, x, 0, z);
			end;
			
			if y2 < math.rad(-self.fenderAngle) then
				setRotation(self.animatedWheel[2].fenderAttach, x2, fenderY2Rot, z2);
			else
				setRotation(self.animatedWheel[2].fenderAttach, x2, 0, z2);
			end;
	
			--local x3,y3,z3 = getRotation(self.animatedWheel[1].fenderAttach);
			--renderText(0.5, 0.65, 0.040, string.format(y3));
	
			--local x4,y4,z4 = getRotation(self.animatedWheel[2].fenderAttach);
			--renderText(0.5, 0.55, 0.040, string.format(y4));
		end;
		
		
		-- camber angle wheels 
		if self.wheelCamberAngle ~= 0 and self.animatedWheel[1].rotNode ~= nil and self.animatedWheel[2].rotNode ~= nil then
			local x, y, z = getRotation(self.animatedWheel[1].rotNode);
			local x2, y2, z2 = getRotation(self.animatedWheel[2].rotNode);
			
			local nodeZRot = -y * self.wheelCamberAngle;
			local nodeZ2Rot = -y2 * self.wheelCamberAngle;
			
			setRotation(self.animatedWheel[1].rotNode, x, y, nodeZRot);
			setRotation(self.animatedWheel[2].rotNode, x2, y2, nodeZ2Rot);
		end;
	end;
end;

function BJR_PivotingAxle:updateTick(dt)
	if self:getIsActive() then	
	end;
end;

function BJR_PivotingAxle:draw()
end;

