--
-- Henly20 (Ls_uk Modteam)
-- 23.08.2010
--
-- > www.LS-UK.info

footbrake4000 = {};

function footbrake4000.prerequisitesPresent(specializations)
	Vehicle.registerJointType("frontloader");
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function footbrake4000:load(xmlFile)

	local rotationPartNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart1#index"));
		if rotationPartNode1 ~= nil then
        self.rotationPart1 = {};
        self.rotationPart1.node = rotationPartNode1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#minRot"));
        self.rotationPart1.minRot = {};
        self.rotationPart1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#maxRot"));
        self.rotationPart1.maxRot = {};
        self.rotationPart1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#rotTime"), 2)*1000;
        self.rotationPart1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#touchRotLimit"), 10));
    end;
	local rotationPartNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart4#index"));
		if rotationPartNode4 ~= nil then
        self.rotationPart4 = {};
        self.rotationPart4.node = rotationPartNode4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#minRot"));
        self.rotationPart4.minRot = {};
        self.rotationPart4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#maxRot"));
        self.rotationPart4.maxRot = {};
        self.rotationPart4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#rotTime"), 2)*1000;
        self.rotationPart4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#touchRotLimit"), 10));
    end;
	local rotationPartNode7 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart7#index"));
    if rotationPartNode7 ~= nil then
        self.rotationPart7 = {};
        self.rotationPart7.node = rotationPartNode7;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart7#minRot"));
        self.rotationPart7.minRot = {};
        self.rotationPart7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart7#maxRot"));
        self.rotationPart7.maxRot = {};
        self.rotationPart7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart7#rotTime"), 2)*1000;
        self.rotationPart7.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart7#touchRotLimit"), 10));
    end;
	local rotationPartNode8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart8#index"));
    if rotationPartNode8 ~= nil then
        self.rotationPart8 = {};
        self.rotationPart8.node = rotationPartNode8;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart8#minRot"));
        self.rotationPart8.minRot = {};
        self.rotationPart8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart8#maxRot"));
        self.rotationPart8.maxRot = {};
        self.rotationPart8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart8#rotTime"), 2)*1000;
        self.rotationPart8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart8#touchRotLimit"), 10));
    end;
	local rotationPartNode9 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart9#index"));
    if rotationPartNode9 ~= nil then
        self.rotationPart9 = {};
        self.rotationPart9.node = rotationPartNode9;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart9#minRot"));
        self.rotationPart9.minRot = {};
        self.rotationPart9.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart9.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart9.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart9#maxRot"));
        self.rotationPart9.maxRot = {};
        self.rotationPart9.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart9.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart9.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart9.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart9#rotTime"), 2)*1000;
        self.rotationPart9.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart9#touchRotLimit"), 10));
    end;
	local rotationPartNode10 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart10#index"));
    if rotationPartNode10 ~= nil then
        self.rotationPart10 = {};
        self.rotationPart10.node = rotationPartNode10;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart10#minRot"));
        self.rotationPart10.minRot = {};
        self.rotationPart10.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart10.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart10.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart10#maxRot"));
        self.rotationPart10.maxRot = {};
        self.rotationPart10.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart10.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart10.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart10.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart10#rotTime"), 2)*1000;
        self.rotationPart10.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart10#touchRotLimit"), 10));
    end;
	local rotationPartNode11 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart11#index"));
    if rotationPartNode11 ~= nil then
        self.rotationPart11 = {};
        self.rotationPart11.node = rotationPartNode11;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart11#minRot"));
        self.rotationPart11.minRot = {};
        self.rotationPart11.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart11.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart11.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart11#maxRot"));
        self.rotationPart11.maxRot = {};
        self.rotationPart11.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart11.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart11.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart11.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart11#rotTime"), 2)*1000;
        self.rotationPart11.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart11#touchRotLimit"), 10));
    end;

	self.rotationMax4Active = false;
	self.rotationMax8Active = false;
	self.rotationMax9Active = false;
    self.braking = false; 
end;

function footbrake4000:keyEvent(unicode, sym, modifier, isDown)
	if self.isEntered then 
		if sym == Input.KEY_KP_plus then
			self.rotationMax7 = isDown;
		end;	
		if sym == Input.KEY_KP_minus then
			self.rotationMin7 = isDown;
		end;
		if isDown and sym == Input.KEY_v   then
			self.rotationMax10 = not self.rotationMax10;
		end;
	end;
end;

function footbrake4000:update(dt)
	
		inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

        if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
        end;

		
		if self.isEntered ~= nil then

		if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
			self.braking = true;
			self.rotationMax4Active = true;
			self.rotationMax8Active = true;
			self.rotationMax9Active = true;
		else
			self.braking = false;
			self.rotationMax4Active = false;
			self.rotationMax8Active = false;
			self.rotationMax9Active = false;
		end;
    end;
	
		local maxrpmneedle = 1700;
			if self.rotationPart1 ~= nil then
				local x, y, z = getRotation(self.rotationPart1.node);
				y = ((self.rotationPart1.maxRot[2] - self.rotationPart1.minRot[2]) / maxrpmneedle) * (self.motor.lastMotorRpm/2.2) + self.rotationPart1.minRot[2];
				setRotation(self.rotationPart1.node, x, y ,z);
			end;
		
		if self.rotationPart4 ~= nil then
			local x, y, z = getRotation(self.rotationPart4.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart4.maxRot, self.rotationPart4.minRot, 3, self.rotationPart4.rotTime, dt, not self.rotationMax4Active);
			setRotation(self.rotationPart4.node, unpack(newRot));
		end;
		if self.rotationPart7 ~= nil and (self.rotationMax7 or self.rotationMin7) then
			local x, y, z = getRotation(self.rotationPart7.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart7.maxRot, self.rotationPart7.minRot, 3, self.rotationPart7.rotTime, dt, not self.rotationMax7);
			setRotation(self.rotationPart7.node, unpack(newRot));
		end;
		if self.rotationPart8 ~= nil then
			local x, y, z = getRotation(self.rotationPart8.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart8.maxRot, self.rotationPart8.minRot, 3, self.rotationPart8.rotTime, dt, not self.rotationMax8Active);
			setRotation(self.rotationPart8.node, unpack(newRot));
		end;
		if self.rotationPart9 ~= nil then
			local x, y, z = getRotation(self.rotationPart9.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart9.maxRot, self.rotationPart9.minRot, 3, self.rotationPart9.rotTime, dt, not self.rotationMax9Active);
			setRotation(self.rotationPart9.node, unpack(newRot));
		end;
		if self.rotationPart10 ~= nil then
			local x, y, z = getRotation(self.rotationPart10.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart10.maxRot, self.rotationPart10.minRot, 3, self.rotationPart10.rotTime, dt, not self.rotationMax10);
			setRotation(self.rotationPart10.node, unpack(newRot));
		end;	
		local maxhandthrottle = 2000;
			if self.rotationPart11 ~= nil then
				local x, y, z = getRotation(self.rotationPart11.node);
				y = ((self.rotationPart11.maxRot[2] - self.rotationPart11.minRot[2]) / maxhandthrottle) * (self.motor.lastMotorRpm/2.2) + self.rotationPart11.minRot[2];
				setRotation(self.rotationPart11.node, x, y ,z);
			end;

end;

function footbrake4000:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

function footbrake4000:draw()
end;

function footbrake4000:onEnter()
  
end;

function footbrake4000:onLeave()
 
end;

function footbrake4000:delete()
end;


function footbrake4000:mouseEvent(posX, posY, isDown, isUp, button)
end;