--
-- ProgressiveArticulatedSteer
-- Specialization class for MF 1200 and 1250 steer speed at high speed
--
-- @author  PeterJ - euroDZN
-- @date  16/03/2014
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.

ProgressiveArticulatedSteer = {};

function ProgressiveArticulatedSteer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations) and SpecializationUtil.hasSpecialization(ArticulatedAxis, specializations);
end;

function ProgressiveArticulatedSteer:load(xmlFile)

	self.lowSpeedSteer = self.articulatedAxis.rotSpeed;
	local steerSpeed = getXMLFloat(xmlFile, "vehicle.articulatedAxis.progressiveSteer#highSpeedSteerSpeed");
	if steerSpeed ~= nil then
		self.highSpeedSteer = math.rad(steerSpeed);
	end;
end;

function ProgressiveArticulatedSteer:delete()
end;

function ProgressiveArticulatedSteer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ProgressiveArticulatedSteer:keyEvent(unicode, sym, modifier, isDown)
end;

function ProgressiveArticulatedSteer:update(dt)
	if self:getIsActive() then
		if self.lowSpeedSteer ~= nil and self.highSpeedSteer ~= nil then
			local speedFactor = (self.lastSpeed*3600)/155;
			local articulateSpeed = math.max(self.lowSpeedSteer, self.lowSpeedSteer + speedFactor);
			if articulateSpeed >= self.highSpeedSteer then
				self.articulatedAxis.rotSpeed = self.highSpeedSteer;
			else
				self.articulatedAxis.rotSpeed = articulateSpeed;
			end;
		end;
	end;
end;

function ProgressiveArticulatedSteer:draw()
end;