--
-- MFwipers
-- Specialization class for MF 1200 and 1250 wipers
--
-- @author  PeterJ - euroDZN
-- @date  18/02/2014
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.

MFwipers = {};

function MFwipers.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations) and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function MFwipers:load(xmlFile)

	self.wipersAnim = getXMLString(xmlFile, "vehicle.wipers#animationName");
	self.wipersButton = getXMLString(xmlFile, "vehicle.wipers#buttonAnim");
	self.wipersSpeed = getXMLFloat(xmlFile, "vehicle.wipers#speed");
	self.isWiperOn = false;
	self.turnWiperOn = false;
	self.buttonAnimTime = 0;
end;

function MFwipers:delete()
end;

function MFwipers:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MFwipers:keyEvent(unicode, sym, modifier, isDown)
end;

function MFwipers:update(dt)
end;

function MFwipers:updateTick(dt)

	if self:getIsActive() then
		local animTime = self:getAnimationTime(self.wipersButton);
		if animTime > self.buttonAnimTime then
			if not self.isWiperOn then
				self.isWiperOn = true;
			end;
		elseif animTime < self.buttonAnimTime then
			if self.isWiperOn then
				self.isWiperOn = false;
			end;
		end;
		if self.isWiperOn then
			if not self:getIsAnimationPlaying(self.wipersAnim) then
				self:playAnimation(self.wipersAnim, self.wipersSpeed, 0, true);
			end;
		end;
		self.buttonAnimTime = animTime;
		
		if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			if not self.isWiperOn then
				self.turnWiperOn = true;
			else
				self.turnWiperOn = false;
			end;
		else
			if self.turnWiperOn then
				self.turnWiperOn = false;
			end;
		end;
	end;
end;

function MFwipers:draw()
	if self.turnWiperOn then
		g_currentMission:addExtraPrintText(g_i18n:getText("TurnWipersOn"));
	end;
end;