--
-- BuyableMFWheelsAttacher
-- Specialization for Buyable Twin Wheels
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v3.0
-- @date  		30/10/12
-- @history:	v1.0 - Initial version
--				v2.0 - added network support, changed update to updateTick
--				v3.0 - Added dynamic collision support, ls13-ready
--
-- free for noncommerical-usage
--

BuyableMFWheelsAttacher = {};

function BuyableMFWheelsAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyableMFWheelsAttacher:load(xmlFile)

	self.onAssemblingTwins = SpecializationUtil.callSpecializationsFunction("onAssemblingTwins");
	self.onDisassemblingTwins = SpecializationUtil.callSpecializationsFunction("onDisassemblingTwins");
	self.onAssemblingCare = SpecializationUtil.callSpecializationsFunction("onAssemblingCare");
	self.onDisassemblingCare = SpecializationUtil.callSpecializationsFunction("onDisassemblingCare");
	self.onAssemblingFloat = SpecializationUtil.callSpecializationsFunction("onAssemblingFloat");
	self.onDisassemblingFloat = SpecializationUtil.callSpecializationsFunction("onDisassemblingFloat");
	
	self.buyableTwinWheels = {};
	self.buyableTwinWheels.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#extraWheelsCheckString"), "standard");
	self.buyableTwinWheels.twinWheels = nil;
	self.buyableTwinWheels.wheelsInRange = nil;	
	
	self.buyableCareWheels = {};
	self.buyableCareWheels.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#extraWheelsCheckString"), "standard");
	self.buyableCareWheels.careWheels = nil;
	self.buyableCareWheels.wheelsInRange = nil;
	
	self.buyableFloatWheels = {};
	self.buyableFloatWheels.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#extraWheelsCheckString"), "standard");
	self.buyableFloatWheels.careWheels = nil;
	self.buyableFloatWheels.wheelsInRange = nil;

    self.standardWheels = {};
    local i = 0;
    while true do
        local wheelnamei = string.format("vehicle.wheels.wheel(%d)", i);
		local rim = Utils.indexToObject(self.components, getXMLString(xmlFile, wheelnamei.."#rim"));
        if rim == nil then
            break;
        end;
		local tire = Utils.indexToObject(self.components, getXMLString(xmlFile, wheelnamei.."#tire"));
		table.insert(self.standardWheels, {rim=rim, tire=tire});
		i = i + 1;
	end;

end;

function BuyableMFWheelsAttacher:delete()
	if self.buyableTwinWheels.twinWheels ~= nil then
		self.buyableTwinWheels.twinWheels:disassembleTwinWheels(true);
	end;
	if self.buyableCareWheels.careWheels ~= nil then
		self.buyableCareWheels.careWheels:disassembleCareWheels(true);
	end;
	if self.buyableFloatWheels.floatWheels ~= nil then
		self.buyableFloatWheels.floatWheels:disassembleFloatWheels(true);
	end;
end;

function BuyableMFWheelsAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableMFWheelsAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableMFWheelsAttacher:update(dt)

	if self:getIsActive() and self.movingDirection == 0 then
		local wheels1 = self.buyableTwinWheels;
		local wheels2 = self.buyableCareWheels;
		local wheels3 = self.buyableFloatWheels;
		if wheels1.wheelsInRange ~= nil and wheels2.careWheels == nil and wheels3.floatWheels == nil then
			if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
				if InputBinding.hasEvent(InputBinding.MF_TWINWHEELS_ATTACH) then
					if wheels1.twinWheels == nil then
						wheels1.wheelsInRange:assembleTwinWheels(self);
					else
						if wheels1.wheelsInRange.twinWheelsUser == self then
							wheels1.wheelsInRange:disassembleTwinWheels();
						end;
					end;
				end;
			end;
		end;
		if wheels2.wheelsInRange ~= nil and wheels1.twinWheels == nil and wheels3.floatWheels == nil then
			if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
				if InputBinding.hasEvent(InputBinding.MF_CAREWHEELS_ATTACH) then
					if wheels2.careWheels == nil then
						wheels2.wheelsInRange:assembleCareWheels(self);
					else
						if wheels2.wheelsInRange.careWheelsUser == self then
							wheels2.wheelsInRange:disassembleCareWheels();
						end;
					end;
				end;
			end;
		end;
		if wheels3.wheelsInRange ~= nil and wheels1.twinWheels == nil and wheels2.careWheels == nil then
			if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
				if InputBinding.hasEvent(InputBinding.MF_FLOATWHEELS_ATTACH) then
					if wheels3.floatWheels == nil then
						wheels3.wheelsInRange:assembleFloatWheels(self);
					else
						if wheels3.wheelsInRange.floatWheelsUser == self then
							wheels3.wheelsInRange:disassembleFloatWheels();
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyableMFWheelsAttacher:draw()
	if self.movingDirection == 0 then
		local wheels1 = self.buyableTwinWheels;
		local wheels2 = self.buyableCareWheels;
		local wheels3 = self.buyableFloatWheels;
		if wheels2.wheelsInRange ~= nil and wheels1.twinWheels == nil and wheels3.floatWheels == nil then
			if wheels2.careWheels ~= nil then
				if wheels2.wheelsInRange.careWheelsUser == self then
					g_currentMission:addHelpButtonText(g_i18n:getText("BuyableCareWheels_disassemble"), InputBinding.MF_CAREWHEELS_ATTACH);
				end;
			else
				if wheels2.wheelsInRange.careWheelsUser == nil then
					g_currentMission:addHelpButtonText(g_i18n:getText("BuyableCareWheels_assemble"), InputBinding.MF_CAREWHEELS_ATTACH);
				end;
			end;
		end;
		if wheels1.wheelsInRange ~= nil and wheels2.careWheels == nil and wheels3.floatWheels == nil then
			if wheels1.twinWheels ~= nil then
				if wheels1.wheelsInRange.twinWheelsUser == self then
					g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_disassemble"), InputBinding.MF_TWINWHEELS_ATTACH);
				end;
			else
				if wheels1.wheelsInRange.twinWheelsUser == nil then
					g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_assemble"), InputBinding.MF_TWINWHEELS_ATTACH);
				end;
			end;
		end;
		if wheels3.wheelsInRange ~= nil and wheels1.twinWheels == nil and wheels2.careWheels == nil then
			if wheels3.floatWheels ~= nil then
				if wheels3.wheelsInRange.floatWheelsUser == self then
					g_currentMission:addHelpButtonText(g_i18n:getText("BuyableFloatWheels_disassemble"), InputBinding.MF_FLOATWHEELS_ATTACH);
				end;
			else
				if wheels3.wheelsInRange.floatWheelsUser == nil then
					g_currentMission:addHelpButtonText(g_i18n:getText("BuyableFloatWheels_assemble"), InputBinding.MF_FLOATWHEELS_ATTACH);
				end;
			end;
		end;
	end;
end;

function BuyableMFWheelsAttacher:onAssemblingTwins(buyableTwinWheels)
	self.buyableTwinWheels.twinWheels = buyableTwinWheels;
end;

function BuyableMFWheelsAttacher:onDisassemblingTwins()
	self.buyableTwinWheels.twinWheels = nil;
end;

function BuyableMFWheelsAttacher:onAssemblingCare(buyableCareWheels)
	self.buyableCareWheels.careWheels = buyableCareWheels;
end;

function BuyableMFWheelsAttacher:onDisassemblingCare()
	self.buyableCareWheels.careWheels = nil;
end;

function BuyableMFWheelsAttacher:onAssemblingFloat(buyableFloatWheels)
	self.buyableFloatWheels.floatWheels = buyableFloatWheels;
end;

function BuyableMFWheelsAttacher:onDisassemblingFloat()
	self.buyableFloatWheels.floatWheels = nil;
end;