-- @author  FIAT80-90DT 
-- @date  	12.07.2013
-- @version initail version (1.0)
-- (C) MODCorp.de - Free for non commercial usage -

MultipleAttacherJoints = {};

function MultipleAttacherJoints.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function MultipleAttacherJoints:load(xmlFile)
	self.setAttacherJoint = SpecializationUtil.callSpecializationsFunction("setAttacherJoint");
	
	self.attacherJoints = {};
	self.currentAttacher = 1;
	local i = 0;
	while true do
		local baseName = string.format("vehicle.attacherJoints.attacherJoint(%d)", i);
		local attacherJoint = {};
		attacherJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.."#index"));
		if attacherJoint.node ~= nil then
			attacherJoint.topReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.."#topReferenceNode"));
			attacherJoint.rootNode = Utils.getNoNil(Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.."#rootNode")), self.components[1].node);
			attacherJoint.fixedRotation = Utils.getNoNil(getXMLBool(xmlFile, baseName.."#fixedRotation"), false);
			attacherJoint.lowerDistanceToGround = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#lowerDistanceToGround"), 0.7);
			attacherJoint.upperDistanceToGround = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#upperDistanceToGround"), 1.0);
			attacherJoint.lowerRotationOffset = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#lowerRotationOffset"), 0));
			attacherJoint.upperRotationOffset = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#upperRotationOffset"), 8));

			attacherJoint.allowsJointRotLimitMovement = Utils.getNoNil(getXMLBool(xmlFile, baseName.."#allowsJointRotLimitMovement"), true);
			attacherJoint.allowsJointTransLimitMovement = Utils.getNoNil(getXMLBool(xmlFile, baseName.."#allowsJointTransLimitMovement"), true);

			--load joint limit scales
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile,  baseName.."#rotLimitScale"));
			attacherJoint.rotLimitScale = { Utils.getNoNil(x, 1), Utils.getNoNil(y, 1), Utils.getNoNil(z, 1) };
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile,  baseName.."#transLimitScale"));
			attacherJoint.transLimitScale = { Utils.getNoNil(x, 1), Utils.getNoNil(y, 1), Utils.getNoNil(z, 1) };

			local jointTypeStr = getXMLString(xmlFile, baseName.."#jointType")
			local jointType;
			if jointTypeStr ~= nil then
				jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
				if jointType == nil then
					print("Warning: invalid jointType " .. jointTypeStr);
				end;
			else
				print("Warning: missing jointType");
			end;
			if jointType == nil then
				local needsTrailerJoint = Utils.getNoNil(getXMLBool(xmlFile, baseName.."#needsTrailerJoint"), false);
				local needsLowTrailerJoint = Utils.getNoNil(getXMLBool(xmlFile, baseName.."#needsLowJoint"), false);
				if needsTrailerJoint then
					if needsLowTrailerJoint then
						jointType = Vehicle.JOINTTYPE_TRAILERLOW;
					else
						jointType = Vehicle.JOINTTYPE_TRAILER;
					end;
				else
					jointType = Vehicle.JOINTTYPE_IMPLEMENT;
				end;
			end;
			attacherJoint.jointType = jointType;
			table.insert(self.attacherJoints, attacherJoint);
			i = i+1;
		else
			break;
		end;
	end;
	self.attacherJoint = self.attacherJoints[1];
   
	self.powerTakeOffs = {};
	local i = 0;
	while true do
		local baseName = string.format("vehicle.powerTakeOffs.powerTakeoffInput(%d)", i);
		local ptoInputNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.."#index"));
		if ptoInputNode ~= nil then
            local rotSpeed = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#rotSpeed"), 0)*0.001);
            if math.abs(rotSpeed) < 0.00001 then
                rotSpeed = 0;
            end
    
            local ptoInput = {node = ptoInputNode, rotSpeed=rotSpeed};
    
            local filename = getXMLString(xmlFile, baseName.."#overrideFilename");
            if filename ~= nil then
                filename = Utils.getFilename(filename, self.baseDirectory);
                local i3dNode = Utils.loadSharedI3DFile(filename);
                if i3dNode ~= 0 then
                    local rootNode = getChildAt(i3dNode, 0);
                    unlink(rootNode);
                    delete(i3dNode);
                   setTranslation(rootNode, 0,0,0);
                   local dirAndScaleNode = getChildAt(rootNode, 0);
                   local attachNode = getChildAt(dirAndScaleNode, 0);
                   local attachRefNode = getChildAt(attachNode, 0);
   
                   local _,_,baseDistance = getTranslation(attachNode);
                   unlink(attachNode);
                   local ax, ay, az = getTranslation(attachRefNode);
                   setTranslation(attachNode, -ax, -ay, -az);
   
                   ptoInput.rootNode = rootNode;
                   ptoInput.dirAndScaleNode = dirAndScaleNode;
                   ptoInput.attachNode = attachNode;
				   ptoInput.baseDistance = baseDistance;
				end
			end
			table.insert(self.powerTakeOffs, ptoInput);
			i = i+1;
		else
			break;
	   end
	end;
	self.ptoInput = self.powerTakeOffs[1];
	
	if table.getn(self.attacherJoints) ~= table.getn(self.powerTakeOffs) then
		print("Warning : Sum of attacherJoints should be equals with sum of powerTakeOffs!");
	end;
end;

function MultipleAttacherJoints:readStream(streamId, connection)
	self:setAttacherJoint(streamReadInt8(streamId), true);
end;
 
function MultipleAttacherJoints:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.currentAttacher);
end;

function MultipleAttacherJoints:delete()
end;

function MultipleAttacherJoints:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MultipleAttacherJoints:keyEvent(unicode, sym, modifier, isDown)
end;

function MultipleAttacherJoints:update(dt)
	if g_currentMission.player ~= nil then
		if g_currentMission.player.rootNode ~= nil then
			if self.attacherVehicle == nil then
				local x,y,z = getWorldTranslation(self.rootNode)
				local px,py,pz = getWorldTranslation(g_currentMission.player.rootNode)
				local distance = Utils.vector3Length(x-px, y-py, z-pz);
				if distance < 5 then
					g_currentMission:addHelpButtonText(g_i18n:getText("ATTACHER_CHANGE"), InputBinding.IMPLEMENT_EXTRA);
					if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
						local jnt = self.currentAttacher + 1;
						if jnt >  table.getn(self.attacherJoints) then
							jnt = 1;
						end;
						self:setAttacherJoint(jnt);						
					end;
				end;
			end;
		end;
	end;
end;

function MultipleAttacherJoints:updateTick(dt)
end;
 
function MultipleAttacherJoints:draw()
end;

function MultipleAttacherJoints:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local activeAttacherJoint = getXMLInt(xmlFile, key.."#activeAttacherJoint");		
	if activeAttacherJoint ~= nil then
		self:setAttacherJoint(activeAttacherJoint);
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function MultipleAttacherJoints:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'activeAttacherJoint="'.. self.currentAttacher .. '"';
    return attributes, nil;
end;

function MultipleAttacherJoints:onAttach(attacherVehicle)
end;

function MultipleAttacherJoints:onDetach()
end;

function MultipleAttacherJoints:setAttacherJoint(jnt, noEventSend)
	self.currentAttacher = jnt;
	self.attacherJoint = self.attacherJoints[jnt];
	self.ptoInput = self.powerTakeOffs[jnt];
	CouplingPointEvent.sendEvent(self, jnt, noEventSend)
end;