
MulcherEvent = {};
MulcherEvent.DESTROYWINDROW = 1;
MulcherEvent.TOFIRSTSTATE = 2;
MulcherEvent.CUTDOWN = 3;
MulcherEvent_mt = Class(MulcherEvent, Event);

InitEventClass(MulcherEvent, "MulcherEvent");

function MulcherEvent:emptyNew()
     local self = Event:new(MulcherEvent_mt);
     self.className="MulcherEvent";
     return self;
end;

function MulcherEvent:new(cuttingAreas, limitToField, mode, fruitType)
    local self = MulcherEvent:emptyNew()
    assert(table.getn(cuttingAreas) > 0);
    self.cuttingAreas = cuttingAreas;
    self.limitToField = limitToField;
	self.mode = mode;
	self.fruitType = fruitType;
    return self;
end;

function MulcherEvent:readStream(streamId, connection)
    local limitToField = streamReadBool(streamId);
    local numAreas = streamReadUIntN(streamId, 4);
	local mode = streamReadInt8(streamId);
	local fruitType = streamReadInt8Int8(streamId);
	
    local refX = streamR
	eadFloat32(streamId);
    local refY = streamReadFloat32(streamId);
    local values = Utils.readCompressed2DVectors(streamId, refX, refY, numAreas*3-1, 0.01, true);
    for i=1,numAreas do
        local vi = i-1;
		local x = values[vi*3+1].x;
        local z = values[vi*3+1].y;
        local x1 = values[vi*3+2].x;
        local z1 = values[vi*3+2].y;
        local x2 = values[vi*3+3].x;
        local z2 = values[vi*3+3].y;

		if mode == MulcherEvent.DESTROYWINDROW then
			Utils.cutFruitArea(fruitType, x, z, x1, z1, x2, z2);
			Utils.updateFruitCutShortArea(fruitType, x, z, x1, z1, x2, z2, 0);
			Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
			Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
		elseif mode == MulcherEvent.TOFIRSTSTATE then
			local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
			setDensityMaskedParallelogram(g_currentMission.fruits[fruitType].id, x, z, widthX, widthZ, heightX, heightZ, 0, 3, g_currentMission.fruits[fruitType].id, 0, 3, 2.0);
		elseif mode == MulcherEvent.CUTDOWN then
			 Utils.updateFruitCutShortArea(fruitType, x, z, x1, z1, x2, z2, 1);
			 Utils.cutFruitArea(fruitType, x, z, x1, z1, x2, z2);
		end;
    end;
end;


function MulcherEvent:writeStream(streamId, connection)
    local numAreas = table.getn(self.cuttingAreas);
    streamWriteBool(streamId, self.limitToField);
	streamWriteInt8(streamId, self.mode);
	streamWriteInt8(streamId, self.fruitType);
    streamWriteUIntN(streamId, numAreas, 4);

    local refX, refY;
    local values = {};
    for i=1, numAreas do
        local d = self.cuttingAreas[i];
        if i==1 then
            refX = d[1];
            refY = d[2];
            streamWriteFloat32(streamId, d[1]);
            streamWriteFloat32(streamId, d[2]);
       else
            table.insert(values, {x=d[1], y=d[2]});
       end;
       table.insert(values, {x=d[3], y=d[4]});
        table.insert(values, {x=d[5], y=d[6]});
   end;
    assert(table.getn(values) == numAreas*3 - 1);
    Utils.writeCompressed2DVectors(streamId, refX, refY, values, 0.01);
end;

function MulcherEvent:run(connection)
    print("Error: Do not run MulcherEvent locally");
end;

function MulcherEvent.runLocally(cuttingAreas, limitToField, mode, fruitType)

    local numAreas = table.getn(cuttingAreas);
    local refX, refY;
    local values = {};
    for i=1, numAreas do
        local d = cuttingAreas[i];
       if i==1 then
            refX = d[1];
           refY = d[2];
        else
            table.insert(values, {x=d[1], y=d[2]});
        end;
        table.insert(values, {x=d[3], y=d[4]});
        table.insert(values, {x=d[5], y=d[6]});
    end;
    assert(table.getn(values) == numAreas*3 - 1);

    local values = Utils.simWriteCompressed2DVectors(refX, refY, values, 0.01, true);

    for i=1, numAreas do
        local vi = i-1;
        local x = values[vi*3+1].x;
        local z = values[vi*3+1].y;
        local x1 = values[vi*3+2].x;
        local z1 = values[vi*3+2].y;
		local x2 = values[vi*3+3].x;
        local z2 = values[vi*3+3].y;
		if mode == MulcherEvent.DESTROYWINDROW then
			Utils.cutFruitArea(fruitType, x, z, x1, z1, x2, z2);
			Utils.updateFruitCutShortArea(fruitType, x, z, x1, z1, x2, z2, 0);
			Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
			Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
		elseif mode == MulcherEvent.TOFIRSTSTATE then
			local x,z, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
			setDensityMaskedParallelogram(g_currentMission.fruits[fruitType].id, x, z, widthX, widthZ, heightX, heightZ, 0, 3, g_currentMission.fruits[fruitType].id, 0, 3, 2.0);
		elseif mode == MulcherEvent.CUTDOWN then
			 Utils.updateFruitCutShortArea(fruitType, x, z, x1, z1, x2, z2, 1);
			 Utils.cutFruitArea(fruitType, x, z, x1, z1, x2, z2);
		end;
	end;
end;
