--
-- @team    Freelance Modding Crew (FMC)
-- @author  Decker_MMIV - fs-uk.com, forum.farming-simulator.com, modhoster.com
-- @date    2012-11-28
--------
-- edited by PeterJ - FS-Uk modteam
-- 30/11/2012
--

PTOsprayer = {}

function PTOsprayer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations) and SpecializationUtil.hasSpecialization(ImplementLinks, specializations);
end;

function PTOsprayer:load(xmlFile)
    Sprayer.load(self, xmlFile);
    --
    self.setVehicleRpmUp = SpecializationUtil.callSpecializationsFunction("setVehicleRpmUp");
    self.saveMinRpm = 0; 
    self.printWarningTime = 0;
    self.printWarningTime1 = 0;

	
	--- fill sound ---
    if self.isClient then
        local fillingSound = getXMLString(xmlFile, "vehicle.fillingSound#file");
        if fillingSound ~= nil and fillingSound ~= "" then
            fillingSound = Utils.getFilename(fillingSound, self.baseDirectory);
            self.fillingSound = createSample("fillingSound");
            self.fillingSoundEnabled = false;
            loadSample(self.fillingSound, fillingSound, false);
            self.fillingSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillingSound#pitchOffset"), 1);
            self.fillingSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillingSound#volume"), 1);
        end;
    end;
end;

function PTOsprayer:delete()
    Sprayer.delete(self);	
    if self.fillingSound ~= nil then
        delete(self.fillingSound);
    end;
end;

function PTOsprayer:readStream(streamId, connection)
    Sprayer.readStream(self, streamId, connection);
end;

function PTOsprayer:writeStream(streamId, connection)
    Sprayer.writeStream(self, streamId, connection);
end;

function PTOsprayer:readUpdateStream(streamId, timestamp, connection)
    Sprayer.readUpdateStream(self, streamId, timestamp, connection);
end;

function PTOsprayer:writeUpdateStream(streamId, connection, dirtyMask)
    Sprayer.writeUpdateStream(self, streamId, connection, dirtyMask)
end;

function PTOsprayer:mouseEvent(posX, posY, isDown, isUp, button)
    Sprayer.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function PTOsprayer:keyEvent(unicode, sym, modifier, isDown)
    Sprayer.keyEvent(self, unicode, sym, modifier, isDown);
end;
  
function PTOsprayer:update(dt)

    if self.isClient then
        if self:getIsActiveForInput() then
            if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) and not self.PTOId and self.attacherVehicle.isMotorStarted then
                  self:setIsTurnedOn(not self.isTurnedOn);
            end;
			if InputBinding.isPressed(InputBinding.IMPLEMENT_EXTRA) and self.PTOId then
				self.printWarningTime = self.time + 1000;
			end;	
			if InputBinding.isPressed(InputBinding.ACTIVATE_OBJECT) and self.PTOId then
				self.printWarningTime1 = self.time + 1000;
			end;
        end;
    end;
end;

function PTOsprayer:updateTick(dt)
    if self.isClient then
		if self.attacherVehicle ~= nil then
			if self.PTOId or not self.attacherVehicle.isMotorStarted then -- PTO is detached, or engine is off.
				self:setIsTurnedOn(false);
				self:setIsSprayerFilling(false);
			end;
		end;

        self:setVehicleRpmUp(dt, self.isTurnedOn);
		
		if self.isSprayerFilling then
			if not self.fillingSoundEnabled and self:getIsActiveForSound() then
                playSample(self.fillingSound, 0, self.fillingSoundVolume, 0);
                setSamplePitch(self.fillingSound, self.fillingSoundPitchOffset);
                self.fillingSoundEnabled = true;
            end;
        end;
		if not self.isSprayerFilling then
			stopSample(self.fillingSound);
			self.fillingSoundEnabled = false;
		end;			
	end;
	
    --
    Sprayer.updateTick(self, dt);
end;

function PTOsprayer:draw()
    if self.isClient then
		if self.printWarningTime > self.time then
			g_currentMission:addWarning(g_i18n:getText("turnON_Error"), 0.018, 0.033);
		end;
		if self.printWarningTime1 > self.time then
			g_currentMission:addWarning(g_i18n:getText("fill_Error"), 0.018, 0.033);
		end;

    end;
    --
	Sprayer.draw(self);
end;

function PTOsprayer:onDetach()

    Sprayer.onDetach(self);
    --
    for k, steerable in pairs(g_currentMission.steerables) do
        if self.attacherVehicleCopy == steerable then
            steerable.motor.minRpm = self.saveMinRpm;
            self.attacherVehicleCopy = nil;
        end;
    end;
end;

function PTOsprayer:onAttach(attacherVehicle)
    Attachable.onAttach(self, attacherVehicle);
    --
    if self.attacherVehicleCopy == nil then
        self.attacherVehicleCopy = self.attacherVehicle;
    end;
    self.saveMinRpm = self.attacherVehicle.motor.minRpm;
end;

function PTOsprayer:onLeave()
    Sprayer.onLeave(self);
end;

function PTOsprayer:onDeactivate()
    Sprayer.onDeactivate(self);
end;

function PTOsprayer:onDeactivateSounds()
	if self.fillingSoundEnabled then
		stopSample(self.fillingSound);
		self.fillingSoundEnabled = false;
	end;
    Sprayer.onDeactivateSounds(self);
end;

function PTOsprayer:getIsTurnedOnAllowed(isTurnedOn)
    return Sprayer.getIsTurnedOnAllowed(self, isTurnedOn);
end;

function PTOsprayer:setIsTurnedOn(isTurnedOn, noEventSend)
    Sprayer.setIsTurnedOn(self, isTurnedOn, noEventSend);
end;

function PTOsprayer:setIsSprayerFilling(isFilling, fillType, isSiloTrigger, noEventSend)
    Sprayer.setIsSprayerFilling(self, isFilling, fillType, isSiloTrigger, noEventSend);
end;

function PTOsprayer:addSprayerFillTrigger(trigger)
    Sprayer.addSprayerFillTrigger(self, trigger);
end;

function PTOsprayer:removeSprayerFillTrigger(trigger)
    Sprayer.removeSprayerFillTrigger(self, trigger);
end;

function PTOsprayer:setVehicleRpmUp(dt, isActive)
    if self.attacherVehicle ~= nil and self.saveMinRpm ~= 0 then
        if dt ~= nil then
            if isActive == true then
                self.attacherVehicle.motor.minRpm = math.max(self.attacherVehicle.motor.minRpm-dt, -1000);
            else
                self.attacherVehicle.motor.minRpm = math.min(self.attacherVehicle.motor.minRpm+dt*2, self.saveMinRpm);
            end;
        else
            self.attacherVehicle.motor.minRpm = self.saveMinRpm;
        end;
        if self.attacherVehicle.isMotorStarted then
            local fuelUsed = 0.00000011*math.abs(self.attacherVehicle.motor.minRpm);
            self.attacherVehicle:setFuelFillLevel(self.attacherVehicle.fuelFillLevel-fuelUsed);
            g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
            g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;
        end;
    end;
end;
