--------------------------------------------------------------------------------------
-- MOD: LoadStatus
-- MOD Author: WLKe
-- Version 0.8.6 - 30.10.2012 - FS2013 
-- Thanks edmund (Inspector),rafftnix (RenderVehicleFillStates) for inspiration.
-- Copyright (C) WLKe -- wlke@wlke.net
--------------------------------------------------------------------------------------
print("LoadStatus 0.8.6 by WLKe loaded");
Loadstatus = {};

function Loadstatus:loadMap(name)
self.count=1;
self.locales = {}
self.locales.Speed = g_i18n:getText("Speed")
self.locales.Fuel = g_i18n:getText("Fuel")
self.locales.Stop = g_i18n:getText("Stop")
self.locales.Empty = g_i18n:getText("Empty")
self.locales.Metric = g_i18n:getText("Metric")
dShowPercent = true
end;
function Loadstatus:deleteMap()
end;
function Loadstatus:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Loadstatus:loadSteerable(xmlFile)
  local aNameSearch = {"vehicle.name." .. g_languageShort, "vehicle.name.en", "vehicle.name", "vehicle#type"};
		for nIndex,sXMLPath in pairs(aNameSearch) do 
		  self.name = getXMLString(xmlFile, sXMLPath);
		  if self.name ~= nil then break; end;
		end;
		if self.name == nil then self.name = g_i18n:getText("UNKNOWN") end;
  if self.name == nil then
      self.name = "Steerable" 
  end;

end;
Steerable.load  = Utils.appendedFunction(Steerable.load, Loadstatus.loadSteerable);

function  Loadstatus:loadAttachable(xmlFile)
  local aNameSearch = {"vehicle.name." .. g_languageShort, "vehicle.name.en", "vehicle.name", "vehicle#type"};
		for nIndex,sXMLPath in pairs(aNameSearch) do 
		  self.name = getXMLString(xmlFile, sXMLPath);
		  if self.name ~= nil then break; end;
		end;
		if self.name == nil then self.name = g_i18n:getText("UNKNOWN") end;
	if self.name == nil then
      self.name = "Attachable"
  end;
end;

Attachable.load = Utils.appendedFunction(Attachable.load, Loadstatus.loadAttachable);

function Loadstatus:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_a and bitAND(modifier, Input.MOD_ALT) > 0 then
		if dShow then 
			dShow = false;
		else
			dShow = true;
		end;
	end;
	if isDown and sym == Input.KEY_slash then
		if dShowPercent == true and dShowFill ~= true then 
			dShowFill = true;
			dShowPercent = false;
			return true;
		end;
		if dShowFill == true and dShowPercent == false then
			dShowPercent = true;
			return true;
		end;
		if dShowPercent == true and dShowFill == true then
			dShowFill = false;
			dShowPercent = true;
			return true;
		end;
		if dShowPercent == nil and dShowFill == nil then dShowPercent = true; end;
	end;
end;

function Loadstatus:update(dt)
	if math.ceil(g_currentMission.environment.dayTime) > 20*60*60*1000 or math.ceil(g_currentMission.environment.dayTime) < 6*60*60*1000 then
		self.day=false;
	else
		self.day=true;
	end;
end;
function Loadstatus:get_locale(self, key)
  return self.locales[key]
end
function Loadstatus:draw()
	if dShow then return true; end;

	if Input.keyPressedState[308] then
		return true;
	else
	------------------------ User Customizable parameters -------------------
		local GrainTankPercentageWarn = 85;  -- warn level for combines		(default 80)
		local fuelPercentWarn = 20;				
		local fFontSize = 0.015;			-- font size					(default 0.015)
		local LineWrap = .92;		-- wrap long line (in % / 100)			(default .87)
		local NameSizeLimit = 22;	-- Vehicle name string lenght limit		(default 15)
	-------------------------------------------------------------------------
		
		local fPosX = 0.012;
		if g_currentMission.showHelpText and g_currentMission.hudHelpBaseBottomOverlay.y ~= 0 then
			fPosY = (g_currentMission.hudHelpBaseBottomOverlay.y - g_currentMission.hudHelpTextSize);
		else
			fPosY = 0.965;
		end;
		local global_start = 10;
		local fLineDist = fFontSize + 0.0016;
		setTextAlignment(RenderText.ALIGN_LEFT);
		local nLine = 0;
		local hasFillable = false;
		local hasGrainTank = false;
		local hasLowType = false;
		local i18FillType = "";
		local FillPercentage = 0;
		local Printed = false;
		local Courseplayname = "";
		local fAlpha = 0;
		if self.day then fAlpha = 1; else fAlpha = 0.8; end;
		for i=1,table.getn(g_currentMission.steerables) do
			local textController = "";
			local GrainTankPercentage = 0;
			local textVehicleFill="";
			local textVehicleName="";
			local textPosX = fPosX;
			Printed = false;
			local vehicle = g_currentMission.steerables[i]; -- steerables
			hasGrainTank = false; hasFillable = false; hasLowType = false;
			setTextBold(false);
			setTextColor(1,1,1,fAlpha);
			if vehicle.isControlled then				
				if vehicle.controllerName ~= nil then 
					textController = "(" ..string.sub(Utils.getNoNil(vehicle.controllerName, g_i18n:getText("UNKNOWN")), 0, 15) .. ") "; 
				end;
				if g_currentMission.controlledVehicle == vehicle then
					setTextBold(true);
				end;
			end;
			if vehicle.name ~= nil then
				textVehicleName = vehicle.name;
			end;
			 hasFillable = false;
			 if SpecializationUtil.hasSpecialization(courseplay, vehicle.specializations) then
                    Courseplayname = vehicle.current_course_name;
                else
					Courseplayname = vehicle.current_course_name;
			end;
			----------------------------- fillable vehicle				
			if vehicle.fillLevel ~= nil and vehicle.capacity ~= nil and vehicle.currentFillType ~= nil then
				hasFillable = true;
				FillPercentage = vehicle.fillLevel / vehicle.capacity * 100;
				local FillType = "";
				if vehicle.currentFillType ~= Fillable.FILLTYPE_UNKNOWN and vehicle.currentFillType ~=  nil then
					FillType = Fillable.fillTypeIntToName[vehicle.currentFillType].."";
				end;
				i18FillType = "";

					if g_i18n:hasText(FillType) then
						i18FillType = g_i18n:getText(FillType);
						else 
							i18FillType = FillType;
					end;
					if (vehicle.isHired  or vehicle.drive) and Printed ~= true then	
						setTextColor(0.72,0.80,0.98,fAlpha);	
						renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize, i..") ");
						textPosX=textPosX+getTextWidth(fFontSize,tostring(i..") "));
					if vehicle.drive then
						renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"[C] ");
						textPosX=textPosX+getTextWidth(fFontSize,tostring("[C] "));
					else						
						renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"[H] ");
						textPosX=textPosX+getTextWidth(fFontSize,tostring("[H] "));
					end;
						renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,textController..textVehicleName); -- print controler + vehicle name
						textPosX=textPosX+getTextWidth(fFontSize,tostring(textController..textVehicleName)); -- print controler + vehicle name
						Printed = true;
					else
						if Printed ~= true then
							renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize, i..") "..textController..textVehicleName); -- print controler + vehicle name
							textPosX=textPosX+getTextWidth(fFontSize,tostring(i..") "..textController));
							textPosX=textPosX+getTextWidth(fFontSize,tostring(textVehicleName));
							setTextColor(1,1,1,fAlpha);
							Printed = true;
						end;
					end;
					if FillType == "fertilizer" and FillPercentage < 10 then 
					setTextBold(true);
						if (FillType == "fertilizer" or FillType == "seeds") and FillPercentage < 10 then 
							if ((math.ceil(g_currentMission.environment.dayTime/1000) - global_start) % 2) < 1 then
								setTextColor(0.7,0.1,0.1,fAlpha); 
							else
								setTextColor(1,0,0,fAlpha);
							end;
						end;					
					end;
					if FillPercentage > 0 then
					setTextColor(0,.75,0,fAlpha);
					renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"@");
					textPosX=textPosX+getTextWidth(fFontSize,"@");							
					if dShowPercent or not dShowFill then
							renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,tostring(math.ceil(FillPercentage - 0.5)).."%");
							textPosX=textPosX+getTextWidth(fFontSize,tostring(math.ceil(FillPercentage - 0.5)).."%");
						end;
						if dShowPercent and dShowFill then 
							renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"=");
							textPosX=textPosX+getTextWidth(fFontSize,"=");
						end							
						if dShowFill then
							renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,tostring(math.ceil(vehicle.fillLevel)).."L");
							textPosX=textPosX+getTextWidth(fFontSize,tostring(math.ceil(vehicle.fillLevel)).."L");
						end;							
						renderText(textPosX, fPosY-(nLine*fLineDist),fFontSize," ("..i18FillType..")");
						textPosX=textPosX+getTextWidth(fFontSize,tostring(" ("..i18FillType..")"));
						setTextColor(1,1,1,fAlpha);setTextBold(false);
					else
						setTextColor(0,.75,0,fAlpha);
						renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"@");
						textPosX=textPosX+getTextWidth(fFontSize,"@");							
						setTextColor(.5,.5,.5,fAlpha);setTextBold(false);
						Printed = true;
						renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"("..Loadstatus:get_locale(self, "Empty")..")");
						textPosX=textPosX+getTextWidth(fFontSize,tostring("("..Loadstatus:get_locale(self, "Empty")..")"));
					end;
			else
				if (vehicle.isHired or vehicle.drive) and Printed ~= true then	
					setTextColor(0.72,0.80,0.98,fAlpha);	
					renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize, i..") ");
					textPosX=textPosX+getTextWidth(fFontSize,tostring(i..") "));
					if vehicle.drive then 
						renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"[C] ");
						textPosX=textPosX+getTextWidth(fFontSize,tostring("[C] "));
					else
						renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"[H] ");
						textPosX=textPosX+getTextWidth(fFontSize,tostring("[H] "));
					end;
					renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,textController..textVehicleName); -- print controler + vehicle name
					textPosX=textPosX+getTextWidth(fFontSize,tostring(textController..textVehicleName)); -- print controler + vehicle name
					Printed = true;
				end;
			end;
--------------------------------------- zobrazenie kombajnu -----------------------------				
			if  vehicle.grainTankFillLevel ~= nil and vehicle.grainTankCapacity ~= nil and vehicle.currentGrainTankFruitType ~= nil then
				hasGrainTank = true;
				GrainTankPercentage = vehicle.grainTankFillLevel / vehicle.grainTankCapacity * 100;
				GrainTankPercentage = math.ceil(GrainTankPercentage - 0.5);
				local FruitType = "";
				if vehicle.currentGrainTankFruitType ~= "unknown" and vehicle.currentGrainTankFruitType ~= nil and vehicle.grainTankFillLevel > 0 then 
					FruitType = FruitUtil.fruitIndexToDesc[vehicle.currentGrainTankFruitType].name;
				else
					FruitType = "unknown";
				end;
					if g_i18n:hasText(FruitType) then
						i18FruitType = g_i18n:getText(FruitType);
						else 
							i18FruitType = FruitType;	-- if not translate version
					end;
					if hasFillable ~= true then
						if (vehicle.isHired or vehicle.drive) and Printed ~= true then 	
							setTextColor(0.72,0.80,0.98,fAlpha);	
							renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize, i..") ");
							textPosX=textPosX+getTextWidth(fFontSize,tostring(i..") "));
							if vehicle.drive then 
								renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"[C] ");
								textPosX=textPosX+getTextWidth(fFontSize,tostring("[C] "));
							else
								renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"[H] ");
								textPosX=textPosX+getTextWidth(fFontSize,tostring("[H] "));
							end;
								renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,textController..textVehicleName); -- print controler + vehicle name
								textPosX=textPosX+getTextWidth(fFontSize,tostring(textController..textVehicleName)); -- print controler + vehicle name
								Printed = true;
						else
							if Printed ~= true then
								renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize, i..") "..textController..textVehicleName); -- print controler + vehicle name
								Printed = true;
								textPosX=textPosX+getTextWidth(fFontSize,tostring(i..") "..textController));
								textPosX=textPosX+getTextWidth(fFontSize,tostring(textVehicleName));
								setTextColor(1,1,1,fAlpha);
							end;
						end;
						if hasGrainTank and vehicle.grainTankFillLevel > 0 then setTextBold(true);	setTextColor(0,1,0,fAlpha); else	setTextColor(1,1,1,fAlpha);end;
						if GrainTankPercentage > GrainTankPercentageWarn then 
							if (math.ceil(g_currentMission.environment.dayTime/1000) - global_start) % 2 < 1 then
								setTextColor(0.7,0.1,0.1,fAlpha); 
							else
								setTextColor(1,0,0,fAlpha);
							end;
						else
							setTextColor(0,.75,0,fAlpha);
						end;
						if vehicle.grainTankFillLevel > 5  then 
							renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"@");
							textPosX=textPosX+getTextWidth(fFontSize,"@");
							if dShowPercent or not dShowFill then
								renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,tostring(GrainTankPercentage).."%");
								textPosX=textPosX+getTextWidth(fFontSize,tostring(GrainTankPercentage).."%");
							end;
							if dShowPercent and dShowFill then 
								renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"=");
									textPosX=textPosX+getTextWidth(fFontSize,"=");
							end
							if dShowFill then
									renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,(math.ceil(vehicle.grainTankFillLevel)).."L");
									textPosX=textPosX+getTextWidth(fFontSize,tostring(math.ceil(vehicle.grainTankFillLevel).."L"));
							end;
								renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize," ("..i18FruitType..")");
								textPosX=textPosX+getTextWidth(fFontSize,tostring(" ("..i18FruitType..")"));
						else
							renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"@");
							textPosX=textPosX+getTextWidth(fFontSize,"@");
							setTextBold(false);
							setTextColor(0.5,0.5,0.5,fAlpha);
							renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"("..Loadstatus:get_locale(self, "Empty")..")");
							textPosX=textPosX+getTextWidth(fFontSize,tostring("("..Loadstatus:get_locale(self, "Empty")..")"));
						end;
					end;
			end;
				----------------------------- fillable implements	
			setTextBold(false);
			for Index,implement in pairs(vehicle.attachedImplements) do
				if implement ~= nil and implement.object ~= nil then
					if implement.object.fillLevel ~= nil and implement.object.capacity ~= nil and implement.object.currentFillType ~= nil and implement.object.name ~= nil then
						FillPercentage = implement.object.fillLevel / implement.object.capacity * 100;
						local FillType = "";
						if implement.object.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
							FillType = Fillable.fillTypeIntToName[implement.object.currentFillType];
						else 
							FillType = "unknown";
						end;
						i18FillType = "";
						if g_i18n:hasText(FillType) then
							i18FillType = g_i18n:getText(FillType);
						else 
							i18FillType = FillType;	-- if not translate 
						end;
						if (vehicle.isHired or vehicle.drive) and Printed ~= true then	
							setTextColor(0.72,0.80,0.98,fAlpha);	
							renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize, i..") ");
							textPosX=textPosX+getTextWidth(fFontSize,tostring(i..") "));
							if vehicle.drive then 
								renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"[C] ");
								textPosX=textPosX+getTextWidth(fFontSize,tostring("[C] "));
							else
								renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"[H] ");
								textPosX=textPosX+getTextWidth(fFontSize,tostring("[H] "));
							end;

							renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,textController..textVehicleName); -- print controler + vehicle name
							textPosX=textPosX+getTextWidth(fFontSize,tostring(textController..textVehicleName)); -- print controler + vehicle name
							Printed = true;
						end;
						if g_currentMission.controlledVehicle == vehicle then
							setTextBold(true);
						else
							setTextBold(false);
						end;						
						if implement.object.fillLevel ~= nil and implement.object.capacity ~= nil then
							if hasFillable == false  and Printed ~= true then 
								renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize, i..") "..textController..textVehicleName); -- print controler + vehicle name
								Printed = true;
								textPosX=textPosX+getTextWidth(fFontSize,tostring(i..") "..textController));
								textPosX=textPosX+getTextWidth(fFontSize,tostring(textVehicleName));
								setTextColor(1,1,1,fAlpha);
								hasFillable = true;	
							end;
							if textPosX+getTextWidth(fFontSize,tostring("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx")) > LineWrap then
								nLine = nLine + 1;
								textPosX = fPosX + getTextWidth(fFontSize,"xxxxxxxxxxxxx");
							end;
							setTextColor(1,1,1,fAlpha);
							renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"+");
							textPosX=textPosX+getTextWidth(fFontSize,tostring("+"));
							if (vehicle.isHired or vehicle.drive) then	setTextColor(0.72,0.80,0.98,fAlpha);	end;
							renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,string.sub(implement.object.name, 0, NameSizeLimit));
							textPosX=textPosX+getTextWidth(fFontSize,tostring(string.sub(implement.object.name,0, NameSizeLimit)));
							setTextColor(0.20,0.60,0.60,fAlpha);
							if (FillType == "fertilizer" or FillType == "seeds") and FillPercentage < 10 then 
							setTextBold(true);
								if (math.ceil(g_currentMission.environment.dayTime/1000) - global_start) % 2 < 1 then
									setTextColor(0.7,0.1,0.1,fAlpha); 
								else
									setTextColor(0.20,0.60,0.20,fAlpha);
								end;
							else							
								setTextColor(0,.75,0,fAlpha);
							end;
							renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"@");
							textPosX=textPosX+getTextWidth(fFontSize,"@");							
							if implement.object.fillLevel > 0 then
								if dShowPercent or not dShowFill then
									renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,tostring(math.ceil(FillPercentage - 0.5)).."%");
									textPosX=textPosX+getTextWidth(fFontSize,tostring(math.ceil(FillPercentage - 0.5)).."%");
								end;
								if dShowPercent and dShowFill then 
									renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"=");
									textPosX=textPosX+getTextWidth(fFontSize,"=");
								end							
								if dShowFill then
									renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,tostring(math.ceil(implement.object.fillLevel)).."L");
									textPosX=textPosX+getTextWidth(fFontSize,tostring(math.ceil(implement.object.fillLevel)).."L");
								end;
								renderText(textPosX, fPosY-(nLine*fLineDist),fFontSize," ("..i18FillType..")");
								textPosX=textPosX+getTextWidth(fFontSize,tostring(" ("..i18FillType..")"));
--								setTextBold(false);
							else
								setTextColor(0.5,0.5,0.5,fAlpha);
								renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"("..Loadstatus:get_locale(self, "Empty")..")");
								textPosX=textPosX+getTextWidth(fFontSize,tostring("("..Loadstatus:get_locale(self, "Empty")..")"));
							end;
							setTextColor(1,1,1,fAlpha);
						end;
					end;
				end;
				for Index2,implement2 in pairs(implement.object.attachedImplements) do
					if implement2.object.fillLevel ~= nil and implement2.object.capacity ~= nil and implement2.object.currentFillType ~= nil and implement2.object.name ~= nil then
						FillPercentage = implement2.object.fillLevel / implement2.object.capacity * 100;
						local FillType = "";
						if implement2.object.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
							FillType = Fillable.fillTypeIntToName[implement2.object.currentFillType];
						else 
							FillType = "unknown";
						end;
						i18FillType = "";
						if g_i18n:hasText(FillType) then
							i18FillType = g_i18n:getText(FillType);
						else 
							i18FillType = FillType;	-- if not translate version
						end;
						if Printed ~= true then 
							if (vehicle.isHired or vehicle.drive) then	setTextColor(0.72,0.80,0.98,fAlpha);	end;
							renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize, i..") "..textController..textVehicleName); -- print controler + vehicle name
							Printed = true;
							textPosX=textPosX+getTextWidth(fFontSize,tostring(i..") "..textController));
							textPosX=textPosX+getTextWidth(fFontSize,tostring(textVehicleName));
							setTextColor(1,1,1,fAlpha);
							hasFillable = true;	
							Printed = true;
						else
							if (vehicle.isHired or vehicle.drive) then	setTextColor(0.72,0.80,0.98,fAlpha);	end;
						end;
						if textPosX+getTextWidth(fFontSize,tostring("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx")) > LineWrap then
							nLine = nLine + 1;
							textPosX = fPosX + getTextWidth(fFontSize,"xxxxxxxxxxxxx");
						end;
						renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"+"..string.sub(implement2.object.name,0, NameSizeLimit));
						textPosX=textPosX+getTextWidth(fFontSize,tostring("+"..string.sub(implement2.object.name,0, NameSizeLimit)));
						if (FillType == "fertilizer" or FillType == "seeds") and FillPercentage < 10 then 
						setTextBold(true);
							if (math.ceil(g_currentMission.environment.dayTime/1000) - global_start) % 2 < 1 then
								setTextColor(0.7,0.1,0.1,fAlpha); 
							else
								setTextColor(0.20,0.60,0.20,fAlpha);
							end;						
						else
							setTextColor(0,.75,0,fAlpha);
						end;
						renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"@");
						textPosX=textPosX+getTextWidth(fFontSize,"@");							
						if implement2.object.fillLevel > 0 then
							if dShowPercent then
								renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,tostring(math.ceil(FillPercentage - 0.5)).."%");
								textPosX=textPosX+getTextWidth(fFontSize,tostring(math.ceil(FillPercentage - 0.5)).."%");
							end;
							if dShowPercent and dShowFill then 
								renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"=");
								textPosX=textPosX+getTextWidth(fFontSize,"=");
							end							
							if dShowFill then
								renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,tostring(math.ceil(implement2.object.fillLevel)).."L");
								textPosX=textPosX+getTextWidth(fFontSize,tostring(math.ceil(implement2.object.fillLevel)).."L");
							end;							
							renderText(textPosX, fPosY-(nLine*fLineDist),fFontSize," ("..i18FillType..")");
							textPosX=textPosX+getTextWidth(fFontSize,tostring(" ("..i18FillType..")"));
--							setTextBold(false);
						else
							setTextColor(0.5,0.5,0.5,fAlpha);
							renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"("..Loadstatus:get_locale(self, "Empty")..")");
							textPosX=textPosX+getTextWidth(fFontSize,tostring("("..Loadstatus:get_locale(self, "Empty")..")"));
						end;
						setTextColor(1,1,1,fAlpha);
					end;
					for Index3,implement3 in pairs(implement2.object.attachedImplements) do
						if implement3.object.fillLevel ~= nil and implement3.object.capacity ~= nil and implement3.object.currentFillType ~= nil and implement3.object.name ~= nil then
							if implement3.object.fillLevel ~= nil and implement3.object.capacity ~= nil then
								FillPercentage = implement3.object.fillLevel / implement3.object.capacity * 100;
								local FillType = "";
								if implement3.object.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
									FillType = Fillable.fillTypeIntToName[implement3.object.currentFillType];
								else 
									FillType = "unknown";									
								end;
								i18FillType = "";
								if g_i18n:hasText(FillType) then
									i18FillType = g_i18n:getText(FillType);
								else 
									i18FillType = FillType;	-- if not translate version
								end;
								if Printed ~= true then 
									if (vehicle.isHired or vehicle.drive) then	setTextColor(0.72,0.80,0.98,fAlpha);	end;
									renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize, i..") "..textController..textVehicleName); -- print controler + vehicle name
									textPosX=textPosX+getTextWidth(fFontSize,tostring(i..") "..textController));
									textPosX=textPosX+getTextWidth(fFontSize,tostring(textVehicleName));
									setTextColor(1,1,1,fAlpha);
									hasFillable = true;	
									Printed = true;
								end;
								if textPosX+getTextWidth(fFontSize,tostring("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx")) > LineWrap then
									nLine = nLine + 1;
									textPosX = fPosX + getTextWidth(fFontSize,tostring(i..") "..textController..textVehicleName));
								end;
								if (vehicle.isHired or vehicle.drive) then	setTextColor(0.72,0.80,0.98,fAlpha);	end;
									renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"+"..string.sub(implement3.object.name,0, NameSizeLimit));
									textPosX=textPosX+getTextWidth(fFontSize,tostring("+"..string.sub(implement3.object.name,0, NameSizeLimit)));
									if (FillType == "fertilizer" or FillType == "seeds") and FillPercentage < 10 then 
										setTextBold(true);
										if (math.ceil(g_currentMission.environment.dayTime/1000) - global_start) % 2 < 1 then
											setTextColor(0.7,0.1,0.1,fAlpha); 
										else
											setTextColor(0.20,0.60,0.20,fAlpha);
										end;								
									end;
									renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"@");
									textPosX=textPosX+getTextWidth(fFontSize,"@");	
									if implement2.object.fillLevel > 0 then
										if dShowPercent then
											renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,tostring(math.ceil(FillPercentage - 0.5)).."%");
											textPosX=textPosX+getTextWidth(fFontSize,tostring(math.ceil(FillPercentage - 0.5)).."%");
										end;
										if dShowPercent and dShowFill then 
											renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"=");
											textPosX=textPosX+getTextWidth(fFontSize,"=");
										end							
										if dShowFill then
											renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,tostring(math.ceil(implement3.object.fillLevel)).."L");
											textPosX=textPosX+getTextWidth(fFontSize,tostring(math.ceil(implement3.object.fillLevel)).."L");
										end;							
										renderText(textPosX, fPosY-(nLine*fLineDist),fFontSize," ("..i18FillType..")");
										textPosX=textPosX+getTextWidth(fFontSize,tostring(" ("..i18FillType..")"));
--									setTextBold(false);
									else
										setTextColor(0.5,0.5,0.5,fAlpha);
										renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"("..Loadstatus:get_locale(self, "Empty")..")");
										textPosX=textPosX+getTextWidth(fFontSize,tostring("("..Loadstatus:get_locale(self, "Empty")..")"));							
									end;
									setTextColor(1,1,1,fAlpha);
								end;
						end;
							for Index3,implement4 in pairs(implement3.object.attachedImplements) do
								if implement4.object.fillLevel ~= nil and implement4.object.capacity ~= nil and implement4.object.currentFillType ~= nil and implement4.object.name ~= nil then
									if implement4.object.fillLevel ~= nil and implement4.object.capacity ~= nil then
										FillPercentage = implement4.object.fillLevel / implement4.object.capacity * 100;
										local FillType = "";
										if implement4.object.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
											FillType = Fillable.fillTypeIntToName[implement4.object.currentFillType];
										else 
											FillType = "unknown";											
										end;
										i18FillType = "";
										if g_i18n:hasText(FillType) then
											i18FillType = g_i18n:getText(FillType);
										else 
											i18FillType = FillType;	-- if not translate version
										end;
										if Printed ~= true then 
											if (vehicle.isHired or vehicle.drive) then	setTextColor(0.72,0.80,0.98,fAlpha);	end;
											renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize, i..") "..textController..textVehicleName); -- print controler + vehicle name
											Printed = true;
											textPosX=textPosX+getTextWidth(fFontSize,tostring(i..") "..textController));
											textPosX=textPosX+getTextWidth(fFontSize,tostring(textVehicleName));
											setTextColor(1,1,1,fAlpha);
											hasFillable = true;	
										end;
										if textPosX+getTextWidth(fFontSize,tostring("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx")) > LineWrap then
											nLine = nLine + 1;
											textPosX = fPosX + getTextWidth(fFontSize,"xxxxxxxxxxxxx");
										end;
										renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"+"..string.sub(implement4.object.name,0, NameSizeLimit));
										textPosX=textPosX+getTextWidth(fFontSize,tostring("+"..string.sub(implement4.object.name,0, NameSizeLimit)));
										if (vehicle.isHired or vehicle.drive) then	setTextColor(0.72,0.80,0.98,fAlpha);	end;
										if (FillType == "fertilizer" or FillType == "seeds") and FillPercentage < 10 then 
											setTextBold(true);
											if (math.ceil(g_currentMission.environment.dayTime/1000) - global_start) % 2 < 1 then
												setTextColor(0.7,0.1,0.1,fAlpha); 
												else
												setTextColor(0.20,0.60,0.20,fAlpha);
											end;											
										else
											setTextColor(0,.75,0,fAlpha);
										end;
										renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"@");
										textPosX=textPosX+getTextWidth(fFontSize,"@");	
										if implement2.object.fillLevel > 0 then
											if dShowPercent then
												renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,tostring(math.ceil(FillPercentage - 0.5)).."%");
												textPosX=textPosX+getTextWidth(fFontSize,tostring(math.ceil(FillPercentage - 0.5)).."%");
											end;
											if dShowPercent and dShowFill then 
												renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"=");
												textPosX=textPosX+getTextWidth(fFontSize,"=");
											end							
											if dShowFill then
												renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,tostring(math.ceil(implement4.object.fillLevel)).."L");
												textPosX=textPosX+getTextWidth(fFontSize,tostring(math.ceil(implement4.object.fillLevel)).."L");
											end;							
											renderText(textPosX, fPosY-(nLine*fLineDist),fFontSize," ("..i18FillType..")");
											textPosX=textPosX+getTextWidth(fFontSize,tostring(" ("..i18FillType..")"));
											setTextColor(1,1,1,fAlpha);
--											setTextBold(false);
										else
											setTextColor(0.5,0.5,0.5,fAlpha);
											renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,"("..Loadstatus:get_locale(self, "Empty")..")");
											textPosX=textPosX+getTextWidth(fFontSize,tostring("("..Loadstatus:get_locale(self, "Empty")..")"));							
										end;
									end;
								end;
							end;
						end;
					end;
				end;
				if Printed  then 
					setTextBold(false);
					local fuelPercentage = (vehicle.fuelFillLevel / vehicle.fuelCapacity +0.0001) * 100;
					if fuelPercentage > 100 then 
						fuelPercentage = 100;
					end;
					fuelPercentage = math.floor(fuelPercentage);
					if fuelPercentage <= fuelPercentWarn then												-- change color if fuel is low
						setTextBold(true);
						if (math.ceil(g_currentMission.environment.dayTime/1000) - global_start) % 2 < 1 then
							setTextColor(0.7,0.1,0.1,fAlpha); 
						else
							setTextColor(1,0,0,fAlpha);
						end;
						if textPosX+getTextWidth(fFontSize,tostring("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx")) > LineWrap then
							nLine = nLine + 1;
							textPosX = fPosX + getTextWidth(fFontSize,"xxxxxxxxxxxxx");
						end;
						renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize," "..Loadstatus:get_locale(self, "Fuel")..": "..fuelPercentage.."%");			-- print fuel %
						textPosX=textPosX+getTextWidth(fFontSize,tostring(" "..Loadstatus:get_locale(self, "Fuel")..": "..fuelPercentage.." %"));
						setTextBold(false);
						setTextColor(1,1,1,fAlpha);
					else
						setTextColor(1, 1, 0.2,fAlpha);
						renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize," "..Loadstatus:get_locale(self, "Fuel")..": "..fuelPercentage.."%");			-- print fuel %
						textPosX=textPosX+getTextWidth(fFontSize,tostring(" "..Loadstatus:get_locale(self, "Fuel")..": "..fuelPercentage.."%"));
					end;
					local lastSpeed = vehicle.lastSpeed*3600;
					if lastSpeed > 2 and lastSpeed ~= nil then
						setTextColor(0, 0.7, .7,fAlpha);
						if textPosX+getTextWidth(fFontSize,tostring("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx")) > LineWrap then
							nLine = nLine + 1;
							textPosX = fPosX + getTextWidth(fFontSize,"xxxxxxxxxxxxx");
						end;						
						if lastSpeed < 10 then
							renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize," "..Loadstatus:get_locale(self,"Speed")..":".."0"..math.floor(lastSpeed)..Loadstatus:get_locale(self, "Metric"));
							textPosX=textPosX+getTextWidth(fFontSize,tostring(" "..Loadstatus:get_locale(self,"Speed")..":".."0"..math.floor(lastSpeed)..Loadstatus:get_locale(self, "Metric")));
						else
							renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize," "..Loadstatus:get_locale(self,"Speed")..":"..math.floor(lastSpeed)..Loadstatus:get_locale(self, "Metric"));
							textPosX=textPosX+getTextWidth(fFontSize,tostring(" "..Loadstatus:get_locale(self,"Speed")..":"..math.floor(lastSpeed)..Loadstatus:get_locale(self, "Metric")));
						end;
					else
						setTextColor(0.98,0.76,0.43,fAlpha);
						renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize," <"..Loadstatus:get_locale(self, "Stop")..">");
						textPosX=textPosX+getTextWidth(fFontSize,tostring(" <"..Loadstatus:get_locale(self, "Stop")..">"));
						setTextColor(0.72,0.80,0.98,fAlpha);
					end;	
				end;
				if Printed then
					if Courseplayname ~= nil then 
						if textPosX+getTextWidth(fFontSize,tostring("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx")) > LineWrap then
							nLine = nLine + 1;
							textPosX = fPosX + getTextWidth(fFontSize,"xxxxxxxxxxxxx");
						end;
						setTextColor(0.75,0.82,0.95,fAlpha);	
						renderText(textPosX, fPosY-(nLine*fLineDist), fFontSize,tostring(" Course:"..Courseplayname));
						textPosX=textPosX+getTextWidth(fFontSize,tostring(" Course:"..Courseplayname));
						setTextColor(1,1,1,fAlpha);
					end;
				setTextColor(1,1,1,1);
				nLine = nLine + 1;
				TextPosX = fPosX;
				end;
				Printed = false;
				courseplay = false;
			end;
	end;
end;
addModEventListener(Loadstatus);
