--
-- Maple Tree Farm Map V2 
--
-- @author  Matt, Ian
-- @date  28/10/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

MapleTreeFarmMap = {}
MapleTreeFarmMap.currentModDirectory = g_modsDirectory .. "/MapleTreeFarmMapV3/";

source(MapleTreeFarmMap.currentModDirectory .. "script/timeControlledslidingGate.lua");
source(MapleTreeFarmMap.currentModDirectory .. "script/WaterMod.lua");
source(MapleTreeFarmMap.currentModDirectory .. "script/loadstatus.lua");

local MapleTreeFarmMap_mt = Class(MapleTreeFarmMap, Mission00);


function MapleTreeFarmMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = MapleTreeFarmMap_mt;
    end;
    local self = MapleTreeFarmMap:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function MapleTreeFarmMap:delete()
    MapleTreeFarmMap:superClass().delete(self);
end;

function MapleTreeFarmMap:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map01.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function MapleTreeFarmMap:loadMap01Finished(node, arguments)

    self.terrainDetailAngleNumChannels = 8; -- durch die gewünschte Anzahl Channels ersetzen
    self.terrainDetailAngleMaxValue = bitShiftLeft(1, self.terrainDetailAngleNumChannels) - 1;

    self:loadMapXMLFile(Utils.getFilename("MapleTreeFarmMap.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -166, -138, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 485, -697, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -175, -134, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- egg sellpoints
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("$dataS/missions/hud_pda_spot_eggs.png", self.baseDirectory), -170, -146, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -765, -61, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -685, -69, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
  
  -- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -411, -819, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- Grass Heaps
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 371, 686, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 208, 574, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), 469, 681, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 389, 528, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- spinnery
    g_currentMission.missionPDA:createMapHotspot("woolDeliveryHotspot", Utils.getFilename("$dataS/missions/hud_pda_spot_spinnery.png", self.baseDirectory), -183, -112, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    MapleTreeFarmMap:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function MapleTreeFarmMap:onStartMission()
    MapleTreeFarmMap:superClass().onStartMission(self);
end;

function MapleTreeFarmMap:mouseEvent(posX, posY, isDown, isUp, button)
    MapleTreeFarmMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function MapleTreeFarmMap:keyEvent(unicode, sym, modifier, isDown)
    MapleTreeFarmMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function MapleTreeFarmMap:update(dt)
    MapleTreeFarmMap:superClass().update(self, dt);
end;

function MapleTreeFarmMap:draw()
    MapleTreeFarmMap:superClass().draw(self);
end;

print("Maple Tree Farm V3 Loaded Successfully");