--
-- Maple Tree Farm Map
--
-- @author  Matt, Ian
-- @date  28/10/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

MapleTreeFarmMap = {}
MapleTreeFarmMap.currentModDirectory = g_modsDirectory .. "/MapleTreeFarmMap/";

source(MapleTreeFarmMap.currentModDirectory .. "script/timeControlledslidingGate.lua");

local MapleTreeFarmMap_mt = Class(MapleTreeFarmMap, Mission00);


function MapleTreeFarmMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = MapleTreeFarmMap_mt;
    end;
    local self = MapleTreeFarmMap:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function MapleTreeFarmMap:delete()
    MapleTreeFarmMap:superClass().delete(self);
end;

function MapleTreeFarmMap:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map01.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function MapleTreeFarmMap:loadMap01Finished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("MapleTreeFarmMap.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    --self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 1024 - 85, 1024 - 135, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), 1024 - 174, 1024 - 141, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Vehicle Shop
    --self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), 1024 + 714, 1024 + 119, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    --self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), 1024 - 175, 1024 - 136, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- farm silos
    --self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 1024 - 697, 1024 - 33, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    -- bga
    --self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 1024 - 430, 1024 - 805, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- livestock
    --self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 1024 + 655, 1024 + 256, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), 1024 - 612, 1024 + 587, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    --self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 1024 - 12, 1024 - 93, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    MapleTreeFarmMap:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function MapleTreeFarmMap:onStartMission()
    MapleTreeFarmMap:superClass().onStartMission(self);
end;

function MapleTreeFarmMap:mouseEvent(posX, posY, isDown, isUp, button)
    MapleTreeFarmMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function MapleTreeFarmMap:keyEvent(unicode, sym, modifier, isDown)
    MapleTreeFarmMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function MapleTreeFarmMap:update(dt)
    MapleTreeFarmMap:superClass().update(self, dt);
end;

function MapleTreeFarmMap:draw()
    MapleTreeFarmMap:superClass().draw(self);
end;