--
-- SampleModMap
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SampleModMap = {}

local SampleModMap_mt = Class(SampleModMap, Mission00);


function SampleModMap:new(baseDirectory, customMt)
    FruitUtil.registerFruitType("oat", g_i18n:getText("oat"), true, true, false, 0, 4, 6, 8, true, 0.4, 0.33, 0.010, true, Utils.getFilename("textures/huds/Avena.dds", baseDirectory), {1,1,1,1});
    FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_OAT, "oat_windrow", g_i18n:getText("oat_windrow"), 0.2, 3.2, false, Utils.getFilename("textures/huds/windrow.dds", baseDirectory));
    FruitUtil.registerFruitType("sunflower", g_i18n:getText("sunflower"), true, true, false, 0, 4, 6, 8, true, 0.4, 0.165, 0.002, true, Utils.getFilename("textures/huds/Girasol.dds", baseDirectory), {0.7059,1,0,1});
    FruitUtil.registerFruitType("maizev2", g_i18n:getText("maizev2"), true, true, false, 0, 4, 6, 8, true, 0.4, 1.442, 0.008, true, Utils.getFilename("textures/huds/Maizv2.dds", baseDirectory), {2,0,1,1});
    FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_MAIZEV2, "maizev2_windrow", g_i18n:getText("maizev2_windrow"), 0.2, 6.5, false, Utils.getFilename("textures/huds/windrow.dds", baseDirectory));
    FruitUtil.registerFruitType("soybean", g_i18n:getText("soybean"), true, true, false, 0, 4, 6, 8, true, 0.4, 0.542, 0.006, true, Utils.getFilename("textures/huds/Soja.dds", baseDirectory), {0,0,1,1});
    local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function SampleModMap:delete()
    SampleModMap:superClass().delete(self);
end;

function SampleModMap:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("Cielo/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("Tierra_de_Reorx.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function SampleModMap:loadMap01Finished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("Tierra_de_Reorx.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 4096, 4096);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory), 4096, 4096);

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("ImagenesPDA/Dolar.png", self.baseDirectory), 700, -610, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("ImagenesPDA/Remolque.png", self.baseDirectory), 320, -848, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("ImagenesPDA/Remolque.png", self.baseDirectory), 249, -696, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("ImagenesPDA/Remolque.png", self.baseDirectory), -1640, 416, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("ImagenesPDA/Remolque.png", self.baseDirectory), -1640, 520, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("ImagenesPDA/Remolque.png", self.baseDirectory), 490, -670, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("ImagenesPDA/Remolque.png", self.baseDirectory), -695, 1745, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("ImagenesPDA/Vacas.png", self.baseDirectory), 1024 + 521, 1024 - 1564, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("ImagenesPDA/Ovejas.png", self.baseDirectory), -1710, -1610, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("ImagenesPDA/Gallinas.png", self.baseDirectory), 1024 - 903, 1024 - 1740, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
	-- spinnery
    g_currentMission.missionPDA:createMapHotspot("woolDeliveryHotspot", Utils.getFilename("ImagenesPDA/Lana.png", self.baseDirectory), 463, 1797, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
	-- egg sellpoints
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("ImagenesPDA/Huevos.png", self.baseDirectory), -910, -280, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("ImagenesPDA/Huevos.png", self.baseDirectory), 750, 1427, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
	-- Almacen Purin
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("ImagenesPDA/Purin.png", self.baseDirectory), 1567.71997, 827.14594, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("ImagenesPDA/Purin.png", self.baseDirectory), 119.455, 653.66095, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("ImagenesPDA/Purin.png", self.baseDirectory), -1564.66992, -501.98697, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("ImagenesPDA/Purin.png", self.baseDirectory), -300.22, -1555.10999, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
	-- Puntos de agua
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("ImagenesPDA/Agua.png", self.baseDirectory), -500, 1630, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("ImagenesPDA/Agua.png", self.baseDirectory), -1050, 290, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("ImagenesPDA/Agua.png", self.baseDirectory), -270, -190, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
	-- Cerdos
	self.missionPDA:createMapHotspot("Cerdos", Utils.getFilename("ImagenesPDA/Cerdos.png", self.baseDirectory), 415, 854, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("Matadero", Utils.getFilename("ImagenesPDA/Matadero.png", self.baseDirectory), -660, -720, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
	-- Central lechera
	self.missionPDA:createMapHotspot("Leche", Utils.getFilename("ImagenesPDA/Leche.png", self.baseDirectory), 685, -352, iconSize, iconSize * (4 / 3), false, false, false, 0, true);


    SampleModMap:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function SampleModMap:onStartMission()
    SampleModMap:superClass().onStartMission(self);
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);
end;

HiredConsumesResources = {}
function HiredConsumesResources.getIsHired(self)
return false;
end;
Vehicle.getIsHired = HiredConsumesResources.getIsHired;

