--
-- Ford 8340 Extra Weights
--
-- author  Mythos
-- date  23/01/2012
-- www.Virtual-Farmers.gr
-- Copyright (C) ARM Team, All Rights Reserved.

extraWeights = {};

function extraWeights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:load(xmlFile)

	self.MpEvent= SpecializationUtil.callSpecializationsFunction("MpEvent");

	self.extraWeights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.extraWeights#count"), 0);
	self.weights = {};
    for i=1, self.extraWeights do
        local weightnamei = string.format("vehicle.extraWeights.weight%d", i);
        self.weights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, weightnamei .. "#index"));
        setVisibility(self.weights[i], false);
    end;
	
	self.currentWeight = 0;
	self.controlWeight = 0;
	self.singleWeight = 0;
	
	self.maxWeight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.maxWeight#weight"), 40);
	self.singleWeight = (self.maxWeight / self.extraWeights);
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:delete()
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:mouseEvent(posX, posY, isDown, isUp, button)
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:keyEvent(unicode, sym, modifier, isDown)
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:update(dt)
	
	if self:getIsActiveForInput() and self:getIsActive() then
	
		if InputBinding.hasEvent(InputBinding.Deutz_Gewicht) then
			self:MpEvent(2);
		end;
		
		
	end;
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:updateTick(dt)
	if self:getIsActive() then
		
		if self.weights ~= nil then
		    if self.currentWeight ~= self.controlWeight then
		        self.controlWeight = self.currentWeight;
			
			    if self.currentWeight > 0 then
		            self:MpEvent(1, true);
				else
					self:MpEvent(1, false);
			    end;
		    end;
		end;
	
	end;
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:MpEvent(mode, state, noEventSend)
	extraWeightsEvent.sendEvent(self, mode, state, noEventSend);
	
	if mode == 1 then
		if state then
			for i = 1, self.extraWeights do
				if i * self.singleWeight <= self.currentWeight then
					setVisibility(self.weights[i], true);
				end;
			end;
		else
			for i = 1, self.extraWeights do
				setVisibility(self.weights[i], false);
			end;
		end;
	elseif mode == 2 then
		if self.currentWeight >= self.maxWeight then
			self.currentWeight = 0;
		else
			self.currentWeight = self.currentWeight + self.singleWeight;
		end;
	end;
	
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.currentWeight = Utils.getNoNil(getXMLInt(xmlFile, key.."#curW"),0);
		if self.currentWeight > 0 then
            self:MpEvent(1, true);
		else
			self:MpEvent(1, false);
	    end;
	end;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'curW="'..tostring(self.currentWeight)..'"';
	local nodes = nil;
	
	return attributes,nodes;
end;

--________________________________________________________________________________________________________________________________________________________
function extraWeights:draw()
	g_currentMission:addHelpButtonText("Counterweight: " ..string.format("%d kg", self.currentWeight*110), InputBinding.Deutz_Gewicht);
end;



extraWeightsEvent = {};
extraWeightsEvent_mt = Class(extraWeightsEvent, Event);

InitEventClass(extraWeightsEvent, "extraWeightsEvent");

function extraWeightsEvent:emptyNew()
    local self = Event:new(extraWeightsEvent_mt);
    self.className="extraWeightsEvent";
    return self;
end;

function extraWeightsEvent:new(vehicle, mode, state)
    local self = extraWeightsEvent:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
	self.state = state;
    return self;
end;

function extraWeightsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function extraWeightsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, self.mode);
	streamWriteBool(streamId, self.state);
end;

function extraWeightsEvent:run(connection)
	self.vehicle:MpEvent(self.mode, self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(extraWeightsEvent:new(self.vehicle, self.mode, self.state), nil, connection, self.vehicle);
    end;
end;

function extraWeightsEvent.sendEvent(vehicle, mode, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(extraWeightsEvent:new(vehicle, mode, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(extraWeightsEvent:new(vehicle, mode, state));
		end;
	end;
end;
