--
-- By PeterJ (04-04-2011)
--

ParticelSystem = {};

function ParticelSystem.prerequisitesPresent(specializations)
    return true;
end;

function ParticelSystem:load(xmlFile)	
	self.ParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.ParticleSystems.node(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.ParticleSystems, namei     , nodei    , false               , nil          , self.baseDirectory)		
		i = i +1;		
    end;	
    self.ParticleSystemActive = false;
end;

function ParticelSystem:delete()
    Utils.deleteParticleSystem(self.ParticleSystems);
end;

function ParticelSystem:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ParticelSystem:keyEvent(unicode, sym, modifier, isDown)
end;

function ParticelSystem:update(dt)
    if self:getIsActive() then
        if self.isTurnedOn and (self:isLowered(false)) then
            if not self.ParticleSystemActive then
				Utils.setEmittingState(self.ParticleSystems, true);
                self.ParticleSystemActive = true;
            end;
		else
            if self.ParticleSystemActive then
				Utils.setEmittingState(self.ParticleSystems, false);			
                self.ParticleSystemActive = false;
            end;
        end;
    end;
end;


function ParticelSystem:draw()
end;

function ParticelSystem:onLeave()
    if self.deactivateOnLeave then
        ParticelSystem.onDeactivate(self);
    end;
end;

function ParticelSystem:onDeactivate()
    if self.ParticleSystemActive then
		Utils.setEmittingState(self.ParticleSystems, false);
        self.ParticleSystemActive = false;
    end;
end;