AttachEvent = {};
AttachEvent_mt = Class(AttachEvent, Event);

InitEventClass(AttachEvent, "AttachEvent");

function AttachEvent:emptyNew()
    local self = Event:new(AttachEvent_mt);
    self.className="AttachEvent";
    return self;
end;

function AttachEvent:new(object)
    local self = AttachEvent:emptyNew()
    self.object = object;
    return self;
end;

function AttachEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function AttachEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
end;

function AttachEvent:run(connection)
	if not self.object.isBaleAttached then
		self.object:attachBale();
		self.object.isBaleAttached = true;
	end;
    if not connection:getIsServer() then
        g_server:broadcastEvent(AttachEvent:new(self.object), nil, connection, self.object);
    end;	
end;

function AttachEvent.sendEvent(vehicle, noEventSend)
			if noEventSend == nil or noEventSend == false then
				if g_server ~= nil then
					g_server:broadcastEvent(AttachEvent:new(vehicle), nil, nil, vehicle);
				else
					g_client:getServerConnection():sendEvent(AttachEvent:new(vehicle));
				end;
			end;
end;



DetachEvent = {};
DetachEvent_mt = Class(DetachEvent, Event);

InitEventClass(DetachEvent, "DetachEvent");

function DetachEvent:emptyNew()
    local self = Event:new(DetachEvent_mt);
    self.className="DetachEvent";
    return self;
end;

function DetachEvent:new(object)
    local self = DetachEvent:emptyNew()
    self.object = object;
    return self;
end;

function DetachEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function DetachEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
end;

function DetachEvent:run(connection)
	if self.object.isBaleAttached then
		self.object:detachBale();
	end;
    if not connection:getIsServer() then
        g_server:broadcastEvent(DetachEvent:new(self.object), nil, connection, self.object);
    end;	
end;

function DetachEvent.sendEvent(vehicle, noEventSend)
			if noEventSend == nil or noEventSend == false then
				if g_server ~= nil then
					g_server:broadcastEvent(DetachEvent:new(vehicle), nil, nil, vehicle);
				else
					g_client:getServerConnection():sendEvent(DetachEvent:new(vehicle));
				end;
			end;
end;



SetOpenStateEvent = {};
SetOpenStateEvent_mt = Class(SetOpenStateEvent, Event);

InitEventClass(SetOpenStateEvent, "SetOpenStateEvent");

function SetOpenStateEvent:emptyNew()
    local self = Event:new(SetOpenStateEvent_mt);
    self.className="SetOpenStateEvent";
    return self;
end;

function SetOpenStateEvent:new(object, isClosed)
    local self = SetOpenStateEvent:emptyNew()
    self.object = object;
	self.isClosed = isClosed;
    return self;
end;

function SetOpenStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isClosed = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetOpenStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isClosed);
end;

function SetOpenStateEvent:run(connection)
	self.object:setOpenState(self.isClosed, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetOpenStateEvent:new(self.object, self.isClosed), nil, connection, self.object);
    end;	
end;

function SetOpenStateEvent.sendEvent(vehicle, isClosed, noEventSend)
			if noEventSend == nil or noEventSend == false then
				if g_server ~= nil then
					g_server:broadcastEvent(SetOpenStateEvent:new(vehicle, isClosed), nil, nil, vehicle);
				else
					g_client:getServerConnection():sendEvent(SetOpenStateEvent:new(vehicle, isClosed));
				end;
			end;
end;