--VT_150
-- Nevan

VT_150 = {};

function VT_150.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;
function VT_150:load(xmlFile)
 
	local motorMinRpm = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#minRpm"), 330);
    local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 600);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1000);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 1500);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    self.motorMaxRpmLimit = motorMaxRpm;
	self.MinRpm = motorMinRpm;
	self.DEC = false;
	self.ACC = false;
	
    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	--Doors
	local rotationPartNoderightdoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rightdoor#index"));
    if rotationPartNoderightdoor ~= nil then
        self.rotationPartrightdoor = {};
        self.rotationPartrightdoor.node = rotationPartNoderightdoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor#minRot"));
        self.rotationPartrightdoor.minRot = {};
        self.rotationPartrightdoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor#maxRot"));
        self.rotationPartrightdoor.maxRot = {};
        self.rotationPartrightdoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartrightdoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#rotTime"), 2)*1000;
        self.rotationPartrightdoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#touchRotLimit"), 10));
    end;

    local rotationPartNodeleftDoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.leftDoor#index"));
    if rotationPartNodeleftDoor ~= nil then
        self.rotationPartleftDoor = {};
        self.rotationPartleftDoor.node = rotationPartNodeleftDoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor#minRot"));
        self.rotationPartleftDoor.minRot = {};
        self.rotationPartleftDoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor#maxRot"));
        self.rotationPartleftDoor.maxRot = {};
        self.rotationPartleftDoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleftDoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#rotTime"), 2)*1000;
        self.rotationPartleftDoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#touchRotLimit"), 10));
    end;
	
	--Tahometr
	
	local rotationPartNodeDrehzahl1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tahometr#index"));
    if rotationPartNodeDrehzahl1 ~= nil then
        self.tahometr = {};
        self.tahometr.node = rotationPartNodeDrehzahl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tahometr#minRot"));
        self.tahometr.minRot = {};
        self.tahometr.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tahometr.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tahometr.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tahometr#maxRot"));
        self.tahometr.maxRot = {};
        self.tahometr.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tahometr.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tahometr.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    end;
	
	--Gaz
	
	local rotationPartNodeGaz = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.gaz#index"));
    if rotationPartNodeGaz ~= nil then
        self.gaz = {};
        self.gaz.node = rotationPartNodeGaz;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.gaz#minRot"));
        self.gaz.minRot = {};
        self.gaz.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.gaz.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.gaz.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.gaz#maxRot"));
        self.gaz.maxRot = {};
        self.gaz.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.gaz.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.gaz.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    end;
	
	--Toplivo
	
	local rotationPartNodeTanknadel = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.toplivo#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.toplivo = {};
        self.toplivo.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.toplivo#minRot"));
        self.toplivo.minRot = {};
        self.toplivo.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.toplivo.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.toplivo.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.toplivo#maxRot"));
        self.toplivo.maxRot = {};
        self.toplivo.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.toplivo.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.toplivo.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
    end;
	
	--Strelki
	
	local strelkiCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.strelki#count"), 0);
    self.strelki = {};
    for i=1, strelkiCount do
		local strelka = {};
        local strelkaName = string.format("vehicle.strelki.strelka%d", i);
		strelka.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, strelkaName .. "#index"));
		
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, strelkaName .. "#maxRot"));
		strelka.maxRotx = Utils.degToRad(Utils.getNoNil(x, 0));
		strelka.maxRoty = Utils.degToRad(Utils.getNoNil(y, 0));
		strelka.maxRotz = Utils.degToRad(Utils.getNoNil(z, 0));
		
		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, strelkaName .. "#minRot"));
		strelka.minRotx = Utils.degToRad(Utils.getNoNil(x, 0));
		strelka.minRoty = Utils.degToRad(Utils.getNoNil(y, 0));
		strelka.minRotz = Utils.degToRad(Utils.getNoNil(z, 0));
		table.insert(self.strelki, strelka);
    end;
	
	--Seryga
	
	self.mirrors = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.seryga#index"));
    
end;

function VT_150:delete()
end;

function VT_150:mouseEvent(posX, posY, isDown, isUp, button)
end;

function VT_150:keyEvent(unicode, sym, modifier, isDown)
   
	if sym == self.keys.ACCELERATE then 
		self.ACC = isDown;
    end;
	if sym == self.keys.DECELERATE then 
		self.DEC = isDown;
    end;
	-- Doors
	 if isDown and sym == self.keys.RIGHR_DOOR then 
	self.rotationMaxrightdoor = not self.rotationMaxrightdoor;
	self.rotationMaxrightdoor1 = not self.rotationMaxrightdoor1;
    end; 
    if isDown and sym == self.keys.LEFT_DOOR then 
	self.rotationMaxleftDoor = not self.rotationMaxleftDoor;
	self.rotationMaxleftDoor1 = not self.rotationMaxleftDoor1;
    end;
	--Seryga
	 if isDown and sym == self.keys.SERYGA then 
		self.drawMirror = not self.drawMirror;
		setVisibility(self.mirrors, self.drawMirror);
    end;
	
end;

function VT_150:update(dt)
	if self.isEntered then
	    if self.motor.speedLevel ~= 0 then
            if self.ACC then
		        if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 10;
			    end;
		    elseif self.DEC then
					if self.motor.maxRpm[self.motor.speedLevel] >= 10 then
			        self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 10;
				end;
			end;
		elseif self.ACC then
		        if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit[3] - 10) then
		            self.motor.maxRpm[3] = self.motor.maxRpm[3] + 10;
			    end;
		    else
			if self.DEC then
		        if self.motor.maxRpm[3] >= 10 then
			        self.motor.maxRpm[3] = self.motor.maxRpm[3] - 10;
			    end;
	    	end;
		end;
	end;
	--Doors
	 if self.rotationPartleftDoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartleftDoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleftDoor.maxRot, self.rotationPartleftDoor.minRot, 3, self.rotationPartleftDoor.rotTime, dt, not self.rotationMaxleftDoor);
		   setRotation(self.rotationPartleftDoor.node, unpack(newRot));
    end;
        
	if self.rotationPartrightdoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartrightdoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartrightdoor.maxRot, self.rotationPartrightdoor.minRot, 3, self.rotationPartrightdoor.rotTime, dt, not self.rotationMaxrightdoor);
		   setRotation(self.rotationPartrightdoor.node, unpack(newRot));
    end;
	
	--Tahometr
	
	if self.isMotorStarted then
		if self.tahometr ~= nil then
			local x, y, z = getRotation(self.tahometr.node);
			local pr = (self.motor.lastMotorRpm * 100) / self.motorMaxRpmLimit[3];
			y = (self.tahometr.maxRot[2] * pr) / 100;
			setRotation(self.tahometr.node, x, y ,z);
		end;
	else
		setRotation(self.tahometr.node, 0, 0 ,0);
	end;
	
	--Gaz
	
	if self.gaz ~= nil then
		local x, y, z = getRotation(self.gaz.node);
		local pr = ((self.motor.lastMotorRpm - self.MinRpm) * 100) / self.motorMaxRpmLimit[3];
		y = (self.gaz.maxRot[2] * pr) / 100;
		setRotation(self.gaz.node, x, y ,z);
	end;
	
	--Toplivo
	
	if self.isMotorStarted then
		if self.toplivo ~= nil then
			local x, y, z = getRotation(self.toplivo.node);
			y = ((self.toplivo.maxRot[2] - self.toplivo.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.toplivo.minRot[2];
			setRotation(self.toplivo.node, x, y ,z);
		end;
	else
		setRotation(self.toplivo.node, 0, 0 ,0);
	end;
	
	--Strelki
	
	for _, strelka in pairs(self.strelki) do
		if self.isMotorStarted then
			
			local x, y, z = getRotation(strelka.node);
			y = strelka.maxRoty;
			setRotation(strelka.node, x, y ,z);
			
		else
			setRotation(strelka.node, 0, 0 ,0);
		end;
	end;
	
  end;

function VT_150:draw()
    if self.motor.speedLevel ~= 0 then
        g_currentMission:addExtraPrintText("Taste NUM +/-:            "..string.format("%d RPM",self.motor.maxRpm[self.motor.speedLevel]).."");
	else
        g_currentMission:addExtraPrintText("Taste NUM +/-:            "..string.format("%d RPM",self.motor.maxRpm[3]).."");
	end;
  
end;

function VT_150:onEnter()
    self.isEntered = true;
end;

function VT_150:onLeave()

    self.isEntered = false;
   
end;

