--
-- Naves
-- author: werik
--

Naves = {};

function Naves.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Naves:load(xmlFile)
	local rotationNode8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation8#index"));
    if rotationNode8 ~= nil then
        self.rotation8 = {};
        self.rotation8.node = rotationNode8;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation8#minRot"));
        self.rotation8.minRot = {};
        self.rotation8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation8#maxRot"));
        self.rotation8.maxRot = {};
        self.rotation8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation8#rotTime"), 2)*1000;
        self.rotation8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation8#touchRotLimit"), 10));
    end;
end;

function Naves:readStream(streamId, connection)
end;

function Naves:writeStream(streamId, connection)
end;

function Naves:delete()
end;

 
function Naves:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Naves:keyEvent(unicode, sym, modifier, isDown)
	if sym == Input.KEY_n then
		self.rotation8Max = isDown;
	end;
	if sym == Input.KEY_m then
		self.rotation8Min = isDown;
	end;
end;
 
function Naves:update(dt)
	local doRotate = self.rotation8Max or self.rotation8Min 
	if self.rotation8 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation8.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation8.maxRot, self.rotation8.minRot, 3, self.rotation8.rotTime, dt, not self.rotation8Max);
        setRotation(self.rotation8.node, unpack(newRot));
    end;
end;

function Naves:onLeave()
end;

function Naves:draw()
end;

function Naves:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
