--
-- Some fixes for the first LS Gold Edition release
--
-- @author  Stefan Geiger
-- @date  27/12/09
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

print("loading mod fix");

if g_goldEditionVersion == nil or g_goldEditionVersion < 2  then
    print("Applying the Farming Simulator 2009 Gold Edition Patch 1");

    Cylindered.loadFromAttributesAndNodes = function(self, xmlFile, key, resetVehicles)
        return BaseMission.VEHICLE_LOAD_OK;
    end;
    
    
    -- SowingMachine fix
    SowingMachine.update = function(self, dt)

        if self:getIsActiveForInput() then
            if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
                if self.selectable then
                    self.currentSeed = self.currentSeed + 1;
                    if self.currentSeed > table.getn(self.seeds) then
                        self.currentSeed = 1;
                    end;
                end;
            end;
            if self.needsActivation then
                if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
                    self.isTurnedOn = not self.isTurnedOn;
                end;
            end;
        end;

        if self:getIsActive() then

            local hasGroundContact = false;
            for k, v in pairs(self.contactReportNodes) do
                if v.hasGroundContact then
                    hasGroundContact = true;
                    break;
                end;
            end;

            if not hasGroundContact then
                for k,v in pairs(self.wheels) do
                    if v.hasGroundContact then
                        hasGroundContact = true;
                        break;
                    end;
                end;
                if not hasGroundContact then
                    if self.groundReferenceNode ~= nil then
                        local x,y,z = getWorldTranslation(self.groundReferenceNode);
                        local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
                        if terrainHeight+self.groundReferenceThreshold >= y then
                            hasGroundContact = true;
                        end;
                    end;
                end;
            end;

            local foldAnimTime = self.foldAnimTime;
            if self.movingDirection > 0 and hasGroundContact then
                local enableGroundParticleSystems = false;
                if not self.needsActivation or self.isTurnedOn then
                    if (self.lastSpeed*3600 > 5) then
                        enableGroundParticleSystems = true;
                    end;
                    for k, cuttingArea in pairs(self.cuttingAreas) do
                        local ps = self.newGroundParticleSystems[k];
                        if foldAnimTime == nil or (foldAnimTime <= cuttingArea.foldMaxLimit and foldAnimTime >= cuttingArea.foldMinLimit) then
                            local x,y,z = getWorldTranslation(cuttingArea.start);
                            local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                            local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
                            local area = Utils.updateSowingArea(self.seeds[self.currentSeed], x, z, x1, z1, x2, z2);

                            local fruitDesc = FruitUtil.fruitIndexToDesc[self.seeds[self.currentSeed] ];

                            local pixelToQm = 2048 / 8192 * 2048 / 8192; -- 8192px are mapped to 2048m
                            local qm = area*pixelToQm;
                            local ha = qm/10000;
                            local usage = fruitDesc.seedUsagePerQm*qm;
                            g_currentMission.missionStats.seedUsageTotal = g_currentMission.missionStats.seedUsageTotal + usage;
                            g_currentMission.missionStats.seedUsageSession = g_currentMission.missionStats.seedUsageSession + usage;

                            g_currentMission.missionStats.hectaresSeededTotal = g_currentMission.missionStats.hectaresSeededTotal + ha;
                            g_currentMission.missionStats.hectaresSeededSession = g_currentMission.missionStats.hectaresSeededSession + ha;

                            local seedPrice = fruitDesc.seedPricePerLiter*usage;
                            g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + seedPrice;
                            g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + seedPrice;

                            g_currentMission.missionStats.money = g_currentMission.missionStats.money - seedPrice;

                            if ps ~= nil then
                                if enableGroundParticleSystems and not ps.isActive then
                                    ps.isActive = true;
                                    Utils.setEmittingState(ps.ps, true);
                                end;
                            end;
                        else
                            if ps ~= nil and ps.isActive then
                                ps.isActive = false;
                                Utils.setEmittingState(ps.ps, false);
                            end;
                        end;
                    end;
                    g_currentMission.missionStats.seedingDurationTotal = g_currentMission.missionStats.seedingDurationTotal + dt/(1000*60);
                    g_currentMission.missionStats.seedingDurationSession = g_currentMission.missionStats.seedingDurationSession + dt/(1000*60);

                    local speedLimit = 20;
                    if self.maxSpeedLevel == 2 then
                        speedLimit = 30;
                    elseif self.maxSpeedLevel == 3 then
                        speedLimit = 100;
                    end;
                    if self:doCheckSpeedLimit() and self.lastSpeed*3600 > speedLimit then
                        self.speedViolationTimer = self.speedViolationTimer - dt;
                        if self.speedViolationTimer < 0 then
                            if self.attacherVehicle ~= nil then
                                self.attacherVehicle:detachImplementByObject(self);
                            end;
                        end;
                    else
                        self.speedViolationTimer = self.speedViolationMaxTime;
                    end;
                else
                    self.speedViolationTimer = self.speedViolationMaxTime;
                end;

                if enableGroundParticleSystems and not self.groundParticleSystemActive then
                    self.groundParticleSystemActive = true;
                    Utils.setEmittingState(self.groundParticleSystems, true);
                end;

                if not enableGroundParticleSystems and self.groundParticleSystemActive then
                    self.groundParticleSystemActive = false;
                    Utils.setEmittingState(self.groundParticleSystems, false);
                end;

                if not enableGroundParticleSystems then
                    for k, ps in pairs(self.newGroundParticleSystems) do
                        if ps.isActive then
                            ps.isActive = false;
                            Utils.setEmittingState(ps.ps, false);
                        end;
                    end;
                end;

                if self.sowingSound ~= nil then
                    if self.lastSpeed*3600 > 3 and (not self.needsActivation or self.isTurnedOn) then
                        if not self.sowingSoundEnabled  and self:getIsActiveForSound() then
                            playSample(self.sowingSound, 0, self.sowingSoundVolume, 0);
                            setSamplePitch(self.sowingSound, self.sowingSoundPitchOffset);
                            self.sowingSoundEnabled = true;
                        end;
                    else
                        if self.sowingSoundEnabled then
                            stopSample(self.sowingSound);
                            self.sowingSoundEnabled = false;
                        end;
                    end;
                end;

                for k,v in pairs(self.speedRotatingParts) do
                    if foldAnimTime == nil or (foldAnimTime <= v.foldMaxLimit and foldAnimTime >= v.foldMinLimit) then
                        rotate(v.node, v.rotationSpeedScale * self.lastSpeedReal * self.movingDirection * dt, 0, 0);
                    end;
                end;

            else
                if self.groundParticleSystemActive then
                    self.groundParticleSystemActive = false;
                    Utils.setEmittingState(self.groundParticleSystems, false);
                end;
                for k, ps in pairs(self.newGroundParticleSystems) do
                    if ps.isActive then
                        ps.isActive = false;
                        Utils.setEmittingState(ps.ps, false);
                    end;
                end;
                self.speedViolationTimer = self.speedViolationMaxTime;
                SowingMachine.onDeactivateSounds(self);
            end;
        end;
    end;
end;
