

visibility = {};

function visibility.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function visibility:load(xmlFile)

    numparts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts#count"), 0);
	self.parts = {};
    for i=1, numparts do
        local partnamei = string.format("vehicle.parts.part%d", i);
        self.parts[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts[i], false);
    end;
	self.partsActive = false;
	
	numparts2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts2#count"), 0);
	self.parts2 = {};
    for i=1, numparts2 do
        local partnamei = string.format("vehicle.parts2.part%d", i);
        self.parts2[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts2[i], false);
    end;
	self.parts2Active = false;
	
end;

function visibility:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == Input.KEY_u then 
	  self.partsActive = not self.partsActive;
	end;
	if isDown and sym == Input.KEY_l then 
		self.parts2Active = not self.parts2Active;
	end;

end;


function visibility:update(dt)

  if self.partsActive then
		for i=1, numparts do
			setVisibility(self.parts[i], self.partsActive);
		end;
	        else
		for i=1, numparts do
			setVisibility(self.parts[i], self.partsActive, false);
	    end;
	end;
   if self.parts2Active then
		for i=1, numparts2 do
			setVisibility(self.parts2[i], self.parts2Active);
		end;
	        else
		for i=1, numparts2 do
			setVisibility(self.parts2[i], self.parts2Active, false);
	    end;	
    end;
end;

function visibility:draw()
end;

function visibility:onEnter()

end;

function visibility:onLeave()
end;

function visibility:delete()
end;

function visibility:mouseEvent(posX, posY, isDown, isUp, button)
end;