--
-- BuyableDualRearAttacher
-- Specialization for BuyableDualRearAttacher
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  23/04/10
-- @history:	v1.0 and v2.0 by SFM
--				

BuyableDualRearAttacher = {};

function BuyableDualRearAttacher.prerequisitesPresent(specializations)
    return true;
end;

function BuyableDualRearAttacher:load(xmlFile)

	self.onAssembling = SpecializationUtil.callSpecializationsFunction("onAssembling");
	self.onDisassembling = SpecializationUtil.callSpecializationsFunction("onDisassembling");
	
	self.BuyableDualRear = {};
	self.BuyableDualRear.checkString = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheels#twinWheelsCheckString"), "standart");
	self.BuyableDualRear.twinWheels = nil;
	self.BuyableDualRear.wheelsInRange = nil;

   --DURAL
	RealisticVehicle.registerExtraMassGetter(self, BuyableDualRearAttacher.getCurrentMass);	
end;
function BuyableDualRearAttacher:getCurrentMass()

	--[[
	if self.BuyableDualRear.twinWheels~=nil then
		local mass = self.BuyableDualRear.twinWheels.realAdditionalMass;
		local comTrans = self.BuyableDualRear.twinWheels.realComTrans;
		if mass~=nil and comTrans~=nil then
			--print("BuyableDualRearAttacher:getCurrentMass - mass=" .. tostring(self.BuyableDualRear.twinWheels.realAdditionalMass) .. " comtrans=" .. tostring(self.BuyableDualRear.twinWheels.realComTrans.z));
			return mass, comTrans;
		end
	end; 
	]]--
	
	local mass = 0;
	local comTrans = {x=0, y=0, z=0};
	if self.BuyableDualRear.twinWheelsBack ~= nil then
		mass = mass + self.BuyableDualRear.twinWheelsBack.realAdditionalMass;
		local ct = self.BuyableDualRear.twinWheelsBack.realComTrans;			
		comTrans.x = comTrans.x + ct.x;
		comTrans.y = comTrans.y + ct.y;
		comTrans.z = comTrans.z + ct.z;
	end;
	--	if mass ~= nil and comTrans ~= nil then
	--		--print("BuyableDualRearAttacher:getCurrentMass - mass=" .. tostring(self.BuyableDualRear.twinWheels.realAdditionalMass) .. " comtrans=" .. tostring(self.BuyableDualRear.twinWheels.realComTrans.z));
	--		return mass, comTrans;
	--	end
	--end;	
	return mass, comTrans;		
	
end;
function BuyableDualRearAttacher:delete()
	if self.BuyableDualRear.twinWheels ~= nil then
		self.BuyableDualRear.twinWheels:disassembleWheels(true);
	end;
end;

function BuyableDualRearAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BuyableDualRearAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function BuyableDualRearAttacher:update(dt)

	if self:getIsActive() then
		local wheels = self.BuyableDualRear;
		if wheels.wheelsInRange ~= nil then
			if self:getIsActiveForInput() then
				if InputBinding.hasEvent(InputBinding.CaseFilipe) then
					if wheels.twinWheels == nil then
						wheels.wheelsInRange:assembleWheels(self);
					else
						if wheels.wheelsInRange.twinWheelsUser == self then
							wheels.wheelsInRange:disassembleWheels();
						end;
					end;
				end;
			end;
		end;
	end;
end;

function BuyableDualRearAttacher:draw()
	local wheels = self.BuyableDualRear;
	if wheels.wheelsInRange ~= nil then
		if wheels.twinWheels ~= nil then
			if wheels.wheelsInRange.twinWheelsUser == self then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_disassemble"), InputBinding.CaseFilipe);
			end;
		else
			if wheels.wheelsInRange.twinWheelsUser == nil then
				g_currentMission:addHelpButtonText(g_i18n:getText("BuyableTwinWheels_assemble"), InputBinding.CaseFilipe);
			end;
		end;
	end;
end;

function BuyableDualRearAttacher:onAssembling(BuyableDualRear)
	self.BuyableDualRear.twinWheels = BuyableDualRear;
	if self.setFenderVisibility ~= nil then
		self:setFenderVisibility(true);
	end;
end;

function BuyableDualRearAttacher:onDisassembling()
	self.BuyableDualRear.twinWheels = nil;
   if self.setFenderVisibility ~= nil then
		self:setFenderVisibility(false);
	end;
end;
