--
-- UAZ
-- author: werik
--

UAZ = {};

function UAZ.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function UAZ:load(xmlFile)

-- door

	local rotationPartNodeleft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.left#index"));
    if rotationPartNodeleft ~= nil then
        self.rotationPartleft = {};
        self.rotationPartleft.node = rotationPartNodeleft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartleft#minRot"));
        self.rotationPartleft.minRot = {};
        self.rotationPartleft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.left#maxRot"));
        self.rotationPartleft.maxRot = {};
        self.rotationPartleft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.left#rotTime"), 2)*1000;
        self.rotationPartleft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.left#touchRotLimit"), 10));
    end;

	local rotationPartNoderight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.right#index"));
    if rotationPartNoderight ~= nil then
        self.rotationPartright = {};
        self.rotationPartright.node = rotationPartNoderight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartright#minRot"));
        self.rotationPartright.minRot = {};
        self.rotationPartright.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartright.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartright.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.right#maxRot"));
        self.rotationPartright.maxRot = {};
        self.rotationPartright.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartright.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartright.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartright.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.right#rotTime"), 2)*1000;
        self.rotationPartright.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.right#touchRotLimit"), 10));
    end;

	local rotationPartNodeleft2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.left2#index"));
    if rotationPartNodeleft2 ~= nil then
        self.rotationPartleft2 = {};
        self.rotationPartleft2.node = rotationPartNodeleft2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartleft2#minRot"));
        self.rotationPartleft2.minRot = {};
        self.rotationPartleft2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleft2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleft2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.left2#maxRot"));
        self.rotationPartleft2.maxRot = {};
        self.rotationPartleft2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleft2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleft2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleft2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.left2#rotTime"), 2)*1000;
        self.rotationPartleft2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.left2#touchRotLimit"), 10));
    end;

	local rotationPartNoderight2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.right2#index"));
    if rotationPartNoderight2 ~= nil then
        self.rotationPartright2 = {};
        self.rotationPartright2.node = rotationPartNoderight2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartrigh2#minRot"));
        self.rotationPartright2.minRot = {};
        self.rotationPartright2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartright2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartright2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.right2#maxRot"));
        self.rotationPartright2.maxRot = {};
        self.rotationPartright2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartright2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartright2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartright2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.right2#rotTime"), 2)*1000;
        self.rotationPartright2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.right2#touchRotLimit"), 10));
    end;

	local rotationPartNodecenter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.center#index"));
    if rotationPartNodecenter~= nil then
        self.rotationPartcenter = {};
        self.rotationPartcenter.node = rotationPartNodecenter;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartcenter#minRot"));
        self.rotationPartcenter.minRot = {};
        self.rotationPartcenter.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartcenter.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartcenter.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.center#maxRot"));
        self.rotationPartcenter.maxRot = {};
        self.rotationPartcenter.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartcenter.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartcenter.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartcenter.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.center#rotTime"), 2)*1000;
        self.rotationPartcenter.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.center#touchRotLimit"), 10));
    end;

	local rotationPartNodeback = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.back#index"));
    if rotationPartNodeback~= nil then
        self.rotationPartback = {};
        self.rotationPartback.node = rotationPartNodeback;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartback#minRot"));
        self.rotationPartback.minRot = {};
        self.rotationPartback.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartback.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartback.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.back#maxRot"));
        self.rotationPartback.maxRot = {};
        self.rotationPartback.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartback.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartback.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartback.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.back#rotTime"), 2)*1000;
        self.rotationPartback.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.back#touchRotLimit"), 10));
    end;

-- tahometr

local rotationPartNodetahometr = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tahometr#index"));
    if rotationPartNodetahometr ~= nil then
        self.rotationParttahometr = {};
        self.rotationParttahometr.node = rotationPartNodetahometr;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tahometr#minRot"));
        self.rotationParttahometr.minRot = {};
        self.rotationParttahometr.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParttahometr.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParttahometr.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tahometr#maxRot"));
        self.rotationParttahometr.maxRot = {};
        self.rotationParttahometr.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParttahometr.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParttahometr.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParttahometr.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tahometr#rotTime"), 2)*1000;
        self.rotationParttahometr.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tahometr#touchRotLimit"), 10));
    end;

-- spidometr

local rotationPartNodeKmh1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartKmh1#index"));
    if rotationPartNodeKmh1 ~= nil then
        self.rotationPartKmh1 = {};
        self.rotationPartKmh1.node = rotationPartNodeKmh1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#minRot"));
        self.rotationPartKmh1.minRot = {};
        self.rotationPartKmh1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartKmh1#maxRot"));
        self.rotationPartKmh1.maxRot = {};
        self.rotationPartKmh1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartKmh1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartKmh1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartKmh1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#rotTime"), 2)*1000;
        self.rotationPartKmh1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartKmh1#touchRotLimit"), 10));
    end;

-- toplivo

local rotationPartNodeTanknadel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;

    fuelwarningSoundFile = Utils.getFilename("sound/fuelwarning.wav", self.baseDirectory);
    self.fuelwarningSoundId = createSample("fuelwarningSound");
    loadSample(self.fuelwarningSoundId, fuelwarningSoundFile, false);
    self.fuelwarningPlaying = false;
	self.playedSound = false;
	self.ledriserva = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ledriserva#index"));
	self.ledriservaActive = false;
	self.riserva = 5;

-- voda

local rotationPartNodevoda1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda1#index"));
    if rotationPartNodevoda1 ~= nil then
        self.rotationPartvoda1 = {};
        self.rotationPartvoda1.node = rotationPartNodevoda1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda1#minRot"));
        self.rotationPartvoda1.minRot = {};
        self.rotationPartvoda1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda1#maxRot"));
        self.rotationPartvoda1.maxRot = {};
        self.rotationPartvoda1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda1#rotTime"), 2)*1000;
        self.rotationPartvoda1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda1#touchRotLimit"), 10));
    end;
local rotationPartNodevoda2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda2#index"));
    if rotationPartNodevoda2 ~= nil then
        self.rotationPartvoda2 = {};
        self.rotationPartvoda2.node = rotationPartNodevoda2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda2#minRot"));
        self.rotationPartvoda2.minRot = {};
        self.rotationPartvoda2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda2#maxRot"));
        self.rotationPartvoda2.maxRot = {};
        self.rotationPartvoda2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda2#rotTime"), 2)*1000;
        self.rotationPartvoda2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda2#touchRotLimit"), 10));
    end;
local rotationPartNodevoda3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda3#index"));
    if rotationPartNodevoda3 ~= nil then
        self.rotationPartvoda3 = {};
        self.rotationPartvoda3.node = rotationPartNodevoda3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda3#minRot"));
        self.rotationPartvoda3.minRot = {};
        self.rotationPartvoda3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda3#maxRot"));
        self.rotationPartvoda3.maxRot = {};
        self.rotationPartvoda3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda3#rotTime"), 2)*1000;
        self.rotationPartvoda3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda3#touchRotLimit"), 10));
    end;
local rotationPartNodevoda4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda4#index"));
    if rotationPartNodevoda4 ~= nil then
        self.rotationPartvoda4 = {};
        self.rotationPartvoda4.node = rotationPartNodevoda4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda4#minRot"));
        self.rotationPartvoda4.minRot = {};
        self.rotationPartvoda4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda4#maxRot"));
        self.rotationPartvoda4.maxRot = {};
        self.rotationPartvoda4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda4#rotTime"), 2)*1000;
        self.rotationPartvoda4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda4#touchRotLimit"), 10));
    end;
local rotationPartNodevoda5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda5#index"));
    if rotationPartNodevoda5 ~= nil then
        self.rotationPartvoda5 = {};
        self.rotationPartvoda5.node = rotationPartNodevoda5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda5#minRot"));
        self.rotationPartvoda5.minRot = {};
        self.rotationPartvoda5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda5#maxRot"));
        self.rotationPartvoda5.maxRot = {};
        self.rotationPartvoda5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda5#rotTime"), 2)*1000;
        self.rotationPartvoda5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda5#touchRotLimit"), 10));
    end;
local rotationPartNodevoda6 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.voda6#index"));
    if rotationPartNodevoda6 ~= nil then
        self.rotationPartvoda6 = {};
        self.rotationPartvoda6.node = rotationPartNodevoda6;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda6#minRot"));
        self.rotationPartvoda6.minRot = {};
        self.rotationPartvoda6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.voda6#maxRot"));
        self.rotationPartvoda6.maxRot = {};
        self.rotationPartvoda6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartvoda6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartvoda6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartvoda6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda6#rotTime"), 2)*1000;
        self.rotationPartvoda6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.voda6#touchRotLimit"), 10));
    end;
end;

function UAZ:readStream(streamId, connection)
end;

function UAZ:writeStream(streamId, connection)
end;

function UAZ:delete()
end;

 
function UAZ:mouseEvent(posX, posY, isDown, isUp, button)
end;

function UAZ:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_KP_4 then 
		self.rotationMaxleft = not self.rotationMaxleft;
		self.rotationMaxaleft = not self.rotationMaxaleft;
	end;
	if isDown and sym == Input.KEY_KP_6 then 
		self.rotationMaxright = not self.rotationMaxright;
		self.rotationMaxaright = not self.rotationMaxaright;
	end;
	if isDown and sym == Input.KEY_KP_7 then 
		self.rotationMaxleft2 = not self.rotationMaxleft2;
		self.rotationMaxaleft2 = not self.rotationMaxaleft2;
	end;
	if isDown and sym == Input.KEY_KP_9 then 
		self.rotationMaxright2 = not self.rotationMaxright2;
		self.rotationMaxaright2 = not self.rotationMaxaright2;
	end;
	if isDown and sym == Input.KEY_KP_5 then 
		self.rotationMaxcenter = not self.rotationMaxcenter;
		self.rotationMaxacenter = not self.rotationMaxacenter;
	end;
	if isDown and sym == Input.KEY_KP_8 then 
		self.rotationMaxback = not self.rotationMaxback;
		self.rotationMaxaback = not self.rotationMaxaback;
	end;
	if isDown and sym == Input.KEY_KP_0 then
		self.helpPanel = not self.helpPanel;
	end;
end;
 
function UAZ:update(dt)

-- door
	if self.rotationPartleft ~= nil then
		local x, y, z = getRotation(self.rotationPartleft.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleft.maxRot, self.rotationPartleft.minRot, 3, self.rotationPartleft.rotTime, dt, not self.rotationMaxleft);
		setRotation(self.rotationPartleft.node, unpack(newRot));
	end;

	if self.rotationPartright ~= nil then
		local x, y, z = getRotation(self.rotationPartright.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartright.maxRot, self.rotationPartright.minRot, 3, self.rotationPartright.rotTime, dt, not self.rotationMaxright);
		setRotation(self.rotationPartright.node, unpack(newRot));
   end;

	if self.rotationPartleft2 ~= nil then
		local x, y, z = getRotation(self.rotationPartleft2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleft2.maxRot, self.rotationPartleft2.minRot, 3, self.rotationPartleft2.rotTime, dt, not self.rotationMaxleft2);
		setRotation(self.rotationPartleft2.node, unpack(newRot));
	end;

	if self.rotationPartright2 ~= nil then
		local x, y, z = getRotation(self.rotationPartright2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartright2.maxRot, self.rotationPartright2.minRot, 3, self.rotationPartright2.rotTime, dt, not self.rotationMaxright2);
		setRotation(self.rotationPartright2.node, unpack(newRot));
   end;

	if self.rotationPartcenter  ~= nil then
		local x, y, z = getRotation(self.rotationPartcenter .node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartcenter.maxRot, self.rotationPartcenter.minRot, 3, self.rotationPartcenter.rotTime, dt, not self.rotationMaxcenter);
		setRotation(self.rotationPartcenter .node, unpack(newRot));
	end;

	if self.rotationPartback  ~= nil then
		local x, y, z = getRotation(self.rotationPartback .node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartback.maxRot, self.rotationPartback.minRot, 3, self.rotationPartback.rotTime, dt, not self.rotationMaxback);
		setRotation(self.rotationPartback .node, unpack(newRot));
	end;

--other to motor started

if self.isMotorStarted then
self.rotationMaxvoda1 = true;
self.rotationMaxvoda2 = false;
self.rotationMaxvoda3 = true;
self.rotationMaxvoda4 = false;
self.rotationMaxvoda5 = true;
self.rotationMaxvoda6 = false;
         else
self.rotationMaxvoda1 = false;
self.rotationMaxvoda2 = true;
self.rotationMaxvoda3 = false;
self.rotationMaxvoda4 = true;
self.rotationMaxvoda5 = false;
self.rotationMaxvoda6 = true;
              end;

-- tahometr

local maxtahometr = 5500;
	if self.rotationParttahometr ~= nil then
		local x, y, z = getRotation(self.rotationParttahometr.node);
		y = ((self.rotationParttahometr.maxRot[2] - self.rotationParttahometr.minRot[2]) / maxtahometr) * self.motor.lastMotorRpm + self.rotationParttahometr.minRot[2];
		setRotation(self.rotationParttahometr.node, x, y ,z);
	end;

-- spidometr

local maxKmh = 80;
	if self.rotationPartKmh1 ~= nil then
		local x, y, z = getRotation(self.rotationPartKmh1.node);
		y = ((self.rotationPartKmh1.maxRot[2] - self.rotationPartKmh1.minRot[2]) / maxKmh) * self.lastSpeed*3600 + self.rotationPartKmh1.minRot[2];
		setRotation(self.rotationPartKmh1.node, x, y ,z);
	end;

-- toplivo

if self.rotationPartTanknadel ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel.node);
		y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
		setRotation(self.rotationPartTanknadel.node, x, y ,z);
	end;

	if self.isEntered then
		if self.fuelFillLevel < 5 then
			self.riserva = self.riserva - dt;
			if self.playedSound == false then
				playSample(self.fuelwarningSoundId,1,1,0);
				self.playedSound = true;
			end;
			self.ledriservaActive = true;
		else
			self.playedSound = false;
			self.ledriservaActive = false;
		    end;
		     setVisibility(self.ledriserva, self.ledriservaActive);
       end;

-- voda

if self.rotationMaxvoda1 == true then
if self.rotationPartvoda1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda1.maxRot, self.rotationPartvoda1.minRot, 3, self.rotationPartvoda1.rotTime, dt, not self.rotationMaxvoda1);
		   setRotation(self.rotationPartvoda1.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda2 == true then
if self.rotationPartvoda2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda2.maxRot, self.rotationPartvoda2.minRot, 3, self.rotationPartvoda2.rotTime, dt, not self.rotationMaxvoda2);
		   setRotation(self.rotationPartvoda2.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda3 == true then
if self.rotationPartvoda3 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda3.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda3.maxRot, self.rotationPartvoda3.minRot, 3, self.rotationPartvoda3.rotTime, dt, not self.rotationMaxvoda3);
		   setRotation(self.rotationPartvoda3.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda4 == true then
if self.rotationPartvoda4 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda4.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda4.maxRot, self.rotationPartvoda4.minRot, 3, self.rotationPartvoda4.rotTime, dt, not self.rotationMaxvoda4);
		   setRotation(self.rotationPartvoda4.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda5 == true then
if self.rotationPartvoda5 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda5.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda5.maxRot, self.rotationPartvoda5.minRot, 3, self.rotationPartvoda5.rotTime, dt, not self.rotationMaxvoda5);
		   setRotation(self.rotationPartvoda5.node, unpack(newRot));
       end;
   end;
if self.rotationMaxvoda6 == true then
if self.rotationPartvoda6 ~= nil then
		   local x, y, z = getRotation(self.rotationPartvoda6.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartvoda6.maxRot, self.rotationPartvoda6.minRot, 3, self.rotationPartvoda6.rotTime, dt, not self.rotationMaxvoda6);
		   setRotation(self.rotationPartvoda6.node, unpack(newRot));
       end;
   end;
end;

function UAZ:onLeave()
end;

function UAZ:draw()

	if not self.helpPanel then
			renderText(0.8335, 0.17, 0.02, g_i18n:getText("Info_ON"));
		else
			renderText(0.8335, 0.17, 0.02, g_i18n:getText("Info_OFF"));
		end;
		if self.helpPanel then
			renderText(0.72, 0.88, 0.025, g_i18n:getText("Info_avto"));
			renderText(0.72, 0.84, 0.02, g_i18n:getText("Motor"));
			renderText(0.72, 0.82, 0.02, g_i18n:getText("Lev_povorot"));
			renderText(0.72, 0.80, 0.02, g_i18n:getText("Avarijka"));
			renderText(0.72, 0.78, 0.02, g_i18n:getText("Prav_povorot"));
			renderText(0.72, 0.76, 0.02, g_i18n:getText("Lev_dver"));
			renderText(0.72, 0.74, 0.02, g_i18n:getText("Prav_dver"));
			renderText(0.72, 0.72, 0.02, g_i18n:getText("Lev_zad_dver"));
			renderText(0.72, 0.70, 0.02, g_i18n:getText("Prav_zad_dver"));
			renderText(0.72, 0.68, 0.02, g_i18n:getText("Kapot"));
			renderText(0.72, 0.66, 0.02, g_i18n:getText("Zad"));
			renderText(0.72, 0.64, 0.02, g_i18n:getText("KabinLight"));
			renderText(0.72, 0.60, 0.02, g_i18n:getText("Camera"));
			renderText(0.72, 0.58, 0.02, g_i18n:getText("MOVECAMRIGHT2"));
			renderText(0.72, 0.56, 0.02, g_i18n:getText("MOVECAMLEFT2"));
			renderText(0.72, 0.54, 0.02, g_i18n:getText("MOVECAMFORWARD2"));
			renderText(0.72, 0.52, 0.02, g_i18n:getText("MOVECAMBACK2"));
			renderText(0.72, 0.50, 0.02, g_i18n:getText("WHEEL_UP"));
			renderText(0.72, 0.48, 0.02, g_i18n:getText("WHEEL_DOWN"));
			renderText(0.72, 0.46, 0.02, g_i18n:getText("MIDDLE"));
	end;	
end;
