--#####################################################################--
-- c450 cutter														   --
--#####################################################################--
-- @Idee	Marc85													   --
--#####################################################################--
-- @author 	BlackyBPG						www.blackpanthergroup.de   --
--																	   --
-- @date  09/10/2013 (dd/mm/yyyy)									   --
--																	   --
-- Hinweis: Editieren nur nach vorheriger absprache des Authors		   --
--#####################################################################--

c450 = {};

function c450.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations) and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function c450:load(xmlFile)
	
	self.c450 = {};
	
	self.knifeNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.knife#index"));
	self.knifeSpeed = math.min(Utils.getNoNil(getXMLInt(xmlFile, "vehicle.knife#speed"), 10), 1000);
	local accFactor = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.knife#accelerationFactor"),200);
	self.knifeSpeedFactor = self.knifeSpeed / accFactor;
	self.knifeTransMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.knife#transMax"), 0.1);
	self.knifeTransSteps = self.knifeTransMax / ( 1000 / self.knifeSpeed);
	self.knifeWasOn = false;
	self.knifeSpeedLevel = 0;
	self.knifePos = {};
	self.knifePos.x = nil;
	self.knifePos.y = nil;
	self.knifePos.z = nil;
	self.knifeDir = 1;
	self.knifePos.Current = nil;

	self.cutterSidearm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cutterSidearm#index"));
	self.cutterSidearmOff = getXMLFloat(xmlFile, "vehicle.cutterSidearm#offRot");
	self.cutterSidearmRape = getXMLFloat(xmlFile, "vehicle.cutterSidearm#rapeRot");
	self.cutterSidearmWheat = getXMLFloat(xmlFile, "vehicle.cutterSidearm#wheatRot");
	self.cutterSidearmRot = self.cutterSidearmOff;
	self.cutterSidearmMid = (self.cutterSidearmRape + self.cutterSidearmWheat) / 2;

	self.c450.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cutterRotate#speed"), 10);
	self.c450.speedScale = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cutterRotate#speedScale"), 4500);
	self.c450.speedScaleBackup = self.reelSpeedScale;
	self.c450.rollSpeedBackup = self.rollNodes[1].speed;

	self.reelSpeedScale = 0;
	for _, rollNode in pairs(self.rollNodes) do
		rollNode.speed = 0;
	end;

	self.drumms = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.drumms.drumm(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local index = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"),0.003);
		local accfactor = Utils.getNoNil(getXMLFloat(xmlFile, key.."#accelerationFactor"),300);
		local factor = speed / accfactor;
		if index ~= nil then
			table.insert(self.drumms, {index=index,speed=speed,speedLevel=0,speedFactor=factor,wasOn=false});
		end;
		i = i + 1;
	end;
end;

function c450:delete()
end;

function c450:readStream(streamId, connection)
end;

function c450:writeStream(streamId, connection)
end;

function c450:mouseEvent(posX, posY, isDown, isUp, button)
end;

function c450:keyEvent(unicode, sym, modifier, isDown)
end;

function c450:update(dt)
	if self:getIsActive() then
		if self.knifePos.x == nil and self.knifeNode ~= nil then
			self.knifePos.x,self.knifePos.y,self.knifePos.z = getTranslation(self.knifeNode);
			self.knifePos.Current = self.knifePos.x;
			self.knifeTransMax = self.knifeTransMax + self.knifePos.x;
		end;
	end;
	if self.reelStarted then
		if self.attacherVehicle ~= nil and self.attacherVehicle.allowsThreshing ~= nil then
			if not self.attacherVehicle.allowsThreshing then
				self.lastAreaBiggerZero = false;
				if self.lastAreaBiggerZero ~= self.lastAreaBiggerZeroSent then
					self:raiseDirtyFlags(self.cutterGroundFlag);
					self.lastAreaBiggerZeroSent = self.lastAreaBiggerZero;
				end;
			end;
		end;
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.c450.speed, 1.3));
		local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.c450.speedScaleBackup * percent}, {0}, 1, self.c450.speedScale, dt, false);
		self.reelSpeedScale = speedScale[1];
		for _, rollNode in pairs(self.rollNodes) do
			local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.c450.rollSpeedBackup * percent}, {0}, 1, self.c450.speedScale, dt, false);
			rollNode.speed = rollSpeed[1];
		end;
		if self.knifeNode ~= nil and self.knifePos.x ~= nil then
			if self.knifeSpeedLevel < self.knifeSpeed then
				self.knifeSpeedLevel = self.knifeSpeedLevel + self.knifeSpeedFactor;
			end;
			self.knifeWasOn = true;
			local knifePos = self.knifePos.x;
			if self.knifeDir == 1 then
				knifePos = self.knifePos.Current + (self.knifeTransSteps * (self.knifeSpeedLevel / self.knifeSpeed));
				if knifePos > self.knifeTransMax then
					self.knifeDir = 2;
					knifePos = self.knifePos.Current - (self.knifeTransSteps * (self.knifeSpeedLevel / self.knifeSpeed));
				end;
			elseif self.knifeDir == 2 then
				knifePos = self.knifePos.Current - (self.knifeTransSteps * (self.knifeSpeedLevel / self.knifeSpeed));
				if knifePos < self.knifePos.x then
					self.knifeDir = 1;
					knifePos = self.knifePos.Current + (self.knifeTransSteps * (self.knifeSpeedLevel / self.knifeSpeed));
				end;
			end;
			setTranslation(self.knifeNode, knifePos, self.knifePos.y, self.knifePos.z);
			self.knifePos.Current = knifePos;
		end;
		for _,v in pairs(self.drumms) do
			if v.speedLevel < v.speed then
				v.speedLevel = v.speedLevel + v.speedFactor;
			end;
			v.wasOn = true;
			if v.index ~= nil then
				rotate(v.index,v.speedLevel*dt,0,0)
			end;
		end;
		if self.cutterSidearm ~= nil then
			if self.currentInputFruitType == FruitUtil.FRUITTYPE_RAPE then
				if self.cutterSidearmRot > (self.cutterSidearmRape + 0.25) then
					self.cutterSidearmRot = self.cutterSidearmRot - 0.2;
				elseif self.cutterSidearmRot < (self.cutterSidearmRape - 0.25) then
					self.cutterSidearmRot = self.cutterSidearmRot + 0.2;
				end;
			elseif self.currentInputFruitType == FruitUtil.FRUITTYPE_WHEAT or self.currentInputFruitType == FruitUtil.FRUITTYPE_BARLEY or self.currentInputFruitType == FruitUtil.FRUITTYPE_DINKEL or self.currentInputFruitType == FruitUtil.FRUITTYPE_SPELT or self.currentInputFruitType == FruitUtil.FRUITTYPE_OAT or self.currentInputFruitType == FruitUtil.FRUITTYPE_MOHN or self.currentInputFruitType == FruitUtil.FRUITTYPE_RYE or self.currentInputFruitType == FruitUtil.FRUITTYPE_SOYBEAN or self.currentInputFruitType == FruitUtil.FRUITTYPE_MILLET then
				if self.cutterSidearmRot > (self.cutterSidearmWheat + 0.25) then
					self.cutterSidearmRot = self.cutterSidearmRot - 0.2;
				elseif self.cutterSidearmRot < (self.cutterSidearmWheat - 0.25) then
					self.cutterSidearmRot = self.cutterSidearmRot + 0.2;
				end;
			else
				if self.cutterSidearmRot > (self.cutterSidearmMid + 0.25) then
					self.cutterSidearmRot = self.cutterSidearmRot - 0.2;
				elseif self.cutterSidearmRot < (self.cutterSidearmMid - 0.25) then
					self.cutterSidearmRot = self.cutterSidearmRot + 0.2;
				end;
			end;
			setRotation(self.cutterSidearm,Utils.degToRad(self.cutterSidearmRot),0,0);
		end;
	else
		if self.reelSpeedScale ~= 0 or self.rollNodes[1].speed ~= 0 then
			local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.c450.speed, 1.5));
			local speedScale = Utils.getMovedLimitedValues({self.reelSpeedScale}, {self.c450.speedScaleBackup * percent}, {0}, 1, self.c450.speedScale*1.5, dt, true);
			self.reelSpeedScale = speedScale[1];
			rotate(self.reelNode, -dt*self.reelSpeed*self.reelSpeedScale, 0, 0);
			for _, rollNode in pairs(self.rollNodes) do
				local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {self.c450.rollSpeedBackup * percent}, {0}, 1, self.c450.speedScale*1.5, dt, true);
				rollNode.speed = rollSpeed[1];
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
			local atx, aty, atz = getRotation(self.reelNode);
			for i=1, self.spikesCount do
				local spike = getChildAt(self.spikesRootNode, i-1);
				setRotation(spike, -atx, aty, atz);
			end;
		end;
		if self.knifeNode ~= nil and self.knifePos.x ~= nil and self.knifeWasOn then
			if self.knifeSpeedLevel > 0 then
				self.knifeSpeedLevel = self.knifeSpeedLevel - self.knifeSpeedFactor;
			end;
			local knifePos = self.knifePos.x;
			if self.knifeDir == 1 then
				knifePos = self.knifePos.Current + (self.knifeTransSteps * (self.knifeSpeedLevel / self.knifeSpeed));
				if knifePos > self.knifeTransMax then
					self.knifeDir = 2;
					knifePos = self.knifePos.Current - (self.knifeTransSteps * (self.knifeSpeedLevel / self.knifeSpeed));
				end;
			elseif self.knifeDir == 2 then
				knifePos = self.knifePos.Current - (self.knifeTransSteps * (self.knifeSpeedLevel / self.knifeSpeed));
				if knifePos < self.knifePos.x then
					self.knifeDir = 1;
					knifePos = self.knifePos.Current + (self.knifeTransSteps * (self.knifeSpeedLevel / self.knifeSpeed));
				end;
			end;
			setTranslation(self.knifeNode, knifePos, self.knifePos.y, self.knifePos.z);
			self.knifePos.Current = knifePos;
			if self.knifeSpeedLevel <= 0 then
				self.knifeWasOn = false;
			end;
		end;
		for _,v in pairs(self.drumms) do
			if v.wasOn then
				if v.speedLevel > v.speedFactor then
					v.speedLevel = v.speedLevel - v.speedFactor;
				else
					v.wasOn = false;
				end;
				if v.index ~= nil then
					rotate(v.index,v.speedLevel*dt,0,0)
				end;
			end;
		end;
		if self.cutterSidearm ~= nil then
			if self.cutterSidearmRot < self.cutterSidearmOff then
				self.cutterSidearmRot = self.cutterSidearmRot + 0.2;
			end;
			setRotation(self.cutterSidearm,Utils.degToRad(self.cutterSidearmRot),0,0);
		end;
	end;
end;

function c450:updateTick(dt)
	
end;

function c450:draw()	
end;

function c450:onAttach(attacherVehicle)
	
end;

function c450:onDetach()
	Cutter.updateExtraObjects(self);
end;

