--
-- Wipers
-- Specialization for Wipers
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		15/11/11
-- @history:	v1.0 - Initial version
--				
--

Wipers = {};

function Wipers.prerequisitesPresent(specializations)
	return true;
end;

function Wipers:load(xmlFile)
	
	self.isSelectable = true;

    local wiperAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper#rootNode"));
    self.wiperAnimCharSet = 0;
    if wiperAnimRootNode ~= nil and wiperAnimRootNode ~= 0 then
        self.wiperAnimCharSet = getAnimCharacterSet(wiperAnimRootNode);
        if self.wiperAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperAnimCharSet, getXMLString(xmlFile, "vehicle.wiper#clip"));
            assignAnimTrackClip(self.wiperAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperAnimCharSet, 0, true);
            local wiperAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiper#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperAnimCharSet, 0, wiperAnimSpeedScale);
            self.wiperAnimDuration = getAnimClipDuration(self.wiperAnimCharSet, clip);
        end;
    end;
	self.isWiperActive = false;
	self.finishWiper = true;
end;

function Wipers:delete()
end;

function Wipers:readStream(streamId, connection)
end;

function Wipers:writeStream(streamId, connection)
end;

function Wipers:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Wipers:keyEvent(unicode, sym, modifier, isDown)
end;

function Wipers:update(dt)
end;

function Wipers:updateTick(dt)

	if self:getIsActive() then

		if not self.finishWiper then
			if getAnimTrackTime(self.wiperAnimCharSet, 0) % self.wiperAnimDuration <= 100 then
				setAnimTrackTime(self.wiperAnimCharSet, 0, 0.0);
				disableAnimTrack(self.wiperAnimCharSet, 0);			
				self.finishWiper = true;
			end;			
		end;
		
		if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			if not self.isWiperActive then
				enableAnimTrack(self.wiperAnimCharSet, 0);
				self.isWiperActive = true;
			end;
		else
			if self.isWiperActive then
				self.isWiperActive = false;
				self.finishWiper = false;
			end;
		end;
			
	end;
end;

function Wipers:draw()	
end;


function Wipers:attachImplement(implement)
end;

function Wipers:detachImplement(implementIndex)
end;

function Wipers:validateAttacherJoint(implement, jointDesc, dt)
end;

function Wipers:onLeave()
	if self.isWiperActive then
		disableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
end;

function Wipers:onEnter()
	if self.isWiperActive then
		enableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
end;