--
-- EnterAnimation
-- Specialization for Enter Animation
--
-- @author  JoXXer
-- @date  21/09/11
--

EnterAnimation = {};

function EnterAnimation.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function EnterAnimation:load(xmlFile)
	-- onEnter Animation
	self.onEnterAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.onEnter#rootNode"));
    self.onEnterAnimCharSet = 0;
    if self.onEnterAnimRootNode ~= nil and self.onEnterAnimRootNode ~= 0 then
        self.onEnterAnimCharSet = getAnimCharacterSet(self.onEnterAnimRootNode);
        if self.onEnterAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.onEnterAnimCharSet, getXMLString(xmlFile, "vehicle.onEnter#clip"));
            assignAnimTrackClip(self.onEnterAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.onEnterAnimCharSet, 0, false);
            local onEnterAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.onEnter#speedScale"), 1);
			setAnimTrackSpeedScale(self.onEnterAnimCharSet, 0, onEnterAnimSpeedScale);
            self.onEnterAnimDuration = getAnimClipDuration(self.onEnterAnimCharSet, clip);
        end;
    end;
	self.onLeaveAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.onLeave#rootNode"));
    self.onLeaveAnimCharSet = 0;
    if self.onLeaveAnimRootNode ~= nil and self.onLeaveAnimRootNode ~= 0 then
        self.onLeaveAnimCharSet = getAnimCharacterSet(self.onLeaveAnimRootNode);
        if self.onLeaveAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.onLeaveAnimCharSet, getXMLString(xmlFile, "vehicle.onLeave#clip"));
            assignAnimTrackClip(self.onLeaveAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.onLeaveAnimCharSet, 0, false);
            local onLeaveAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.onLeave#speedScale"), 1);
			setAnimTrackSpeedScale(self.onLeaveAnimCharSet, 0, onLeaveAnimSpeedScale);
            self.onLeaveAnimDuration = getAnimClipDuration(self.onLeaveAnimCharSet, clip);
        end;
    end;
	self.onEnterLeaveCharacter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.characterNode#visibilityNode"));

	--VARIABLEs
	self.hasPlayedOnEnter = true;
	self.hasPlayedOnLeave = true;
	self.hasEntered = false;
end;

function EnterAnimation:delete()
end;

function EnterAnimation:readStream(streamId, connection)

end;

function EnterAnimation:writeStream(streamId, connection)

end;

function EnterAnimation:readUpdateStream(streamId, timestamp, connection)

end;

function EnterAnimation:writeUpdateStream(streamId, connection, dirtyMask)

end;

function EnterAnimation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function EnterAnimation:keyEvent(unicode, sym, modifier, isDown)
end;

function EnterAnimation:update(dt)
	if self.hasPlayedOnEnter == false then
		if self.onEnterAnimCharSet ~= 0 then
			if getAnimTrackTime(self.onEnterAnimCharSet, 0) < 0.0 then
				setAnimTrackTime(self.onEnterAnimCharSet, 0, 0.0);
			end;
			setAnimTrackSpeedScale(self.onEnterAnimCharSet, 0, 1);
			enableAnimTrack(self.onEnterAnimCharSet, 0);
		end;

		if getAnimTrackTime(self.onEnterAnimCharSet, 0) > self.onEnterAnimDuration then
			self.hasEntered = true;
		end;

		if self.hasEntered then
			self.hasPlayedOnEnter = true;
			setVisibility(self.onEnterLeaveCharacter,true);
		end;
	end;
end;

function EnterAnimation:updateTick(dt)
end;

function EnterAnimation:draw()
end;

function EnterAnimation:onLeave()
	self.hasPlayedOnEnter = true;
	disableAnimTrack(self.onEnterAnimCharSet, 0);
	setAnimTrackTime(self.onEnterAnimCharSet, 0, 0.0);
	--setTranslation(self.onEnterAnimRootNode, 1.95421, 1.04051, 1.9);
	--setRotation(self.onEnterAnimRootNode, math.rad(180), math.rad(-80), math.rad(180));
	self.hasPlayedonLeave = false;
end;

function EnterAnimation:onEnter()
	self.hasPlayedOnEnter = false;
	setVisibility(self.onEnterLeaveCharacter,false);
	self.hasPlayedonLeave = true;
end;
