--#####################################################################--
-- dominator85
--#####################################################################--
-- @Idee	Marc85
--#####################################################################--
-- @author 	BlackyBPG						www.blackpanthergroup.de
-- @author 	Alex2009 /WorksoundRPM Function	www.Alex2009.de
-- @date  09/10/2013 (dd/mm/yyyy)
-- Hinweis: Editieren nur nach vorheriger absprache beider Authoren
-- Hinweis: Das kopieren von Sourcecode ist strafbar nach UrhG 2.1
--#####################################################################--
dominator85 = {};

function dominator85.prerequisitesPresent(specializations)
    return true;
end;
function dominator85:load(xmlFile)
	self.normalMinRPM = self.motor.minRpm;
	self.workMinRPM = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#minRpmWork"), 1500);
	self.normalMaxPitch = self.motorSoundPitchOffset;
	self.workMaxPitch = ((self.motorSoundPitchMax - self.motorSoundPitchOffset) / 2) + self.motorSoundPitchOffset;

	self.drumms = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.drumms.drumm(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local index = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"),0.003);
		local accfactor = Utils.getNoNil(getXMLFloat(xmlFile, key.."#accelerationFactor"),300);
		local selfVar = getXMLString(xmlFile, key.."#selfVar");
		local factor = speed / accfactor;
		if index ~= nil then
			table.insert(self.drumms, {index=index,speed=speed,speedLevel=0,speedFactor=factor,wasOn=false,selfVar=selfVar});
		end;
		i = i + 1;
	end;

	self.getIsPipeUnloadingAllowed = Utils.overwrittenFunction(self.getIsPipeUnloadingAllowed, dominator85.getIsPipeUnloadingAllowed);
end;

function dominator85:delete()
end;
function dominator85:mouseEvent(posX, posY, isDown, isUp, button)
end;

function dominator85:keyEvent(unicode, sym, modifier, isDown)
end;

function dominator85:update(dt)
	if self.isThreshing then
		if self.motor.minRpm ~= self.workMinRPM then
			self.motor.minRpm = self.workMinRPM;
		end;
		if self.motorSoundPitchOffset ~= self.workMaxPitch then
			self.motorSoundPitchOffset = self.workMaxPitch;
			setSamplePitch(self.motorSound, self.workMaxPitch);
		end;
		for _,v in pairs(self.drumms) do
			local isActive = true;
			if v.selfVar ~= nil then
				if v.selfVar == "straw" then
					if self.strawActive then
						isActive = false;
					end;
				elseif v.selfVar == "unloading" then
					if not self.pipeIsUnloading then
						isActive = false;
					end;
				end;
			end;
			if isActive then
				if v.speedLevel < v.speed then
					v.speedLevel = v.speedLevel + v.speedFactor;
				end;
				v.wasOn = true;
				if v.index ~= nil then
					rotate(v.index,v.speedLevel*dt,0,0)
				end;
			else
				if v.wasOn then
					if v.speedLevel > v.speedFactor then
						v.speedLevel = v.speedLevel - v.speedFactor;
					else
						v.wasOn = false;
					end;
					if v.index ~= nil then
						rotate(v.index,v.speedLevel*dt,0,0)
					end;
				end;
			end;
		end;
	elseif self.pipeIsUnloading then
		if self.motor.minRpm ~= self.workMinRPM then
			self.motor.minRpm = self.workMinRPM;
		end;
		if self.motorSoundPitchOffset ~= self.workMaxPitch then
			self.motorSoundPitchOffset = self.workMaxPitch;
			setSamplePitch(self.motorSound, self.workMaxPitch);
		end;
		for _,v in pairs(self.drumms) do
			if v.selfVar == "unloading" then
				local isActive = true;
				if v.selfVar ~= nil then
					if not self.pipeIsUnloading then
						isActive = false;
					end;
				end;
				if isActive then
					if v.speedLevel < v.speed then
						v.speedLevel = v.speedLevel + v.speedFactor;
					end;
					v.wasOn = true;
					if v.index ~= nil then
						rotate(v.index,v.speedLevel*dt,0,0)
					end;
				else
					if v.wasOn then
						if v.speedLevel > v.speedFactor then
							v.speedLevel = v.speedLevel - v.speedFactor;
						else
							v.wasOn = false;
						end;
						if v.index ~= nil then
							rotate(v.index,v.speedLevel*dt,0,0)
						end;
					end;
				end;
			end;
		end;
	else
		if self.motor.minRpm ~= self.normalMinRPM then
			self.motor.minRpm = self.normalMinRPM;
		end;
		if self.motorSoundPitchOffset ~= self.normalMaxPitch then
			self.motorSoundPitchOffset = self.normalMaxPitch;
			setSamplePitch(self.motorSound, self.normalMaxPitch);
		end;
		for _,v in pairs(self.drumms) do
			if v.wasOn then
				if v.speedLevel > v.speedFactor then
					v.speedLevel = v.speedLevel - v.speedFactor;
				else
					v.wasOn = false;
				end;
				if v.index ~= nil then
					rotate(v.index,v.speedLevel*dt,0,0)
				end;
			end;
		end;
	end;
end;

function dominator85:updateTick(dt)
end;

function dominator85:onLeave()
end;

function dominator85:draw()
end;

function dominator85:getIsPipeUnloadingAllowed()
	if self.foldAnimTime ~= nil and (self.foldAnimTime > self.pipeFoldMaxLimit or self.foldAnimTime < self.pipeFoldMinLimit) then
		return false;
	end;
	if not self.isMotorStarted then
		return false;
	end;
	return true;
end;
