SetGrainFlapsEvent = {};
SetGrainFlapsEvent_mt = Class(SetGrainFlapsEvent, Event);

InitEventClass(SetGrainFlapsEvent, "SetGrainFlapsEvent");

function SetGrainFlapsEvent:emptyNew()
    local self = Event:new(SetGrainFlapsEvent_mt);
    self.className="SetGrainFlapsEvent";
    return self;
end;

function SetGrainFlapsEvent:new(vehicle, grainFlapsState)
    local self = SetGrainFlapsEvent:emptyNew()
    self.vehicle = vehicle;
	self.grainFlapsState = grainFlapsState;
    return self;
end;

function SetGrainFlapsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.grainFlapsState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetGrainFlapsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.grainFlapsState);
end;

function SetGrainFlapsEvent:run(connection)
	self.vehicle:setGrainFlaps(self.grainFlapsState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetGrainFlapsEvent:new(self.vehicle, self.grainFlapsState), nil, connection, self.vehicle);
    end;
end;

function SetGrainFlapsEvent.sendEvent(vehicle, grainFlapsState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetGrainFlapsEvent:new(vehicle, grainFlapsState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetGrainFlapsEvent:new(vehicle, grainFlapsState));
		end;
	end;
end;