NHTC5070Cutter = {};

function NHTC5070Cutter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function NHTC5070Cutter:load(xmlFile)
	self.threshingParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.threshingParticleSystems.threshingParticleSystem(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end;
		local isStatic = Utils.getNoNil(getXMLBool(xmlFile, namei.."#static"), false);
		if isStatic then
			StaticParticleSystem.loadParticleSystem(xmlFile, self.threshingParticleSystems, namei, nodei, false, nil, self.baseDirectory);
		else
			Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems, namei, nodei, false, nil, self.baseDirectory);
		end;
		Utils.setEmittingState(self.threshingParticleSystems,false);
		i = i +1;		
    end;
end;

function NHTC5070Cutter:delete()
end;

function NHTC5070Cutter:readStream(streamId, connection)
end;

function NHTC5070Cutter:writeStream(streamId, connection)
end;

function NHTC5070Cutter:readUpdateStream(streamId, timestamp, connection)
end;

function NHTC5070Cutter:writeUpdateStream(streamId, connection, dirtyMask)
end;

function NHTC5070Cutter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NHTC5070Cutter:keyEvent(unicode, sym, modifier, isDown)
end;

function NHTC5070Cutter:update(dt)
    if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.NHTC5070Cutter_ReelUp) and self:getIsActiveForInput() then
			self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet+dt), false);
		elseif InputBinding.isPressed(InputBinding.NHTC5070Cutter_ReelDown) and self:getIsActiveForInput() then
			self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet+dt), false);
		end;
		if InputBinding.isPressed(InputBinding.NHTC5070Cutter_ReelBack) and self:getIsActiveForInput() then
			self:setAnimationTime(2, self.animationParts[2].currentPosition+(self.animationParts[2].offSet+dt), false);
		elseif InputBinding.isPressed(InputBinding.NHTC5070Cutter_ReelFront) and self:getIsActiveForInput() then
			self:setAnimationTime(2, self.animationParts[2].currentPosition-(self.animationParts[2].offSet+dt), false);
		end;
    end;
end;

function NHTC5070Cutter:updateTick(dt)
end;

function NHTC5070Cutter:draw()
	--g_currentMission:addExtraPrintText(string.format(""..InputBinding.getKeyNamesOfDigitalAction(InputBinding.NHTC5070Cutter_ReelUp) .. " / " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.NHTC5070Cutter_ReelDown)..":      "..g_i18n:getText("NHTC5070Cutter_ReelUpDown")..""));
	--g_currentMission:addExtraPrintText(string.format(""..InputBinding.getKeyNamesOfDigitalAction(InputBinding.NHTC5070Cutter_ReelFront) .. " / " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.NHTC5070Cutter_ReelBack)..":    "..g_i18n:getText("NHTC5070Cutter_ReelFrontBack")..""));
end;

function NHTC5070Cutter:onDetach()
end;

function NHTC5070Cutter:onLeave()
end;

function NHTC5070Cutter:onDeactivate()
end;