--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.72, 0.30, 0.02, "Taste Numpad 0: Info Anschalten");
	 else
		-- Koordinaten sind aus der F930.lua - Author leider unbekannt
		renderText(0.72, 0.30, 0.02, "Taste Numpad 0: Info Abschalten");
		renderText(0.72, 0.86, 0.025, "- John Deere 6610 Info -");			
		renderText(0.72, 0.83, 0.02, "Taste Pos1: Rundumleuchte ein/aus");
		renderText(0.72, 0.81, 0.02, "IC-Control: Heckscheibe auf/zu");
		renderText(0.72, 0.79, 0.02, "IC-Control: Tuer links auf/zu");			
		renderText(0.72, 0.77, 0.02, "IC-Control: Tuer rechts auf/zu");
		renderText(0.72, 0.75, 0.02, "Taste F: Arbeitslicht Vorne an/aus");
		renderText(0.72, 0.73, 0.02, "Taste 2xF: Arbeitslicht Hinten an/aus");
		renderText(0.72, 0.71, 0.02, "Taste 8: Fronthydraulik auf/einklappen");
		renderText(0.72, 0.69, 0.02, "Taste 9: Reifen wechseln");
		renderText(0.72, 0.67, 0.02, "Taste Numpad 1: Blinker Links");
		renderText(0.72, 0.65, 0.02, "Taste Numpad 2: Warnblinker");
		renderText(0.72, 0.63, 0.02, "Taste Numpad 3: Blinker Rechts");
               renderText(0.72, 0.59, 0.02, "by 6630Powr");
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;




