-- Digital Display Fillamounts
--
-- Author Blackburner
-- 21.11.2010
--
-- > Copyright (C) 2011 by Blackburner
--
-- special thanks to Sven777b
---------------------------------------------
-- edited by PeterJ - euroDZN
-- 18/11/2013
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.

Display = {};

function Display.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Display:load(xmlFile)

	self.displayOff = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.displaySpeed#displayOff"));
	
	-- speed --
	self.speedDisplay = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.displaySpeed#index"));
	self.speedSegmentCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displaySpeed#segmentcount"), 0);
	if self.speedSegmentCount > 0 then
		self.speedNumAtPos = {}
		for i=1, self.speedSegmentCount do
			self.speedNumAtPos[i] = 0;
		end;
	end;
	if self.speedSegmentCount > 0 then
		self.speedSegment = {};	
		for i=1, self.speedSegmentCount do
			local path = string.format("vehicle.displaySpeed.segment%d", i);
			self.speedSegment[i] = {};		
			self.speedSegment[i].a = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#a"));
			self.speedSegment[i].b = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#b"));
			self.speedSegment[i].c = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#c"));
			self.speedSegment[i].d = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#d"));
			self.speedSegment[i].e = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#e"));
			self.speedSegment[i].f = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#f"));
			self.speedSegment[i].g = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#g"));
		end;
	end;
	if self.speedSegmentCount > 0 then
		self.speedDispSeg = {};
		for i=1, self.speedSegmentCount do
			self.speedDispSeg[i] = {};
			self.speedDispSeg[i].a = false;
			self.speedDispSeg[i].b = false;
			self.speedDispSeg[i].c = false;
			self.speedDispSeg[i].d = false;
			self.speedDispSeg[i].e = false;
			self.speedDispSeg[i].f = false;
			self.speedDispSeg[i].g = false;
		end;	
	end;
	self.speedValueMax = ((10^(self.speedSegmentCount))-1);
	self.speedValueMin = 0;
	self.speedValue = 0;
	self.oldSpeedValue = 0;
	
	-- rpm --
	self.rpmDisplay = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.displayRPM#index"));
	self.rpmSegmentCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayRPM#segmentcount"), 0);
	if self.rpmSegmentCount > 0 then
		self.rpmNumAtPos = {}
		for i=1, self.rpmSegmentCount do
			self.rpmNumAtPos[i] = 0;
		end;
	end;
	if self.rpmSegmentCount > 0 then
		self.rpmSegment = {};	
		for i=1, self.rpmSegmentCount do
			local path = string.format("vehicle.displayRPM.segment%d", i);
			self.rpmSegment[i] = {};		
			self.rpmSegment[i].a = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#a"));
			self.rpmSegment[i].b = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#b"));
			self.rpmSegment[i].c = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#c"));
			self.rpmSegment[i].d = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#d"));
			self.rpmSegment[i].e = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#e"));
			self.rpmSegment[i].f = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#f"));
			self.rpmSegment[i].g = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#g"));
		end;
	end;
	if self.rpmSegmentCount > 0 then
		self.rpmDispSeg = {};
		for i=1, self.rpmSegmentCount do
			self.rpmDispSeg[i] = {};
			self.rpmDispSeg[i].a = false;
			self.rpmDispSeg[i].b = false;
			self.rpmDispSeg[i].c = false;
			self.rpmDispSeg[i].d = false;
			self.rpmDispSeg[i].e = false;
			self.rpmDispSeg[i].f = false;
			self.rpmDispSeg[i].g = false;
		end;	
	end;
	self.rpmValueMax = ((10^(self.rpmSegmentCount))-1);
	self.rpmValueMin = 0;
	self.rpmValue = 0;
	self.oldRPMValue = 0;
	
	-- oparation hours --
	self.hoursDisplay = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.displayHours#index"));
	self.hoursSegmentCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayHours#segmentcount"), 0);
	if self.hoursSegmentCount > 0 then
		self.hoursNumAtPos = {}
		for i=1, self.hoursSegmentCount do
			self.hoursNumAtPos[i] = 0;
		end;
	end;
	if self.hoursSegmentCount > 0 then
		self.hoursSegment = {};	
		for i=1, self.hoursSegmentCount do
			local path = string.format("vehicle.displayHours.segment%d", i);
			self.hoursSegment[i] = {};		
			self.hoursSegment[i].a = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#a"));
			self.hoursSegment[i].b = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#b"));
			self.hoursSegment[i].c = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#c"));
			self.hoursSegment[i].d = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#d"));
			self.hoursSegment[i].e = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#e"));
			self.hoursSegment[i].f = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#f"));
			self.hoursSegment[i].g = Utils.indexToObject(self.components, getXMLString(xmlFile, path .. "#g"));
		end;
	end;
	if self.hoursSegmentCount > 0 then
		self.hoursDispSeg = {};
		for i=1, self.hoursSegmentCount do
			self.hoursDispSeg[i] = {};
			self.hoursDispSeg[i].a = false;
			self.hoursDispSeg[i].b = false;
			self.hoursDispSeg[i].c = false;
			self.hoursDispSeg[i].d = false;
			self.hoursDispSeg[i].e = false;
			self.hoursDispSeg[i].f = false;
			self.hoursDispSeg[i].g = false;
		end;	
	end;
	self.hoursValueMax = ((10^(self.hoursSegmentCount))-1);
	self.hoursValueMin = 0;
	self.hoursValue = 0;
	self.oldHoursValue = 0;
	
	self.run = true;
	self.converted = false;
	self.firstrun = true;
	self.firstRunSpeed = false;
	self.firstRunRPM = false;
	self.firstRunHours = false;
end;

function Display:delete()
end;

function Display:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Display:keyEvent(unicode, sym, modifier, isDown)
end;

function Display:update(dt)
	--DURAL : no need to update the display every frame (in IRL tractor, numeric speed display is updated every second for example)
end;
 	
function Display:updateTick(dt)

	if self.isActive then

		setVisibility(self.speedDisplay, self.isMotorStarted);
		setVisibility(self.rpmDisplay, self.isMotorStarted);
		setVisibility(self.hoursDisplay, self.isMotorStarted);
		setVisibility(self.displayOff, not self.isMotorStarted);
		self.speedUnit = 1;
		if self:getAnimationTime("speedMode") > 0.001 then
			self.speedUnit = 0.62;
		end;
		
		if self.isMotorStarted then
			self.speedValue = math.floor((self.lastSpeed*3600)*self.speedUnit);
			
			--DURAL : mr value
			--self.rpmValue = self.motor.lastMotorRpm + 400;		
			if self.realManualGearSet then
				self.rpmValue = RealisticUtils.linearFx(self.realSoundEngineRevFx, 850, 2100);
			else				
				local engineRpmFx = 0.9*self.realSoundMotorFx;
				if self.realSoundSpdFx>1.05 then
					--engine braking power => high rpm
					engineRpmFx = math.max(engineRpmFx, self.realSoundSpdFx);
				elseif self.realSoundMotorFx>1.1 then
					--engine braking power => high rpm
					engineRpmFx = math.max(engineRpmFx, 0.2*self.realSoundSpdFx + self.realSoundMotorFx);
				end;			
				self.rpmValue = RealisticUtils.linearFx(engineRpmFx, 850, 1950);
			end;
			
			--if self.rpmValue > 2100 then
			--	self.rpmValue = 2100;
			--end;
			
			--DURAL : only display hours if the global operating hours mod is active
			self.hoursValue = 0;			
			if self.OperatingHours then
				self.hoursValue = (math.floor((self.OperatingHours.operatingTime / 1000 / 60 / 60)*10) / 10)*10;
			end;
			

			if self.converted or self.firstrun then
				if self.speedValue ~= self.oldSpeedValue then 
					if self.speedValue > self.speedValueMax then
						self.speedValue = self.speedValueMax;
					end; 
					if self.speedValue < self.speedValueMin then
						self.speedValue = self.speedValueMin;
					end;
					self.speedValue = math.ceil(self.speedValue);
				end;
				if (self.speedValue ~= self.oldSpeedValue) or self.firstrun then
					self.speedNumAtPos[1] = math.floor((self.speedValue - (math.floor(self.speedValue/ 10) * 10)) / 1);
					self.speedNumAtPos[2] = math.floor((self.speedValue - (math.floor(self.speedValue/ 100) * 100) - self.speedNumAtPos[1]) / 10);
					self.speedNumAtPos[3] = math.floor((self.speedValue - (math.floor(self.speedValue/ 1000) * 1000) - self.speedNumAtPos[1] - self.speedNumAtPos[2]) / 100);
					self.speedNumAtPos[4] = math.floor((self.speedValue - (math.floor(self.speedValue/ 10000) * 10000) - self.speedNumAtPos[1] - self.speedNumAtPos[2] - self.speedNumAtPos[3]) / 1000);
					self.speedNumAtPos[5] = math.floor((self.speedValue - (math.floor(self.speedValue/ 100000) * 100000) - self.speedNumAtPos[1] - self.speedNumAtPos[2] - self.speedNumAtPos[3] - self.speedNumAtPos[4]) / 10000);
					self.speedNumAtPos[6] = math.floor((self.speedValue - (math.floor(self.speedValue/ 1000000) * 1000000) - self.speedNumAtPos[1] - self.speedNumAtPos[2] - self.speedNumAtPos[3] - self.speedNumAtPos[4] - self.speedNumAtPos[5]) / 100000);
					self.speedNumAtPos[7] = math.floor((self.speedValue - (math.floor(self.speedValue/ 10000000) * 10000000) - self.speedNumAtPos[1] - self.speedNumAtPos[2] - self.speedNumAtPos[3] - self.speedNumAtPos[4] - self.speedNumAtPos[5] - self.speedNumAtPos[6]) / 1000000);
			
					if self.run then
						for i=1, self.speedSegmentCount do
							if self.speedNumAtPos[i] == 0 then
								self.speedDispSeg[i].a = true;	self.speedDispSeg[i].b = true;	self.speedDispSeg[i].c = true;	self.speedDispSeg[i].d = true;	self.speedDispSeg[i].e = true;	self.speedDispSeg[i].f = true;	self.speedDispSeg[i].g = false;
							elseif self.speedNumAtPos[i] == 1 then
								self.speedDispSeg[i].a = false;	self.speedDispSeg[i].b = true;	self.speedDispSeg[i].c = true;	self.speedDispSeg[i].d = false;	self.speedDispSeg[i].e = false;	self.speedDispSeg[i].f = false;	self.speedDispSeg[i].g = false;
							elseif self.speedNumAtPos[i] == 2 then
								self.speedDispSeg[i].a = true;	self.speedDispSeg[i].b = true;	self.speedDispSeg[i].c = false;	self.speedDispSeg[i].d = true;	self.speedDispSeg[i].e = true;	self.speedDispSeg[i].f = false;	self.speedDispSeg[i].g = true;
							elseif self.speedNumAtPos[i] == 3 then
								self.speedDispSeg[i].a = true;	self.speedDispSeg[i].b = true;	self.speedDispSeg[i].c = true;	self.speedDispSeg[i].d = true;	self.speedDispSeg[i].e = false;	self.speedDispSeg[i].f = false;	self.speedDispSeg[i].g = true;
							elseif self.speedNumAtPos[i] == 4 then
								self.speedDispSeg[i].a = false;	self.speedDispSeg[i].b = true;	self.speedDispSeg[i].c = true;	self.speedDispSeg[i].d = false;	self.speedDispSeg[i].e = false;	self.speedDispSeg[i].f = true;	self.speedDispSeg[i].g = true;
							elseif self.speedNumAtPos[i] == 5 then
								self.speedDispSeg[i].a = true;	self.speedDispSeg[i].b = false;	self.speedDispSeg[i].c = true;	self.speedDispSeg[i].d = true;	self.speedDispSeg[i].e = false;	self.speedDispSeg[i].f = true;	self.speedDispSeg[i].g = true;
							elseif self.speedNumAtPos[i] == 6 then
								self.speedDispSeg[i].a = true;	self.speedDispSeg[i].b = false;	self.speedDispSeg[i].c = true;	self.speedDispSeg[i].d = true;	self.speedDispSeg[i].e = true;	self.speedDispSeg[i].f = true;	self.speedDispSeg[i].g = true;
							elseif self.speedNumAtPos[i] == 7 then
								self.speedDispSeg[i].a = true;	self.speedDispSeg[i].b = true;	self.speedDispSeg[i].c = true;	self.speedDispSeg[i].d = false;	self.speedDispSeg[i].e = false;	self.speedDispSeg[i].f = false;	self.speedDispSeg[i].g = false;
							elseif self.speedNumAtPos[i] == 8 then
								self.speedDispSeg[i].a = true;	self.speedDispSeg[i].b = true;	self.speedDispSeg[i].c = true;	self.speedDispSeg[i].d = true;	self.speedDispSeg[i].e = true;	self.speedDispSeg[i].f = true;	self.speedDispSeg[i].g = true;
							elseif self.speedNumAtPos[i] == 9 then
								self.speedDispSeg[i].a = true;	self.speedDispSeg[i].b = true;	self.speedDispSeg[i].c = true;	self.speedDispSeg[i].d = true;	self.speedDispSeg[i].e = false;	self.speedDispSeg[i].f = true;	self.speedDispSeg[i].g = true;
							end;
						end;
					end;
					self.oldSpeedValue = self.speedValue;
					self.converted = false;
					self.firstRunSpeed = true;
				end;
				if self.rpmValue ~= self.oldRPMValue then 
					if self.rpmValue > self.rpmValueMax then
						self.rpmValue = self.rpmValueMax;
					end; 
					if self.rpmValue < self.rpmValueMin then
						self.rpmValue = self.rpmValueMin;
					end;
					self.rpmValue = math.ceil(self.rpmValue);
				end;
				if (self.rpmValue ~= self.oldRPMValue) or self.firstrun then
					self.rpmNumAtPos[1] = math.floor((self.rpmValue - (math.floor(self.rpmValue/ 10) * 10)) / 1);
					self.rpmNumAtPos[2] = math.floor((self.rpmValue - (math.floor(self.rpmValue/ 100) * 100) - self.rpmNumAtPos[1]) / 10);
					self.rpmNumAtPos[3] = math.floor((self.rpmValue - (math.floor(self.rpmValue/ 1000) * 1000) - self.rpmNumAtPos[1] - self.rpmNumAtPos[2]) / 100);
					self.rpmNumAtPos[4] = math.floor((self.rpmValue - (math.floor(self.rpmValue/ 10000) * 10000) - self.rpmNumAtPos[1] - self.rpmNumAtPos[2] - self.rpmNumAtPos[3]) / 1000);
					self.rpmNumAtPos[5] = math.floor((self.rpmValue - (math.floor(self.rpmValue/ 100000) * 100000) - self.rpmNumAtPos[1] - self.rpmNumAtPos[2] - self.rpmNumAtPos[3] - self.rpmNumAtPos[4]) / 10000);
					self.rpmNumAtPos[6] = math.floor((self.rpmValue - (math.floor(self.rpmValue/ 1000000) * 1000000) - self.rpmNumAtPos[1] - self.rpmNumAtPos[2] - self.rpmNumAtPos[3] - self.rpmNumAtPos[4] - self.rpmNumAtPos[5]) / 100000);
					self.rpmNumAtPos[7] = math.floor((self.rpmValue - (math.floor(self.rpmValue/ 10000000) * 10000000) - self.rpmNumAtPos[1] - self.rpmNumAtPos[2] - self.rpmNumAtPos[3] - self.rpmNumAtPos[4] - self.rpmNumAtPos[5] - self.rpmNumAtPos[6]) / 1000000);
			
					if self.run then
						for i=1, self.rpmSegmentCount do
							if self.rpmNumAtPos[i] == 0 then
								self.rpmDispSeg[i].a = true;	self.rpmDispSeg[i].b = true;	self.rpmDispSeg[i].c = true;	self.rpmDispSeg[i].d = true;	self.rpmDispSeg[i].e = true;	self.rpmDispSeg[i].f = true;	self.rpmDispSeg[i].g = false;
							elseif self.rpmNumAtPos[i] == 1 then
								self.rpmDispSeg[i].a = false;	self.rpmDispSeg[i].b = true;	self.rpmDispSeg[i].c = true;	self.rpmDispSeg[i].d = false;	self.rpmDispSeg[i].e = false;	self.rpmDispSeg[i].f = false;	self.rpmDispSeg[i].g = false;
							elseif self.rpmNumAtPos[i] == 2 then
								self.rpmDispSeg[i].a = true;	self.rpmDispSeg[i].b = true;	self.rpmDispSeg[i].c = false;	self.rpmDispSeg[i].d = true;	self.rpmDispSeg[i].e = true;	self.rpmDispSeg[i].f = false;	self.rpmDispSeg[i].g = true;
							elseif self.rpmNumAtPos[i] == 3 then
								self.rpmDispSeg[i].a = true;	self.rpmDispSeg[i].b = true;	self.rpmDispSeg[i].c = true;	self.rpmDispSeg[i].d = true;	self.rpmDispSeg[i].e = false;	self.rpmDispSeg[i].f = false;	self.rpmDispSeg[i].g = true;
							elseif self.rpmNumAtPos[i] == 4 then
								self.rpmDispSeg[i].a = false;	self.rpmDispSeg[i].b = true;	self.rpmDispSeg[i].c = true;	self.rpmDispSeg[i].d = false;	self.rpmDispSeg[i].e = false;	self.rpmDispSeg[i].f = true;	self.rpmDispSeg[i].g = true;
							elseif self.rpmNumAtPos[i] == 5 then
								self.rpmDispSeg[i].a = true;	self.rpmDispSeg[i].b = false;	self.rpmDispSeg[i].c = true;	self.rpmDispSeg[i].d = true;	self.rpmDispSeg[i].e = false;	self.rpmDispSeg[i].f = true;	self.rpmDispSeg[i].g = true;
							elseif self.rpmNumAtPos[i] == 6 then
								self.rpmDispSeg[i].a = true;	self.rpmDispSeg[i].b = false;	self.rpmDispSeg[i].c = true;	self.rpmDispSeg[i].d = true;	self.rpmDispSeg[i].e = true;	self.rpmDispSeg[i].f = true;	self.rpmDispSeg[i].g = true;
							elseif self.rpmNumAtPos[i] == 7 then
								self.rpmDispSeg[i].a = true;	self.rpmDispSeg[i].b = true;	self.rpmDispSeg[i].c = true;	self.rpmDispSeg[i].d = false;	self.rpmDispSeg[i].e = false;	self.rpmDispSeg[i].f = false;	self.rpmDispSeg[i].g = false;
							elseif self.rpmNumAtPos[i] == 8 then
								self.rpmDispSeg[i].a = true;	self.rpmDispSeg[i].b = true;	self.rpmDispSeg[i].c = true;	self.rpmDispSeg[i].d = true;	self.rpmDispSeg[i].e = true;	self.rpmDispSeg[i].f = true;	self.rpmDispSeg[i].g = true;
							elseif self.rpmNumAtPos[i] == 9 then
								self.rpmDispSeg[i].a = true;	self.rpmDispSeg[i].b = true;	self.rpmDispSeg[i].c = true;	self.rpmDispSeg[i].d = true;	self.rpmDispSeg[i].e = false;	self.rpmDispSeg[i].f = true;	self.rpmDispSeg[i].g = true;
							end;
						end;
					end;
					self.oldRPMValue = self.rpmValue;
					self.converted = false;
					self.firstRunRPM = true;
				end;			
				
				if self.hoursValue ~= self.oldHoursValue then 
					if self.hoursValue > self.hoursValueMax then
						self.hoursValue = self.hoursValueMax;
					end; 
					if self.hoursValue <= self.hoursValueMin then
						self.hoursValue = 0.1;
					end;
					self.hoursValue = math.ceil(self.hoursValue);
				end;
				if (self.hoursValue ~= self.oldHoursValue) or self.firstrun then
					self.hoursNumAtPos[1] = math.floor((self.hoursValue - (math.floor(self.hoursValue/ 10) * 10)) / 1);
					self.hoursNumAtPos[2] = math.floor((self.hoursValue - (math.floor(self.hoursValue/ 100) * 100) - self.hoursNumAtPos[1]) / 10);
					self.hoursNumAtPos[3] = math.floor((self.hoursValue - (math.floor(self.hoursValue/ 1000) * 1000) - self.hoursNumAtPos[1] - self.hoursNumAtPos[2]) / 100);
					self.hoursNumAtPos[4] = math.floor((self.hoursValue - (math.floor(self.hoursValue/ 10000) * 10000) - self.hoursNumAtPos[1] - self.hoursNumAtPos[2] - self.hoursNumAtPos[3]) / 1000);
					self.hoursNumAtPos[5] = math.floor((self.hoursValue - (math.floor(self.hoursValue/ 100000) * 100000) - self.hoursNumAtPos[1] - self.hoursNumAtPos[2] - self.hoursNumAtPos[3] - self.hoursNumAtPos[4]) / 10000);
					self.hoursNumAtPos[6] = math.floor((self.hoursValue - (math.floor(self.hoursValue/ 1000000) * 1000000) - self.hoursNumAtPos[1] - self.hoursNumAtPos[2] - self.hoursNumAtPos[3] - self.hoursNumAtPos[4] - self.hoursNumAtPos[5]) / 100000);
					self.hoursNumAtPos[7] = math.floor((self.hoursValue - (math.floor(self.hoursValue/ 10000000) * 10000000) - self.hoursNumAtPos[1] - self.hoursNumAtPos[2] - self.hoursNumAtPos[3] - self.hoursNumAtPos[4] - self.hoursNumAtPos[5] - self.hoursNumAtPos[6]) / 1000000);
			
					if self.run then
						for i=1, self.hoursSegmentCount do
							if self.hoursNumAtPos[i] == 0 then
								self.hoursDispSeg[i].a = true;	self.hoursDispSeg[i].b = true;	self.hoursDispSeg[i].c = true;	self.hoursDispSeg[i].d = true;	self.hoursDispSeg[i].e = true;	self.hoursDispSeg[i].f = true;	self.hoursDispSeg[i].g = false;
							elseif self.hoursNumAtPos[i] == 1 then
								self.hoursDispSeg[i].a = false;	self.hoursDispSeg[i].b = true;	self.hoursDispSeg[i].c = true;	self.hoursDispSeg[i].d = false;	self.hoursDispSeg[i].e = false;	self.hoursDispSeg[i].f = false;	self.hoursDispSeg[i].g = false;
							elseif self.hoursNumAtPos[i] == 2 then
								self.hoursDispSeg[i].a = true;	self.hoursDispSeg[i].b = true;	self.hoursDispSeg[i].c = false;	self.hoursDispSeg[i].d = true;	self.hoursDispSeg[i].e = true;	self.hoursDispSeg[i].f = false;	self.hoursDispSeg[i].g = true;
							elseif self.hoursNumAtPos[i] == 3 then
								self.hoursDispSeg[i].a = true;	self.hoursDispSeg[i].b = true;	self.hoursDispSeg[i].c = true;	self.hoursDispSeg[i].d = true;	self.hoursDispSeg[i].e = false;	self.hoursDispSeg[i].f = false;	self.hoursDispSeg[i].g = true;
							elseif self.hoursNumAtPos[i] == 4 then
								self.hoursDispSeg[i].a = false;	self.hoursDispSeg[i].b = true;	self.hoursDispSeg[i].c = true;	self.hoursDispSeg[i].d = false;	self.hoursDispSeg[i].e = false;	self.hoursDispSeg[i].f = true;	self.hoursDispSeg[i].g = true;
							elseif self.hoursNumAtPos[i] == 5 then
								self.hoursDispSeg[i].a = true;	self.hoursDispSeg[i].b = false;	self.hoursDispSeg[i].c = true;	self.hoursDispSeg[i].d = true;	self.hoursDispSeg[i].e = false;	self.hoursDispSeg[i].f = true;	self.hoursDispSeg[i].g = true;
							elseif self.hoursNumAtPos[i] == 6 then
								self.hoursDispSeg[i].a = true;	self.hoursDispSeg[i].b = false;	self.hoursDispSeg[i].c = true;	self.hoursDispSeg[i].d = true;	self.hoursDispSeg[i].e = true;	self.hoursDispSeg[i].f = true;	self.hoursDispSeg[i].g = true;
							elseif self.hoursNumAtPos[i] == 7 then
								self.hoursDispSeg[i].a = true;	self.hoursDispSeg[i].b = true;	self.hoursDispSeg[i].c = true;	self.hoursDispSeg[i].d = false;	self.hoursDispSeg[i].e = false;	self.hoursDispSeg[i].f = false;	self.hoursDispSeg[i].g = false;
							elseif self.hoursNumAtPos[i] == 8 then
								self.hoursDispSeg[i].a = true;	self.hoursDispSeg[i].b = true;	self.hoursDispSeg[i].c = true;	self.hoursDispSeg[i].d = true;	self.hoursDispSeg[i].e = true;	self.hoursDispSeg[i].f = true;	self.hoursDispSeg[i].g = true;
							elseif self.hoursNumAtPos[i] == 9 then
								self.hoursDispSeg[i].a = true;	self.hoursDispSeg[i].b = true;	self.hoursDispSeg[i].c = true;	self.hoursDispSeg[i].d = true;	self.hoursDispSeg[i].e = false;	self.hoursDispSeg[i].f = true;	self.hoursDispSeg[i].g = true;
							end;
						end;
					end;
					self.oldHoursValue = self.hoursValue;
					self.converted = false;
					self.firstRunHours = true;
				end;
				if self.firstRunSpeed and self.firstRunRPM and self.firstRunHours then
					self.firstrun = false;
				end;
			else
				for i=1, self.speedSegmentCount do
					setVisibility(self.speedSegment[i].a, self.speedDispSeg[i].a);
					setVisibility(self.speedSegment[i].b, self.speedDispSeg[i].b);
					setVisibility(self.speedSegment[i].c, self.speedDispSeg[i].c);
					setVisibility(self.speedSegment[i].d, self.speedDispSeg[i].d);
					setVisibility(self.speedSegment[i].e, self.speedDispSeg[i].e);
					setVisibility(self.speedSegment[i].f, self.speedDispSeg[i].f);
					setVisibility(self.speedSegment[i].g, self.speedDispSeg[i].g);
				end;
				for i=1, self.rpmSegmentCount do
					setVisibility(self.rpmSegment[i].a, self.rpmDispSeg[i].a);
					setVisibility(self.rpmSegment[i].b, self.rpmDispSeg[i].b);
					setVisibility(self.rpmSegment[i].c, self.rpmDispSeg[i].c);
					setVisibility(self.rpmSegment[i].d, self.rpmDispSeg[i].d);
					setVisibility(self.rpmSegment[i].e, self.rpmDispSeg[i].e);
					setVisibility(self.rpmSegment[i].f, self.rpmDispSeg[i].f);
					setVisibility(self.rpmSegment[i].g, self.rpmDispSeg[i].g);
				end;
				for i=1, self.hoursSegmentCount do
					setVisibility(self.hoursSegment[i].a, self.hoursDispSeg[i].a);
					setVisibility(self.hoursSegment[i].b, self.hoursDispSeg[i].b);
					setVisibility(self.hoursSegment[i].c, self.hoursDispSeg[i].c);
					setVisibility(self.hoursSegment[i].d, self.hoursDispSeg[i].d);
					setVisibility(self.hoursSegment[i].e, self.hoursDispSeg[i].e);
					setVisibility(self.hoursSegment[i].f, self.hoursDispSeg[i].f);
					setVisibility(self.hoursSegment[i].g, self.hoursDispSeg[i].g);
				end;
				self.converted = true;
			end;
		end;
		
	end; -- end self.isActive
	
end;

function Display:draw()
end;

function Display:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local speedUnitKPH = getXMLBool(xmlFile, key.."#displayKPH");	
	if speedUnitKPH ~= nil and not speedUnitKPH then
		self:doActionOnObject(4);
	end;

    return BaseMission.VEHICLE_LOAD_OK;
end;

function Display:getSaveAttributesAndNodes(nodeIdent)
	if self.speedUnit ~= nil then
		local kph = true;
		if self.speedUnit ~= 1 then
			kph = false;
		end;
		local attributes = 'displayKPH="'.. tostring(kph) .. '"';
		return attributes, nil;
	end;
end;