-- author: rafftnix
-- date: 09.02.2013

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

-- inserts fillType "woodChip" into fillables which are chaff or silage ready and into the bga

local hudOverlayFilename = g_currentModDirectory.."textures/gui/woodchip.dds";
Fillable.registerFillType("woodChip", g_i18n:getText("woodChip"), 0.5, false, hudOverlayFilename);

local oldFillableLoad = Fillable.load;
Fillable.load = function(self, xmlFile)
	oldFillableLoad(self, xmlFile);

	if self.fillPlanes ~= nil then 
		local chaff = Fillable.fillTypeNameToInt["chaff"];
		local silage = Fillable.fillTypeNameToInt["silage"];
		local woodChip = Fillable.fillTypeNameToInt["woodChip"];
		
		if self.fillTypes[woodChip] == nil then
			if self.fillTypes[chaff] ~= nil then
				self.fillTypes[woodChip] = true;
				self.fillPlanes["woodChip"] = self.fillPlanes["chaff"];
				self.fillTypeWoodChipAutoAdded = true;
			elseif self.fillTypes[silage] ~= nil then
				self.fillTypes[woodChip] = true;
				self.fillPlanes["woodChip"] = self.fillPlanes["silage"];
				self.fillTypeWoodChipAutoAdded = true;
			end;
		end;
	end;
end;

-- copy discharge particle system from chaff if trailer can handle chaff, but only if a woodChip-PS does not already exist!
local oldTrailerLoad = Trailer.load;
Trailer.load = function(self, xmlFile)
	oldTrailerLoad(self, xmlFile);
	if self.fillPlanes ~= nil then 
		if self.tipAnimations ~= nil then
			local chaff = Fillable.fillTypeNameToInt["chaff"];
			local woodChip = Fillable.fillTypeNameToInt["woodChip"];
			for a=1, table.getn(self.tipAnimations) do
				if self.tipAnimations[a].dischargeParticleSystems[chaff] ~= nil and self.tipAnimations[a].dischargeParticleSystems[woodChip] == nil then 
					self.tipAnimations[a].dischargeParticleSystems[woodChip] = self.tipAnimations[a].dischargeParticleSystems[chaff];
				end;
			end;
		end;
	end;
end;	

-- delete particle system entry to make sure the particle system gets not deleted twice
local oldTrailerDelete = Trailer.delete;
Trailer.delete = function(self)
	if self.fillPlanes ~= nil then
		if self.fillTypeWoodChipAutoAdded ~= nil and self.fillTypeWoodChipAutoAdded then
			local woodChip = Fillable.fillTypeNameToInt["woodChip"];
			for a=1, table.getn(self.tipAnimations) do
				if self.tipAnimations[a].dischargeParticleSystems[woodChip] ~= nil then 
					self.tipAnimations[a].dischargeParticleSystems[woodChip] = nil;
				end;
			end;
		end;
	end;
	oldTrailerDelete(self);
end;

local oldShovelLoad = Shovel.load;
Shovel.load = function(self, xmlFile)
	oldShovelLoad(self, xmlFile);

	if self.fillPlanes ~= nil then
		local chaff = Fillable.fillTypeNameToInt["chaff"];
		local silage = Fillable.fillTypeNameToInt["silage"];
		local woodChip = Fillable.fillTypeNameToInt["woodChip"];
		
		if self.fillTypeWoodChipAutoAdded then 
			if self.fillTypes[chaff] ~= nil and self.emptyParticleSystems[chaff] ~= nil then
				self.emptyParticleSystems[woodChip] = self.emptyParticleSystems[chaff];
			elseif self.fillTypes[silage] ~= nil and self.emptyParticleSystems[silage] ~= nil then
				self.emptyParticleSystems[woodChip] = self.emptyParticleSystems[silage];
			end;
		end;
	end;
end;

local oldShovelDelete = Shovel.delete;
Shovel.delete = function(self)
	if self.fillPlanes ~= nil then 
		local woodChip = Fillable.fillTypeNameToInt["woodChip"];
		self.emptyParticleSystems[woodChip] = nil;
	end;
	oldShovelDelete(self);
end;

-- Bga 			
local oldBgaLoad = Bga.load;
Bga.load = function(self, nodeId)
	local ok = oldBgaLoad(self, nodeId);
	local woodChip = Fillable.fillTypeNameToInt["woodChip"];
	for a=1, table.getn(self.tipTriggers) do
		self.tipTriggers[a].acceptedFillTypes[woodChip] = true;
		self.tipTriggers[a].priceMultipliers[woodChip] = 0.65;
	end;
	return ok;
end;