-- author: rafftnix
-- date: 05.11.2012

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

if g_currentModName ~= "MR_ForestMod" then
	print("Error: The forest mod must not be renamed. It must be called MR_ForestMod.zip");
end;

TreeManager = {}
TreeManager.numRegisteredTreeTypes = 0;
TreeManager.directory = g_currentModDirectory;
TreeManager.treeTypes = {}
TreeManager.treesToPlace = {}

function TreeManager.registerNewTreeType(name, iconFilename, l10nText)
	if TreeManager.treeTypes[name] == nil then
		TreeManager.numRegisteredTreeTypes = TreeManager.numRegisteredTreeTypes + 1;
		local num = TreeManager.numRegisteredTreeTypes;
		TreeManager.treeTypes[name] = {}
		TreeManager.treeTypes[name].trees = {}
		if iconFilename ~= nil then
			TreeManager.treeTypes[name].icon = createImageOverlay(iconFilename);
		end;
		TreeManager.treeTypes[name].num = TreeManager.numRegisteredTreeTypes;
		TreeManager.treeTypes[num] = {}
		TreeManager.treeTypes[num].treeType = name;
		TreeManager.treeTypes[num].l10nText = l10nText;
	end;
end;

function TreeManager:registerTree(treeType, filename, groundOffsetY, harvestableTreeGroundOffsetY, growTime, xmlFile, baseDir)
	local tree = {}
	tree.filename = filename;
	tree.groundOffsetY = groundOffsetY;
	tree.xmlFilename = xmlFile;
	tree.growTime = growTime;
	tree.baseDir = baseDir;
	tree.harvestableTreeGroundOffsetY = harvestableTreeGroundOffsetY;
	table.insert(self.treeTypes[treeType].trees, tree);
end;

function TreeManager:loadMap(name)
	if self.firstLoadRun == nil then
		g_currentMission.treeManager = self;
		self.treeTypes = TreeManager.treeTypes;
		
		g_i18n.globalI18N.texts["subCategory_forest"] = g_i18n:getText("shopSubCategory_forest");
	
		self.growUpdateTime = 120;
		self.firstLoadRun = true;
		self.deleteDone = false;
		self.firstRunDone = false;
		self.lastUpdatedGrowingTree = 0;
		self.numOfPlacedtrees = 0;
		self.growingTrees = {}
		self.drawNeededSTTs = {}
		
		self.ambientSounds = AmbientSounds:new();
		self.forrestModTutorial = Tutorial:new();
		self.tutorialGuisToOpen = {}
		
		if not self.forrestModTutorial:getHasAlreadySeen("transport") then
			self.cuttedTreeJointsForTransportTutorial = 0;
		end;
		
		self.growTimer = addTimer(self.growUpdateTime, "setGrowScale", self);
		
		table.insert(g_currentMission.onCreateLoadedObjectsToSave, self);
		
		self.nodeIdToTree = {}
		self.nodeIdToTrunk = {}
	end;
end;

function TreeManager:deleteMap()
	if self.growingTrees ~= nil then
		for a=1, table.getn(self.growingTrees) do
			delete(self.growingTrees[a].col);
		end;
		self.deleteDone = true;
		self.firstLoadRun = nil;
		self.growingTrees = nil;
	end;
	
	if self.forrestModTutorial ~= nil then
		self.forrestModTutorial:saveAlreadySeen();
	end;
end;

local ServerSendObjects_old = Server.sendObjects;
function Server.sendObjects(self, connection, x,y,z, viewDistanceCoeff)
	ServerSendObjects_old(self, connection, x,y,z, viewDistanceCoeff);

	for a=1, table.getn(g_currentMission.treeManager.growingTrees) do
		local tree = g_currentMission.treeManager.growingTrees[a];
		local treeTypeNum = g_currentMission.treeManager.treeTypes[tree.type].num;
		local tx, ty, tz = unpack(tree.pos);
		local scale = tree.scale * 100; -- percent
		local yRotation = math.floor(math.deg(tree.yRotation)/3);
		connection:sendEvent(PlaceNewTreeEvent:new(treeTypeNum, tx, ty, tz, scale, yRotation, tree.treeIndex));
	end;
end;

function TreeManager:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local i = 0;
	while true do
		local treename = key..".tree("..tostring(i)..")";
		local treeType = getXMLString(xmlFile, treename .. "#type");
		if treeType == nil then
			break;
		end;
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, treename .. "#position"));
		local scale = getXMLFloat(xmlFile, treename .. "#scale");
		local yRotation = getXMLFloat(xmlFile, treename .. "#yRotation");
		local treeIndex = getXMLInt(xmlFile, treename .. "#treeIndex");
		self:placeNewTree(treeType, x, y, z, scale, math.rad(yRotation), treeIndex, true);
		i = i + 1;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function TreeManager:getSaveAttributesAndNodes(nodeIdent) 
	local attributes = "";
	local nodes = "";
	
	local numGrowingTrees = table.getn(self.growingTrees);
	for a=1, numGrowingTrees do
		local tree = self.growingTrees[a];
		local x, y, z = getWorldTranslation(tree.tree);
		local tag = '       <tree position="'..tostring(x)..' '..tostring(y)..' '..tostring(z)..'"';                
		tag = tag..' type="'..tostring(tree.type)..'" ';
		tag = tag..'scale="'..tostring(tree.scale)..'" ';
		tag = tag..'treeIndex="'..tostring(tree.treeIndex)..'" ';
		tag = tag..'yRotation="'..tostring(math.deg(tree.yRotation))..'"/>';
		if numGrowingTrees ~= a then
			tag = tag..'\n';
		end;
		nodes = nodes..tag;
	end;
	return attributes, nodes;
end;

function TreeManager:mouseEvent(posX, posY, isDown, isUp, button)

end;

function TreeManager:keyEvent(unicode, sym, modifier, isDown)

end;

function TreeManager:update(dt)
	if not self.firstRunDone then
		self.firstRunDone = true;
		self.ambientSounds:startSounds();
		
		self.forrestModTutorial:checkShowTutorial("welcome");
		
		for a=1, table.getn(TreeManager.treesToPlace) do
			local ttp = self.treesToPlace[a];
			self:placeNewTree(ttp[5], ttp[1], ttp[2], ttp[3], ttp[7], ttp[4], ttp[6], false);
		end;
		TreeManager.treesToPlace = {}
	end;
	
	for a=1, table.getn(self.tutorialGuisToOpen) do
		if self.forrestModTutorial:getHasAlreadySeen(self.tutorialGuisToOpen[a]) or self.forrestModTutorial:checkShowTutorial(self.tutorialGuisToOpen[a]) then
			table.remove(self.tutorialGuisToOpen, a);
		end;
	end;
	
	if InputBinding.hasEvent(InputBinding.OPENFORRESTMODGUI) and InputBinding.isPressed(InputBinding.OPENFORRESTMODGUI_KEY) then
		self.forrestModTutorial:openOnPage("welcome");
	end;
end;

function TreeManager:draw()
	if self.chainSawNeedsDrawing ~= nil then
		self.chainSawNeedsDrawing:chainSawDraw();
	end;
	
	for a=1, table.getn(self.drawNeededSTTs) do
		if self.drawNeededSTTs[a].draw ~= nil then
			self.drawNeededSTTs[a]:draw();
		end;
	end;
end;

function TreeManager:placeNewTree(treeType, x, y, z, scale, yRotation, treeIndex, noEventSend) 
	if self.treeTypes[treeType] ~= nil then
		y = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 500, z);
		
		local filename = self.treeTypes[treeType].trees[treeIndex].filename;
		local tree = {}
		local root = Utils.loadSharedI3DFile(filename, self.treeTypes[treeType].trees[treeIndex].baseDir);
		tree.col = getChildAt(root, 0);
		tree.tree = getChildAt(tree.col, 0);
		setRigidBodyType(tree.col, "NoRigidBody");
		tree.type = treeType;
		tree.typeNum = self.treeTypes[tree.type].num;
		tree.growTime = self.treeTypes[treeType].trees[treeIndex].growTime;
		tree.treeIndex = treeIndex;
		tree.scale = scale;
		tree.yRotation = yRotation;
		
		tree.growingTime = tree.scale * self.treeTypes[treeType].trees[treeIndex].growTime;
		
		link(getRootNode(), tree.col);
		delete(root);
		
		tree.pos = {x, y+self.treeTypes[treeType].trees[treeIndex].groundOffsetY, z}
		setTranslation(tree.col, unpack(tree.pos));
		
		rotate( tree.col, 0, tree.yRotation, 0 );
		setScale(tree.tree, tree.scale, tree.scale, tree.scale);
		
		-- add rigid body
		if g_server ~= nil then
			setRigidBodyType(tree.col, "Static");
		end;
	
		table.insert(self.growingTrees, tree);
		
		if not noEventSend then
			PlaceNewTreeEvent.sendEvent(treeType, x, y, z, tree.scale, tree.yRotation, tree.treeIndex, noEventSend);
		end;
		
		self.numOfPlacedtrees = self.numOfPlacedtrees + 1;
		if self.numOfPlacedtrees > 50 then
			g_currentMission.treeManager.forrestModTutorial:checkShowTutorial("performanceWarning");
		end;
		if self.numOfPlacedtrees > 100 then
			g_currentMission.treeManager.forrestModTutorial:checkShowTutorial("credits");
		end;
	else
		print("tree type ", tostring(treeType), " is not registered");	
	end;
end;

function TreeManager:setGrowScale()
	if self.deleteDone then
		return false;
	end;

	if g_gui.currentGui == nil then
		self.lastUpdatedGrowingTree = self.lastUpdatedGrowingTree + 1;
		if self.growingTrees[self.lastUpdatedGrowingTree] == nil then
			self.lastUpdatedGrowingTree = 1;
		end;
		
		if self.growingTrees[self.lastUpdatedGrowingTree] ~= nil then
			local tree = self.growingTrees[self.lastUpdatedGrowingTree];
			if tree.growingTime < tree.growTime then
				tree.growingTime = math.min(tree.growTime, tree.growingTime + self.growUpdateTime * table.getn(self.growingTrees) * g_currentMission.missionStats.timeScale * 0.0001); -- for fast grow: 1 instead of 0.0001
				tree.scale = tree.growingTime / tree.growTime;
				setScale(tree.tree, tree.scale, tree.scale, tree.scale);
			else
				-- set cutMeSign visible
				local sign = Utils.indexToObject(tree.col, "0>1");
				setVisibility(sign, true);
			end;
		end;
	end;
	return true;
end;

function TreeManager:removeGrowingTree(growingTreeIndex)
	local tree = self.growingTrees[growingTreeIndex];
	local x, y, z = getWorldTranslation(tree.col);
	local rx, ry, rz = getRotation(tree.col);
	unlink(tree.col);
	delete(tree.col);
	if g_server ~= nil then
		RemoveGrowingTreeEvent.sendEvent(growingTreeIndex);
		local groundOffset = self.treeTypes[tree.type].trees[tree.treeIndex].harvestableTreeGroundOffsetY
		local y = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 300, z) + groundOffset;
		g_currentMission.harvestableTrees:plantNewHarvestableTree(x, y, z, rx, ry, rz, tree.typeNum, tree.treeIndex);
	end;
	table.remove(self.growingTrees, growingTreeIndex);
end;

addModEventListener(TreeManager);

Fillable.registerFillType("seedling", g_i18n:getText("seedling"), 50, false, TreeManager.directory .. "textures/gui/fir_tree.dds");

-- register tree type
TreeManager.registerNewTreeType("fir", g_currentModDirectory.."textures/gui/fir_tree.dds", g_i18n:getText("fir"));
TreeManager:registerTree("fir", "objects/trees/growingTrees/pine25_1grow.i3d", -0.2, -0.2, 34560, "objects/trees/harvestableTrees/pine25_1harvest.xml", g_currentModDirectory);
TreeManager:registerTree("fir", "objects/trees/growingTrees/pine25_2grow.i3d", -0.2, -0.2, 34560, "objects/trees/harvestableTrees/pine25_2harvest.xml", g_currentModDirectory);
TreeManager:registerTree("fir", "objects/trees/growingTrees/pine15grow.i3d", -0.2, -0.2, 25920, "objects/trees/harvestableTrees/pine15harvest.xml", g_currentModDirectory);
TreeManager:registerTree("fir", "objects/trees/growingTrees/pine20grow.i3d", -0.2, -0.2, 20000, "objects/trees/harvestableTrees/pine20harvest.xml", g_currentModDirectory);