-- rafftnixGUI.lua
-- author: rafftnix
-- date: 26.05.2013

-- Keine Vernderung ohne meine Erlaubnis!
-- No modification without my permission!
-- history: 
--  		v1.0 (August 2013 - GIANTS mod contest hand in)
--			v1.1 (December 2013) - Forrest mod


RafftnixGUIHelper = {}
RafftnixGUIHelper.modDir = g_currentModDirectory;

function RafftnixGUIHelper:loadMap()
	if not self.gameIsOn then
		self.GUIs = {}
		g_currentMission.rafftnixGUIHelper = self;
		self.gameIsOn = true;
	end;
end;

function RafftnixGUIHelper:deleteMap()
	if self.gameIsOn then
		for a=1, table.getn(self.GUIs) do
			if self.GUIs[a].delete ~= nil then
				self.GUIs[a]:delete();
			end;
		end;
		self.gameIsOn = false;
	end;
end;

function RafftnixGUIHelper:mouseEvent(posX, posY, isDown, isUp, button)
	for a=1, table.getn(self.GUIs) do
		if self.GUIs[a].mouseEvent ~= nil then
			self.GUIs[a]:mouseEvent(posX, posY, isDown, isUp, button);
		end;
	end;
end;

function RafftnixGUIHelper:keyEvent(unicode, sym, modifier, isDown)
	for a=1, table.getn(self.GUIs) do
		if self.GUIs[a].keyEvent ~= nil then
			self.GUIs[a]:keyEvent(unicode, sym, modifier, isDown);
		end;
	end;
end;

function RafftnixGUIHelper:update(dt)
	for a=1, table.getn(self.GUIs) do
		if self.GUIs[a].update ~= nil then
			self.GUIs[a]:update(dt);
		end;
	end;
end;

function RafftnixGUIHelper:draw()
	for a=1, table.getn(self.GUIs) do
		if self.GUIs[a].draw ~= nil then
			self.GUIs[a]:draw();
		end;
	end;
end;

addModEventListener(RafftnixGUIHelper);


RafftnixGUI = {}

local RafftnixGUI_mt = Class(RafftnixGUI);

function RafftnixGUI:new(mt, fullScreenMode)
	local self = {}
	
	if mt == nil then
		mt = RafftnixGUI_mt;
	end;
	setmetatable(self, mt);
	
	table.insert(g_currentMission.rafftnixGUIHelper.GUIs, self);
	self.baseElement = self:createElement(nil, 0, 0, 1, 1);
	self.baseElement:setVisibility(false);
	self.fullScreenMode = fullScreenMode;
	
	return self;
end;

function RafftnixGUI:open()
	if g_gui.currentGui ~= nil and g_gui.currentGui.baseElement ~= nil and g_gui.currentGui.fullScreenMode ~= nil then
		g_gui.currentGui:close();
	end;

	self.baseElement.visibility = true;
	if self.fullScreenMode then
		g_gui:showGui("");
		InputBinding.setShowMouseCursor(true);
		g_currentMission.isPlayerFrozen = true;
		g_gui.currentGui = self;
		
		-- stop vehicles if a gui is open and you can not control the vehicle
		if g_currentMission.controlledVehicle ~= nil and g_currentMission.controlledVehicle.motor ~= nil then
			g_currentMission.controlledVehicle.motor:setSpeedLevel(0, true)
		end;
	end;
end;

function RafftnixGUI:close()
	self.baseElement.visibility = false;
	if self.fullScreenMode then
		InputBinding.setShowMouseCursor(false);
		g_currentMission.isPlayerFrozen = false;
		g_gui.currentGui = nil;
	end;
end;

function RafftnixGUI:onOpen()
	self:open();
end;

function RafftnixGUI:onClose()
	self:close();
end;

function RafftnixGUI:delete()
	self:deleteElement(self.baseElement);
end;

function RafftnixGUI:deleteElement(element)
	if element.overlayId ~= nil then
		delete(element.overlayId);
		element.overlayId = nil;
	end;

	for a=1, table.getn(element.elements) do
		self:deleteElement(element.elements[a]);
	end;
	element = nil;
end;

function RafftnixGUI:createElement(baseElement, posX, posY, width, height)
	local element = {}
	element.elements = {}
	element.visibility = true;
	element.posX = posX;
	element.posY = posY;
	element.width = width;
	element.height = height;
	element.isDisabled = false;
	element.isSelected = false;
	
	function element:setVisibility(visibility)
		element.visibility = visibility;
	end;
	
	function element:setPosition(posX, posY)
		element.posX = posX;
		element.posY = posY;
	end;
	
	function element:setDimension(width, height)
		element.width = width;
		element.height = height;
	end;
	
	function element:setDisabled(state)
		element.isDisabled = state;
		if element.textColor ~= nil then
			element.textColor[4] = 0.5;
		end;
		for a=1, table.getn(element.elements) do
			element.elements[a]:setDisabled(state);
		end;
	end;
	
	if baseElement ~= nil then
		table.insert(baseElement.elements, element);
	end;
	
	return element;
end;

function RafftnixGUI:createText(baseElement, posX, posY, width, height, text, textSize, textColor)
	local element = self:createElement(baseElement, posX, posY, width, height);
	
	element.text = text;
	element.textSize = textSize;
	
	if textColor == 1 then
		element.textColor = {1, 1, 1, 1};
	else
		element.textColor = textColor;
		print("text with special color set");
		printCallstack();
	end;
	
	function element:setText(text)
		element.text = text;
	end;
	
	function element:setTextColor(textColor)
		element.textColor = textColor;
	end;

	return element;
end;

function RafftnixGUI:createButton(baseElement, posX, posY, width, height, text, textSize, textColor, onClickFunction, object)
	local element = self:createText(baseElement, posX, posY, width, height, text, textSize, textColor, object);
	
	element.onClickFunction = onClickFunction;
	element.onClickCallbackTarget = object;
		
	return element;
end;

function RafftnixGUI:createTextInput(baseElement, posX, posY, width, height, defaultText, textSize, textColor, maxCharacters)
	local element = self:createText(baseElement, posX, posY, width, height, defaultText, textSize, textColor);
	
	element.maxCharacters = Utils.getNoNil(maxCharacters, 30);
	element.textInput = true;
	
	return element;
end;

function RafftnixGUI:createList(baseElement, posX, posY, width, height, heightPerEntry, maxVisibleEntrys, selectEntryCallbackFunction, selectEntryCallbackTarget)
	local element = self:createElement(baseElement, posX, posY, width, height);
	
	element.isList = true;
	element.maxVisibleEntrys = maxVisibleEntrys;
	element.selectedEntry = 1;
	element.highestVisibleEntry = 1;
	element.heightPerEntry = heightPerEntry;
	element.selectEntryCallbackFunction = selectEntryCallbackFunction;
	element.selectEntryCallbackTarget = selectEntryCallbackTarget;
	
	function element:scrollUp()
		element.highestVisibleEntry = math.max(1, element.highestVisibleEntry-1);
	end;
	
	function element:scrollDown()
		element.highestVisibleEntry = math.min(table.getn(element.elements) - element.maxVisibleEntrys, element.highestVisibleEntry+1);
	end;
	
	return element;
end;

function RafftnixGUI:createImage(baseElement, posX, posY, width, height, filename)
	local element = self:createElement(baseElement, posX, posY, width, height);
	
	element.overlayId = createImageOverlay(RafftnixGUIHelper.modDir..filename);
	return element;
end;

function RafftnixGUI:createImgButton(baseElement, posX, posY, width, height, filename, onClickFunction, object)
	local element = self:createButton(baseElement, posX, posY, width, height, "", 1, 1, onClickFunction, object);
	
	element.overlayId = createImageOverlay(RafftnixGUIHelper.modDir..filename);
	return element;
end;

function RafftnixGUI:createScrollBar(baseElement, posX, posY, width, height, slideBarFilename, sliderFilename, sliderWidth, sliderLength, minValue, maxValue, defaultValue)
	local element = self:createImage(baseElement, posX, posY, width, height, slideBarFilename);
	local slider = self:createImage(element, -width/2, 0, width, height, sliderFilename);
end;

function RafftnixGUI:mouseEvent(posX, posY, isDown, isUp, button)
	if self.baseElement.visibility then
		self:checkElementOnMouseEvent(self.baseElement, posX, posY, isDown, isUp, button);
	end;	
end;

function RafftnixGUI:keyEvent(unicode, sym, modifier, isDown)
	if self.baseElement.visibility then
		self:checkElementOnKeyEvent(self.baseElement, unicode, sym, modifier, isDown);
	end;
end;

function RafftnixGUI:checkElementOnKeyEvent(element, unicode, sym, modifier, isDown)
	if element.textInput ~= nil and element.textInput and element.visibility and isDown then
		if element.maxCharacters ~= nil and element.maxCharacters > string.len(element.text) then
			if (unicode > 96 and unicode < 123) or (unicode > 64 and unicode < 91) or unicode == 32 or unicode == 94 or unicode == 93 or unicode == 91 or unicode == 123 or unicode == 125 or unicode == 92 or unicode == 223 or unicode == 63 or unicode == 33 or unicode == 34 or (unicode > 48 and unicode < 60) or (unicode > 39 and unicode < 48) or unicode == 124 then 
				element:setText(element.text .. string.char(unicode));
			end;
		end;
		
		if unicode == 8 then
			local length = string.len(element.text);
			element:setText(string.sub(element.text, 1, length-1));
		end;
	end;

	if element.visibility then
		for a=1, table.getn(element.elements) do
			self:checkElementOnKeyEvent(element.elements[a], unicode, sym, modifier, isDown);
		end;
	end;
end;

function RafftnixGUI:checkElementOnMouseEvent(element, mouseX, mouseY, isDown, isUp, button)
	if (element.onClickFunction ~= nil or (element.isList ~= nil and element.isList)) and isDown and element.visibility and button == 1 and not element.isDisabled then
		if mouseX > element.posX and mouseX < (element.posX + element.width) then 
			if mouseY > element.posY and mouseY < (element.posY + element.height) then 
				if element.onClickFunction ~= nil then
					element.onClickFunction(element.onClickCallbackTarget);
				end;
				if element.isList then
					local y = element.posY + element.height;
					
					local start = element.highestVisibleEntry;
					local stop = math.min(element.highestVisibleEntry + element.maxVisibleEntrys - 1, table.getn(element.elements));

					for a=start, stop do
						local entry = element.elements[a];
						if mouseY < y and mouseY > (y - element.heightPerEntry) then
							element.elements[element.selectedEntry].isSelected = false;
							element.selectEntryCallbackFunction(element.selectEntryCallbackTarget, a);
							element.selectedEntry = a;
							element.elements[element.selectedEntry].isSelected = true;
							break;
						end;
						
						y = y - element.heightPerEntry;
					end;
				end;
			end;
		end;
	end;

	if element.isList ~= nil and element.isList and isDown then
		if button == 4 then
			element.scrollUp();
		end;
		if button == 5 then
			element.scrollDown();
		end;
	end;

	if element.visibility then
		for a=1, table.getn(element.elements) do
			self:checkElementOnMouseEvent(element.elements[a], mouseX, mouseY, isDown, isUp, button);
		end;
	end;
end;

function RafftnixGUI:update(dt)

end;

function RafftnixGUI:draw()
	setTextBold(false);
	self:renderElement(self.baseElement, 0, 0, false);
end;

function RafftnixGUI:renderElement(element, x, y, parentElementSelected)
	if element.visibility then
		x = x + element.posX;
		y = y + element.posY;
		if element.text ~= nil then
			if element.isSelected or parentElementSelected then
				setTextColor(0,1,0,element.textColor[4]);
			else
				setTextColor(unpack(element.textColor));
			end;
			
			renderText(x, y, element.textSize, element.text);
			setTextColor(1, 1, 1, 1);
		end;
		if element.overlayId ~= nil then 
			renderOverlay(element.overlayId, x, y, element.width, element.height);
		end;
		
		if element.isList ~= nil then -- list
			local start = element.highestVisibleEntry;
			local stop = math.min(element.highestVisibleEntry + element.maxVisibleEntrys - 1, table.getn(element.elements));
			y = element.posY + element.height;
			
			for a=start, stop do
				if element.elements[a] ~= nil then
					y = y - element.heightPerEntry;
					
					local parentElementSelected = false;
					if element.selectedEntry == a then
						parentElementSelected = true;
					end;
					self:renderElement(element.elements[a], x, y, parentElementSelected);
				end;
			end;
		else
			for a=1, table.getn(element.elements) do
				self:renderElement(element.elements[a], x, y, parentElementSelected);
			end;
		end;
	end;
end;