-- author: rafftnix
-- date: 14.11.2013

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

WoodChipStorage = {}
WoodChipStorage_mt = Class(WoodChipStorage, Placeable);
InitObjectClass(WoodChipStorage, "WoodChipStorage");

function WoodChipStorage:new(isServer, isClient, mt)
	if mt == nil then
		mt = WoodChipStorage_mt;
	end;
	
	local self = Placeable:new(isServer, isClient, mt);
	self.tipTriggers = {}
	
	registerObjectClassName(self, "WoodChipStorage");
	return self;
end;

function WoodChipStorage:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
	WoodChipStorage:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom);
	
	if not moveMode then
		local xmlFile = loadXMLFile("temp", xmlFilename);
		
		local num = 0;
		while true do
			local key = "placeable.storages.storage("..tostring(num)..")";
			if not hasXMLProperty(xmlFile, key) then
				break;
			end;
			
			local tipTriggerNode = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, key.."#tipTriggerIndex"));
			local shovelTriggerNode = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, key.."#shovelTriggerIndex"));
			local tipTrigger = StorageTipTrigger:new(g_server ~= nil, g_client ~= nil);
			if tipTrigger:load(tipTriggerNode, shovelTriggerNode) then
				g_currentMission:addOnCreateLoadedObject(tipTrigger);
				tipTrigger:register(true);
				table.insert(self.tipTriggers, tipTrigger);
			else
				tipTrigger:delete();
			end;
			
			num = num + 1;
		end;
		
		delete(xmlFile);
	end;
	
	return true;
end;

function WoodChipStorage:delete()
	unregisterObjectClassName(self);

	for a=1, table.getn(self.tipTriggers) do
		self.tipTriggers[a]:delete();
	end;
	self.tipTriggers = {}
	
	WoodChipStorage:superClass().delete(self);
end;

function WoodChipStorage:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local loadOk = WoodChipStorage:superClass().loadFromAttributesAndNodes(self, xmlFile, key, resetVehicles);
	
	for a=1, table.getn(self.tipTriggers) do
		local fillLevel = getXMLFloat(xmlFile, key .. ".storage("..tostring(a-1)..")#fillLevel");
		self.tipTriggers[a].fillLevel = Utils.getNoNil(fillLevel, 0);
	end;

	return true; 
end;

function WoodChipStorage:getSaveAttributesAndNodes(nodeIdent)
	local attributes, nodes = WoodChipStorage:superClass().getSaveAttributesAndNodes(self, nodeIdent);
	local num = table.getn(self.tipTriggers);
	for a=1, num do
		nodes = nodes .. '		<storage fillLevel="' .. self.tipTriggers[a].fillLevel .. '" /> ';
		if a < num then
			nodes = nodes .. "\n";
		end;
	end;
	return attributes, nodes;
end;

function WoodChipStorage:readStream(streamId, connection)
	WoodChipStorage:superClass().readStream(self, streamId, connection);
	StorageTipTrigger.readStream(self, streamId, connection);
end;

function WoodChipStorage:writeStream(streamId, connection)
	WoodChipStorage:superClass().writeStream(self, streamId, connection);
	StorageTipTrigger.writeStream(self, streamId, connection);
end;

function WoodChipStorage:readUpdateStream(streamId, timestamp, connection)
	WoodChipStorage:superClass().readUpdateStream(self, streamId, timestamp, connection);
	StorageTipTrigger.readUpdateStream(self, streamId, timestamp, connection);
end;
  
function WoodChipStorage:writeUpdateStream(streamId, connection, dirtyMask)
	WoodChipStorage:superClass().writeUpdateStream(self, streamId, connection, dirtyMask);
	StorageTipTrigger.writeUpdateStream(self, streamId, connection, dirtyMask);
end;

registerPlaceableType("woodChipStorage", WoodChipStorage);