-- Specialisation for WF Trac
-- 
-- Author: Mofi, Face, John Deere 6930, fruktor

WFTrac = {};

function WFTrac.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function WFTrac:load(xmlFile)	
	local wiperAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper#rootNode"));
    self.wiperAnimCharSet = 0;
    if wiperAnimRootNode ~= nil and wiperAnimRootNode ~= 0 then
        self.wiperAnimCharSet = getAnimCharacterSet(wiperAnimRootNode);
        if self.wiperAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperAnimCharSet, getXMLString(xmlFile, "vehicle.wiper#clip"));
            assignAnimTrackClip(self.wiperAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperAnimCharSet, 0, true);
            local wiperAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiper#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperAnimCharSet, 0, wiperAnimSpeedScale);
            self.wiperAnimDuration = getAnimClipDuration(self.wiperAnimCharSet, clip);
        end;
    end;
	self.isWiperActive = false;
	self.finishWiper = true;
    
	local gaspedalNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.gaspedal#index"));
    if gaspedalNode ~= nil then
        self.gaspedal = {};
        self.gaspedal.node = gaspedalNode;    
		self.gaspedal.maxSpeed = getXMLInt(xmlFile, "vehicle.gaspedal#maxSpeed");
		local x1,y1,z1 = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.gaspedal#minRot"));
		local x2,y2,z2 = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.gaspedal#maxRot"));		
		self.gaspedal.rotMin = {math.rad(Utils.getNoNil(x1,0)),math.rad(Utils.getNoNil(y1,0)),math.rad(Utils.getNoNil(z1,0))};
		self.gaspedal.rotMax = {math.rad(Utils.getNoNil(x2,0)),math.rad(Utils.getNoNil(y2,0)),math.rad(Utils.getNoNil(z2,0))};
    end;
	
    local bremspedalNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.bremspedal#index"));
    if bremspedalNode ~= nil then
        self.bremspedal = {};
        self.bremspedal.node = bremspedalNode;
		local x1,y1,z1 = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.gaspedal#minRot"));
		local x2,y2,z2 = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.gaspedal#maxRot"));
		self.bremspedal.rotMin = {math.rad(Utils.getNoNil(x1,0)),math.rad(Utils.getNoNil(y1,0)),math.rad(Utils.getNoNil(z1,0))};			
		self.bremspedal.rotMax = {math.rad(Utils.getNoNil(x2,0)),math.rad(Utils.getNoNil(y2,0)),math.rad(Utils.getNoNil(z2,0))};
        self.bremspedal.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bremspedal#rotTime"), 1)*1000;
        self.bremspedalIsActive = false;
    end;	
	
    local blinkerhebelNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.blinkerhebel#index"));
    if blinkerhebelNode ~= nil then
        self.blinkerhebel = {};
        self.blinkerhebel.node = blinkerhebelNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.blinkerhebel#minRot"));
        self.blinkerhebel.minRot = {};
        self.blinkerhebel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.blinkerhebel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.blinkerhebel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.blinkerhebel#rotLeft"));
        self.blinkerhebel.leftRot = {};
        self.blinkerhebel.leftRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.blinkerhebel.leftRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.blinkerhebel.leftRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.blinkerhebel#rotRight"));
        self.blinkerhebel.rightRot = {};
        self.blinkerhebel.rightRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.blinkerhebel.rightRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.blinkerhebel.rightRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.blinkerhebel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.blinkerhebel#rotTime"), 1)/1000;
		self.blinkerhebel.lastDir = 1;
    end;
	
	self.drehzahlnadel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.needles#rpmNeedle"));
	self.tanknadel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.needles#fuelNeedle"));
	self.needles = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.needles#needles"));
	self.drehzahlnadelLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.needles#rpmNeedleLight"));
	self.tanknadelLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.needles#fuelNeedleLight"));
	self.needlesLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.needles#needlesLight"));
	self.tankicon = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tankicon#index"));
	self.blinkericon = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.blinkericon#index"));
	self.hazardSwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cockpitSwitches#hazardSwitch"));
	self.workLightFrontSwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cockpitSwitches#workLightFrontSwitch"));
	self.workLightRearSwitch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cockpitSwitches#workLightRearSwitch"));
	self.sitz = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sitz#index"));
	self.cockpitLights = Utils.indexToObject(self.components, "0>8|2|13");
	
	self.controlPanel1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlPanels.controlPanel1#index" ));
	self.controlPanel2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlPanels.controlPanel2#index" ));
	
	self.drivingShaftLeft = {};
	self.drivingShaftLeft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drivingShaft#left"));
	self.drivingShaftLeft.speedFactor = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drivingShaft#speedFactor"), 1);
	self.drivingShaftRight = {};
	self.drivingShaftRight.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drivingShaft#right"));
	--DURAL : damping of the rev indicator
	self.lastRotateDrehzahlnadel = 0;	
end;

function WFTrac:delete()
end;

function WFTrac:readStream(streamId, connection)
end;

function WFTrac:writeStream(streamId, connection)
end;

function WFTrac:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WFTrac:keyEvent(unicode, sym, modifier, isDown)
end;

function WFTrac:update(dt)	
	if self:getIsActive() then        
        local sx,sy,sz = getTranslation(self.sitz);
        local _,ry,_ = getTranslation(self.wheels[1].repr);
        setTranslation(self.sitz, sx, (ry-0.8564) /3, sz);
        
        local wx,wy,wz = getRotation(self.wheels[1].driveNode);
		setRotation(self.drivingShaftLeft.node, wx*self.drivingShaftLeft.speedFactor ,0,0 );
        setRotation(self.drivingShaftRight.node, wx*self.drivingShaftLeft.speedFactor ,0,0 );   		
	end;
	
	if self.rLights == nil then
        for i=1, table.getn(self.interactiveObjects) do
            if self.interactiveObjects[10] ~= nil then
                table.remove(self.interactiveObjects, 10);
                break;
            end;
        end;
    end;
end;

function WFTrac:updateTick(dt)
    if self:getIsActive() then	
		if not self.finishWiper then
			if getAnimTrackTime(self.wiperAnimCharSet, 0) % self.wiperAnimDuration <= 100 then
				setAnimTrackTime(self.wiperAnimCharSet, 0, 0.0);
				disableAnimTrack(self.wiperAnimCharSet, 0);
				self.finishWiper = true;
			end;
		end;
		
		if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			if not self.isWiperActive then
				enableAnimTrack(self.wiperAnimCharSet, 0);
				self.isWiperActive = true;
			end;
		else
			if self.isWiperActive then
				self.isWiperActive = false;
				self.finishWiper = false;
			end;
		end;
		
		if (self.lightsTypesMask == 2) or (self.lightsTypesMask == 6) then
	        setVisibility(self.cockpitLights, true);
	    else
	        setVisibility(self.cockpitLights, false);
        end;
		
		-- check if currentcam is indoorcam
		if self.camIndex == 2 then
			if self.B3 ~= nil then
				if self.B3.wl then
					setRotation(self.hazardSwitch, Utils.degToRad(-30), 0, 0);
				else
					setRotation(self.hazardSwitch, Utils.degToRad(-15), 0, 0);
				end;
			end;

	        if (self.lightsTypesMask == 2) or (self.lightsTypesMask == 3) or (self.lightsTypesMask == 6) or (self.lightsTypesMask == 7) then
	            setRotation(self.workLightFrontSwitch, Utils.degToRad(-30), 0, 0);
	        else
	            setRotation(self.workLightFrontSwitch, Utils.degToRad(-15), 0, 0);
            end;

	        if (self.lightsTypesMask == 4) or (self.lightsTypesMask == 5) or (self.lightsTypesMask == 6) or (self.lightsTypesMask == 7) then
	           setRotation(self.workLightRearSwitch, Utils.degToRad(-30), 0, 0);
	        else
	           setRotation(self.workLightRearSwitch, Utils.degToRad(-15), 0, 0);
	        end;
		
			if self.gaspedal ~= nil then		
				local percent = (self.lastSpeed*self.speedDisplayScale*3600) / self.gaspedal.maxSpeed;
				local minRot = self.gaspedal.rotMin;
				local maxRot = self.gaspedal.rotMax;
					
				local x = minRot[1] + (maxRot[1] - minRot[1]) * percent;
				local y = minRot[2] + (maxRot[2] - minRot[2]) * percent;
				local z = minRot[3] + (maxRot[3] - minRot[3]) * percent;
				setRotation(self.gaspedal.node, x, y, z);
			end;
			
			-- check for braking
			if self.bremspedal ~= nil then
				local x, y, z = getRotation(self.bremspedal.node);
				local rot = {x,y,z};
				local direction = 1;
				if self.invertedDrivingDirection then
				    direction = -1;
				else
				    direction = 1;
				end;
				local braking = math.abs(Utils.sign(self.lastAcceleration)+ (-self.movingDirection * direction)) == 2;
				local newRot = Utils.getMovedLimitedValues(rot, self.bremspedal.rotMax, self.bremspedal.rotMin, 3, self.bremspedal.rotTime, dt, braking);
				setRotation(self.bremspedal.node, unpack(newRot));
			end;
			
			if self.blinkerhebel ~= nil and self.rLights ~= nil then
				local dir = 1;
				local hasRotChanged = false;
				local destRot = self.blinkerhebel.minRot;
				if not (self.rLights.blr.a and self.rLights.bll.a) then
					if self.rLights.bll.a then
						destRot = self.blinkerhebel.leftRot;
						self.blinkerhebel.lastDir = 1;
					elseif self.rLights.blr.a then
						destRot = self.blinkerhebel.rightRot;
						self.blinkerhebel.lastDir = -1;
						dir = -1;
					else
						if not self.rLights.blr.a and not self.rLights.bll.a then
							if self.blinkerhebel.lastDir ~= -1 then
								dir = -1;
								if self.blinkerhebel.lastDir ~= 1 then
								    dir = 1;
								end;
							end;
						end;
					end;
				else
					local x,y,z = getRotation(self.blinkerhebel.node);
					if y > 0 then
						dir = -1;
					end;
				end;

				local rot = {getRotation(self.blinkerhebel.node)};
				for i=1, 3 do

					local newRot = AnimatedVehicle.getMovedLimitedValue(rot[i], destRot[i], self.blinkerhebel.rotTime*dir, dt);
					if rot[i] ~= newRot then
						hasRotChanged = true;
						rot[i] = newRot;
					end;
				end;
				if hasRotChanged then
					setRotation(self.blinkerhebel.node, unpack(rot));
				end;
			end;			
		else
			setRotation(self.gaspedal.node, unpack(self.gaspedal.rotMin));
			setRotation(self.bremspedal.node, unpack(self.bremspedal.rotMin));
		end;
		
		if self.isMotorStarted then
--			local realRPM = 800+math.ceil((self.lastRoundPerMinute/2500)*(2500-800));
--			local rotateDrehzahlnadel = (((realRPM / 25)*2) +10);
			--mr
			local kmh = Utils.clamp(self.realGroundSpeed*3.6, 0, 1);			
			local rotateDrehzahlnadel = 10;
			
			if self.realManualGearSet then
				rotateDrehzahlnadel = 10 + self.realSoundEngineRevFx * 210;
			else
				rotateDrehzahlnadel = (self.realSoundMotorFx^0.5)*130 + 75;
			end;
			
			rotateDrehzahlnadel = math.min(280, rotateDrehzahlnadel);
			
			rotateDrehzahlnadel = 0.9*self.lastRotateDrehzahlnadel + 0.1*rotateDrehzahlnadel;
			self.lastRotateDrehzahlnadel = rotateDrehzahlnadel;
			
			--************************************************************************************************************	

			
			local currentFuelPercentage = 0;
			local fuelWarnPercentage = 20;
			if self.fuelCapacity > 0 then
				currentFuelPercentage = (self.fuelFillLevel / self.fuelCapacity + 0.0001) * 100;
			end;
			if currentFuelPercentage < fuelWarnPercentage then
				setVisibility(self.tankicon, true);
			else
				setVisibility(self.tankicon, false);
			end;
			local rotateTanknadel = ((currentFuelPercentage / 111) * 100);
			if (self.lightsTypesMask == 1) or (self.lightsTypesMask == 2) or (self.lightsTypesMask == 3) or (self.lightsTypesMask == 5) or (self.lightsTypesMask == 6) or (self.lightsTypesMask == 7) then
				setVisibility(self.drehzahlnadel, false);
				setVisibility(self.tanknadel, false);
				setVisibility(self.needles, false);
				setVisibility(self.drehzahlnadelLight, true);
				setVisibility(self.tanknadelLight, true);
                setVisibility(self.needlesLight, true);    
				setRotation(self.drehzahlnadelLight, 0, Utils.degToRad( - rotateDrehzahlnadel), 0);
				setRotation(self.tanknadelLight, 0, Utils.degToRad(rotateTanknadel), 0);
			else
				setVisibility(self.drehzahlnadel, true);
				setVisibility(self.tanknadel, true);
				setVisibility(self.needles, true);
				setVisibility(self.drehzahlnadelLight, false);
				setVisibility(self.tanknadelLight, false);
				setVisibility(self.needlesLight, false);
				setRotation(self.drehzahlnadel, 0, Utils.degToRad( - rotateDrehzahlnadel), 0);
				setRotation(self.tanknadel, 0, Utils.degToRad(rotateTanknadel), 0);
			end;
		else
			setRotation(self.drehzahlnadel, 0, 0, 0);
			setRotation(self.tanknadel, 0, 0, 0);
			setRotation(self.drehzahlnadelLight, 0, 0, 0);
			setRotation(self.tanknadelLight, 0, 0, 0);
			setVisibility(self.tankicon, false);
		end;		
	end;
	
	if self.rLights ~= nil then
	    if self.rLights.blr.a or self.rLights.bll.a or self.rLights.blw.a then
		    setVisibility(self.blinkericon, true);
	    else
		    setVisibility(self.blinkericon, false);
	    end;
	end;
end;

function WFTrac:draw() 
end;

function WFTrac:attachImplement(implement)
end;

function WFTrac:detachImplement(implementIndex)
end;

function WFTrac:onLeave()
	if self.isWiperActive then
		disableAnimTrack(self.wiperAnimCharSet, 0);
	end;
end;

function WFTrac:onEnter()
	if self.isWiperActive then
		enableAnimTrack(self.wiperAnimCharSet, 0);
	end;
end;