-- author: rafftnix
-- date: 03.02.2014

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

Tutorial = {}
Tutorial_mt = Class(Tutorial);

function Tutorial:new(mt)
	if mt == nil then
		mt = Tutorial_mt;
	end;

	local self = {}
	setmetatable(self, mt);
	
	self.gui = RafftnixGUI:new(nil, true);
	self.pages = {}
	self.pageNameToPageIndex = {}
	self.pageBaseElement = self.gui:createImage(self.gui.baseElement, 0, 0, 1, 1, "textures/gui/tutorialBackground.dds");
	self.currentPage = nil;
	
	-- buttons
	-- left
	self.gui:createButton(self.gui.baseElement, 0.03, 0.03, 0.1, 0.1, "", 1, 1, self.leftButtonOnClick, self);
	-- right
	self.gui:createButton(self.gui.baseElement, 0.87, 0.03, 0.1, 0.1, "", 1, 1, self.rightButtonOnClick, self);
	-- close
	self.gui:createButton(self.gui.baseElement, 0.87, 0.89, 0.1, 0.08, "", 1, 1, self.closeButtonOnClick, self);
	
	self:addPage("welcome", g_i18n:getText("TutorialWelcome"), g_i18n:getText("TutorialWelcomeHeader"), 0.035, {});
	self:addPage("treePlanter", g_i18n:getText("TutorialTreePlanter"), g_i18n:getText("TutorialTreePlanterHeader"), 0.035, {});
	self:addPage("plantingTrees", g_i18n:getText("TutorialPlantingTrees"), g_i18n:getText("TutorialPlantingTreesHeader"), 0.035, {});
	self:addPage("cutTrees", g_i18n:getText("TutorialCuttingTrees"), g_i18n:getText("TutorialCuttingTreesHeader"), 0.035, {});
	self:addPage("cutBranchesAndSplitTrees", g_i18n:getText("TutorialCutBranchesAndSplitTrees"), g_i18n:getText("TutorialCutBranchesAndSplitTreesHeader"), 0.035, {});
	self:addPage("woodCrane", g_i18n:getText("TutorialWoodCrane"), g_i18n:getText("TutorialWoodCraneHeader"), 0.035, {});
	self:addPage("transport", g_i18n:getText("TutorialTransport"), g_i18n:getText("TutorialTransportHeader"), 0.035, {});
	self:addPage("woodChipVsSawMill", g_i18n:getText("TutorialWoodChipVsSawMill"), g_i18n:getText("TutorialWoodChipVsSawMillHeader"), 0.035, {});
	self:addPage("mobileChipper", g_i18n:getText("TutorialMobileChipper"), g_i18n:getText("TutorialMobileChipperHeader"), 0.035, {});
	self:addPage("sawMill", g_i18n:getText("TutorialSawMill"), g_i18n:getText("TutorialSawMillHeader"), 0.035, {});
	self:addPage("woodChipStorage", g_i18n:getText("TutorialWoodChipStorage"), g_i18n:getText("TutorialWoodChipStorageHeader"), 0.035, {});
	self:addPage("bioHeatPlant", g_i18n:getText("TutorialBioHeatPlant"), g_i18n:getText("TutorialBioHeatPlantHeader"), 0.035, {});
	self:addPage("performanceWarning", g_i18n:getText("TutorialPerformanceWarning"), g_i18n:getText("TutorialPerformanceWarningHeader"), 0.035, {});
	self:addPage("credits", g_i18n:getText("TutorialCredits"), g_i18n:getText("TutorialCreditsHeader"), 0.035, {});
	
	self:loadAlreadySeen();
	
	return self;
end;

function Tutorial:addPage(name, text, headerText, textSize, imagesToLoad)
	local page = {}
	page.element = self.gui:createElement(self.pageBaseElement, 0, 0, 1, 1);
	page.element:setVisibility(false);
	page.alreadySeen = false;
	page.name = name;
	
	self.gui:createText(page.element, 0.15, 0.65, 0, 0, text, textSize, 1);
	self.gui:createText(page.element, 0.275, 0.85, 0, 0, headerText, 0.06, 1);

	for a=1, table.getn(imagesToLoad) do
		self.gui:createImage(page.element, imagesToLoad[a].posX, imagesToLoad[a].posY, imagesToLoad[a].width, imagesToLoad[a].height, imagesToLoad[a].filename);
	end;
	
	page.index = table.getn(self.pages) + 1;
	self.pageNameToPageIndex[name] = page.index;
	
	table.insert(self.pages, page);
end;

function Tutorial:openPage(index)
	if self.currentPage ~= nil then
		self.currentPage.element:setVisibility(false);
	end;
	self.currentPage = self.pages[index];
	self.currentPage.element:setVisibility(true);
end;

function Tutorial:openOnPage(name)
	self.gui:open();
	local pageIndex = self.pageNameToPageIndex[name];
	self:openPage(pageIndex);
end;

function Tutorial:close()
	self.currentPage.element:setVisibility(false);
	self.currentPage = nil;
	self.gui:close();
end;

function Tutorial:leftButtonOnClick()
	if self.pages[self.currentPage.index - 1] ~= nil then
		self:openPage(self.currentPage.index - 1);
	end;
end;

function Tutorial:rightButtonOnClick()
	if self.pages[self.currentPage.index + 1] ~= nil then
		self:openPage(self.currentPage.index + 1);
	end;
end;

function Tutorial:closeButtonOnClick()
	self:close();
end;

function Tutorial:loadAlreadySeen(filename)
	self.xmlFound = false;
	getFiles(getUserProfileAppPath(), "getFilesCallback", self);
	
	if self.xmlFound then
		local xmlFile = loadXMLFile("temp", getUserProfileAppPath().."ForrestModTutorials.xml");
	
		local num = 0;
		while hasXMLProperty(xmlFile, "tutorials.tutorial("..tostring(num)..")") do
			local name = getXMLString(xmlFile, "tutorials.tutorial("..tostring(num)..")#name");
			local pageIndex = self.pageNameToPageIndex[name];
			local page = self.pages[pageIndex];
			page.alreadySeen = getXMLBool(xmlFile, "tutorials.tutorial("..tostring(num)..")#seen");
			num = num + 1;
		end;
		
		self.xmlFile = xmlFile;
	else
		local xmlFile = createXMLFile("temp", getUserProfileAppPath().."ForrestModTutorials.xml", "tutorials");
		for a=1, table.getn(self.pages) do
			local page = self.pages[a];
			setXMLString(xmlFile, "tutorials.tutorial("..tostring(a-1)..")#name", page.name);
			setXMLBool(xmlFile, "tutorials.tutorial("..tostring(a-1)..")#seen", page.alreadySeen);
		end;
		saveXMLFile(xmlFile);
		self.xmlFile = xmlFile;
	end;
end;

function Tutorial:saveAlreadySeen()
	for a=1, table.getn(self.pages) do
		local page = self.pages[a];
		setXMLString(self.xmlFile, "tutorials.tutorial("..tostring(a-1)..")#name", page.name);
		setXMLBool(self.xmlFile, "tutorials.tutorial("..tostring(a-1)..")#seen", page.alreadySeen);
	end;
	saveXMLFile(self.xmlFile);
	delete(self.xmlFile);
end;

function Tutorial:getFilesCallback(filename)
	if filename == "ForrestModTutorials.xml" then
		self.xmlFound = true;
	end;
end;

function Tutorial:getHasAlreadySeen(name)
	local index = self.pageNameToPageIndex[name];
	if index ~= nil then
		return self.pages[index].alreadySeen;
	else
		return true;
	end;
end;

function Tutorial:setHasAlreadySeen(name)
	local index = self.pageNameToPageIndex[name];
	if index ~= nil then
		self.pages[index].alreadySeen = true;
	end;
end;

function Tutorial:checkShowTutorial(name)
	if g_server ~= nil and not g_currentMission.missionDynamicInfo.isMultiplayer and not self:getHasAlreadySeen(name) then
		if g_gui.currentGui == nil then
			self:setHasAlreadySeen(name);
			self:openOnPage(name);
			return true;
		end;
	end;
	return false;
end;