-- author: rafftnix
-- date: 05.11.2012

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

TreePlanter = {};

function TreePlanter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function TreePlanter:load(xmlFile)
	self.groundContactReport = SpecializationUtil.callSpecializationsFunction("groundContactReport");
	self.resetWorkerAnimation = SpecializationUtil.callSpecializationsFunction("resetWorkerAnimation");
	self.fillTreePlanter = SpecializationUtil.callSpecializationsFunction("fillTreePlanter");
	self.setIsTurnedOn = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn");
	self.setTreeType = SpecializationUtil.callSpecializationsFunction("setTreeType");
	self.setFillLevel = Utils.overwrittenFunction(self.setFillLevel, TreePlanter.setFillLevel);	
	
	self.treePlaceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.treePlanter#placeNodeIndex"));
	self.currentTreeType = 1;
	
	self.treeDist = 5;
	self.distSinceLastTree = 0;
	self.treeStartScale = 0.09;
	self.lastPlaceNodePos = {0, 0, 0}
	
	self.maxSpeedLevel = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.treePlanter#maxSpeedLevel"), 1);
	self.speedViolationMaxTime = 2000;
	self.speedViolationTimer = self.speedViolationMaxTime;
				
	self.isTurnedOn = false;
	self.hasGroundContact = false; 
	self.fieldOwned = true;
	self.synchronizeFullFillLevel = true;
	self.seedlingFillTriggers = {}
	
	self.workAreaStart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.treePlanter.area#startIndex"));
	self.workAreaWidth = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.treePlanter.area#startWidth"));
	self.workAreaHeight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.treePlanter.area#heightIndex"));

	self.contactReportNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.treePlanter#groundContactNodeIndex"));
	addContactReport(self.contactReportNode, 0.0001, "groundContactReport", self);
	
	self.treeSeedlingsNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.treePlanter.workerAnim#treesIndex"));
	self.treeSeedlings = {}
	for a=0, getNumOfChildren(self.treeSeedlingsNode)-1 do
		table.insert(self.treeSeedlings, getChildAt(self.treeSeedlingsNode, a));
	end;
		
	self.diggingNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.treePlanter#diggingIndex"));
	self.diggingAc = 0.001;
	self.diggingMaxSpeed = 0.025;
	self.diggingSpeed = 0;
	
	if hasXMLProperty(xmlFile, "vehicle.treePlanter.groundParticles") then
		self.groundParticles = {}
		Utils.loadParticleSystem(xmlFile, self.groundParticles, "vehicle.treePlanter.groundParticles", self.components, false, "machinery/DamconPL40/groundParticle2.i3d", self.baseDirectory);
	end;
	
	self.protectorPlanes = {};
	local i=0;
	while true do
		i = i + 1;
		local node = Utils.indexToObject( self.components, getXMLString(xmlFile, string.format("vehicle.protector.protector%d#index", i)));
		if node == nil then break; end;
		local e = {};
		e.node = node;
		local rx,ry,rz = getRotation(e.node)
		e.startRot = {rx,ry,rz}
		table.insert(self.protectorPlanes, e);
	end;

	self.animNodes = {}
	local num = 0;
	while true do
		local key = "vehicle.treePlanter.workerAnim.node("..tostring(num)..")";
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local nodeId = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		setVisibility(nodeId, false);
		table.insert(self.animNodes, nodeId);
		num = num + 1;
	end;
	
	-- worker anim
	self.isAnimTrackEnabled = false;
	self.workerAnimNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.treePlanter.workerAnim#nodeIndex"));
	self.workerAnimCharSet = getAnimCharacterSet(self.workerAnimNode);
	local clip = getAnimClipIndex(self.workerAnimCharSet, getXMLString(xmlFile, "vehicle.treePlanter.workerAnim#animName"));
	self.workerAnimDuration = getAnimClipDuration(self.workerAnimCharSet, clip);
	assignAnimTrackClip(self.workerAnimCharSet, 1, clip);
	setAnimTrackLoopState(self.workerAnimCharSet, 1, true);
	
	self:setFillLevel(0, Fillable.fillTypeNameToInt["woodChip"]);
end;

function TreePlanter:delete()
	if self.groundParticles ~= nil then
		Utils.deleteParticleSystem(self.groundParticles);
		self.groundParticles = nil;
	end;
end;

function TreePlanter:readStream(streamId, connection)
	self.currentTreeType = streamReadInt8(streamId);
	self:setIsTurnedOn(streamReadBool(streamId));
	self.isAnimTrackEnabled = streamReadBool(streamId);
	self.distSinceLastTree = streamReadFloat32(streamId);
end;
  
function TreePlanter:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.currentTreeType);
	streamWriteBool(streamId, self.isTurnedOn);
	streamWriteBool(streamId, self.isAnimTrackEnabled);
	streamWriteFloat32(streamId, self.distSinceLastTree);
end;

function TreePlanter:readUpdateStream(streamId, timestamp, connection)
	if connection:getIsServer() then
		self.isAnimTrackEnabled = streamReadBool(streamId);
	end;
end;

function TreePlanter:writeUpdateStream(streamId, connection, dirtyMask)
	if not connection:getIsServer() then
		streamWriteBool(streamId, self.isAnimTrackEnabled);
	end;
end;

function TreePlanter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TreePlanter:keyEvent(unicode, sym, modifier, isDown)
end;

function TreePlanter:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then 
			self:setIsTurnedOn(not self.isTurnedOn);
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			self:setTreeType();
		end;
	end;
	
	if self.diggingNode ~= nil then
		rotate(self.diggingNode, -(dt*self.diggingSpeed), 0, 0);
	end;	
	
	if self:getIsActiveForInput() and self.seedlingFillTriggers[1] ~= nil and self.fillLevel < self.capacity then
		if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
			if self.isServer then
				self:fillTreePlanter();
			else
				g_client:getServerConnection():sendEvent(FillTreePlanterEvent:new(self)); 
			end;
		end;
	end;
	
	if self.isAnimTrackEnabled and self.isTurnedOn then
		if self.movingDirection == 1 then
			local x, y, z = getWorldTranslation(self.treePlaceNode);
			local dist = Utils.vector3Length(x-self.lastPlaceNodePos[1],y-self.lastPlaceNodePos[2],z-self.lastPlaceNodePos[3]);
			self.distSinceLastTree = self.distSinceLastTree + dist;
		end;
		setAnimTrackTime(self.workerAnimCharSet, 1,  math.min(self.workerAnimDuration, (self.distSinceLastTree/self.treeDist)* self.workerAnimDuration));
	end;
	
	self.lastPlaceNodePos = {getWorldTranslation(self.treePlaceNode)}
end;

function TreePlanter:updateTick(dt)
	local x, y, z = getWorldTranslation(self.treePlaceNode);
	
	if self.isTurnedOn then
		self.fieldOwned = g_currentMission:getIsFieldOwnedAtWorldPos(x,z);
		if self.isAnimTrackEnabled and self.fieldOwned then
			if self.isServer then
				if self.distSinceLastTree > self.treeDist then
					local treeType = g_currentMission.treeManager.treeTypes[self.currentTreeType].treeType;
					g_currentMission.treeManager:placeNewTree(treeType, x, y, z, self.treeStartScale, math.rad(math.random(0, 360)), math.random(1, table.getn(g_currentMission.treeManager.treeTypes[treeType].trees)), noEventSend); 
					self.distSinceLastTree = 0;
					g_server:broadcastEvent(TreePlanterTreePlantEvent:new(self), nil, nil, self);  -- this has nothing to do with the tree-planting, it is just for the worker animation
					g_currentMission.treeManager.forrestModTutorial:checkShowTutorial("cutTrees");
					self:setFillLevel(self.fillLevel-1, self.currentFillType);
				end;
			end;
		end;
		
		for i,plane in pairs(self.protectorPlanes) do
			local rx,ry,rz = getRotation(plane.node)
			if self.isAnimTrackEnabled then
				if self.lastSpeed*3600>=0.8 then
					setShaderParameter(plane.node, "displacementSpeedFrequencyAndTexOff", 0.15, -5, 15, 0.05,false);
				else
					setShaderParameter(plane.node, "displacementSpeedFrequencyAndTexOff", 0.1, 0, 0, 0.05,false);
				end;
				if self.ropeInJointNode ~= nil then
					local xr = self.ropeInStart + (self.ropeInSpace*self.ropeInFactor);
					setRotation(plane.node,math.min(xr,rx+0.01),ry,rz)
				end;
			else
				if self.ropeInJointNode ~= nil then
					setRotation(plane.node,math.max(plane.startRot[1],rx-0.01),plane.startRot[2],plane.startRot[3])
				end;
				setShaderParameter(plane.node, "displacementSpeedFrequencyAndTexOff", 0.1, 0, 0, 0.05,false);
			end;
		end;
		self.diggingSpeed = math.min(self.diggingSpeed+self.diggingAc, self.diggingMaxSpeed);
	else
		self.diggingSpeed = math.max(self.diggingSpeed-self.diggingAc, 0);
	end;
		
	if self.isServer then
		if self.isAnimTrackEnabled ~= (self.hasGroundContact and self.isTurnedOn) then
			self.isAnimTrackEnabled = (self.hasGroundContact and self.isTurnedOn and self.fillLevel >= 1 and self.fieldOwned);
		end;
	end;
	
	if self.isAnimTrackEnabled ~= isAnimTrackEnabled(self.workerAnimCharSet, 1) then
		if self.isAnimTrackEnabled then
			enableAnimTrack(self.workerAnimCharSet, 1);
		else
			disableAnimTrack(self.workerAnimCharSet, 1);
		end;
	end;
	
	if self.isAnimTrackEnabled then
		local speedLimit = 14;
		if self.maxSpeedLevel == 1 then
			speedLimit = 20;
		elseif self.maxSpeedLevel == 2 then
			speedLimit = 30;
		elseif self.maxSpeedLevel == 3 then
			speedLimit = 100;
		end;
		
		if self.lastSpeed*3600 > speedLimit then
			self.speedViolationTimer = self.speedViolationTimer - dt;
		
			if self.isServer and self.speedViolationTimer < 0 then
				if self.attacherVehicle ~= nil then
					self.attacherVehicle:detachImplementByObject(self);
				end;
			end;
		else
			self.speedViolationTimer = self.speedViolationMaxTime;
		end;
	else
		self.speedViolationTimer = self.speedViolationMaxTime;
	end;
	
	if self.groundParticles ~= nil and self:getIsActive() then
		Utils.setEmittingState(self.groundParticles, self.isAnimTrackEnabled);
		if self.isAnimTrackEnabled then
			Utils.setParticleSystemTimeScale(self.groundParticles, self.lastSpeed*3600/14);
			for a=1, table.getn(self.groundParticles) do
				setVisibility(self.groundParticles[a].shape, true);
			end;
		else
			for a=1, table.getn(self.groundParticles) do
				setVisibility(self.groundParticles[a].shape, false);
			end;
		end;
	end;
end;

function TreePlanter:draw()
	if self.isTurnedOn then
		g_currentMission:addHelpButtonText(g_i18n:getText("deactivatePlantMode"), InputBinding.IMPLEMENT_EXTRA);
		if not self.fieldOwned then
			g_currentMission:addWarning(g_i18n:getText("You_dont_own_this_field"));
		end;
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("activatePlantMode"), InputBinding.IMPLEMENT_EXTRA);
	end;
	
	if self.seedlingFillTriggers[1] ~= nil and self.fillLevel < self.capacity then
		g_currentMission:addHelpButtonText(g_i18n:getText("loadSeedlings"), InputBinding.ACTIVATE_OBJECT);
	end;
	
	if g_currentMission.treeManager.treeTypes[2] ~= nil then
		g_currentMission:addHelpButtonText(g_i18n:getText("select_treeType"), InputBinding.IMPLEMENT_EXTRA3);
		g_currentMission:addExtraPrintText(g_i18n:getText("treeType")..": "..g_currentMission.treeManager.treeTypes[self.currentTreeType].l10nText);
	end;
	
	if self.fillLevel == 0 then
		g_currentMission:addExtraPrintText(g_i18n:getText("fillTreePlanterFirst"));
	end;
	
	local treeType = g_currentMission.treeManager.treeTypes[self.currentTreeType].treeType;
	local icon = g_currentMission.treeManager.treeTypes[treeType].icon;
	if icon ~= nil then
		renderOverlay(icon, 1-0.105, 0.27, 0.10, 0.17);
	end;
	
	if math.abs(self.speedViolationTimer - self.speedViolationMaxTime) > 2 then
		g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), tostring(self.maxSpeedLevel)), 0.07+0.022, 0.019+0.029);
	end;
end;

function TreePlanter:onAttach(attacherVehicle, jointDescIndex)
	g_currentMission.treeManager.forrestModTutorial:checkShowTutorial("treePlanter");
end;

function TreePlanter:setIsTurnedOn(isTurnedOn, noEventSend)
	if self.fillLevel == 0 then
		isTurnedOn = false;
	end;

	SetTurnedOnEvent.sendEvent(self, isTurnedOn, noEventSend);
	self.isTurnedOn = isTurnedOn;
	
	if not isTurnedOn then
		setAnimTrackTime(self.workerAnimCharSet, 1, 0);
	end;
	
	for a=1, table.getn(self.animNodes) do
		setVisibility(self.animNodes[a], isTurnedOn);
	end;
	
	if self.workerAnimCharSet ~= nil then
		setAnimTrackTime(self.workerAnimCharSet, 1, getAnimTrackTime(self.workerAnimCharSet, 1)+10);
	end;
end;

function TreePlanter:onDetach()
	self.isTurnedOn = false;
end;

function TreePlanter:onLeave()
	self.isTurnedOn = false;
end;

function TreePlanter:setTreeType()
	local typeBackup = self.currentTreeType;
	self.currentTreeType = self.currentTreeType + 1;
	if g_currentMission.treeManager.treeTypes[self.currentTreeType] == nil then
		self.currentTreeType = 1;
	end;
	if not noEventSend then
		if self.currentTreeType ~= typeBackup then
			TreePlanterSetTreeTypeEvent.sendEvent(self, self.currentTreeType, noEventSend);
		end;
	end;
end;

function TreePlanter:groundContactReport(objectId, otherObjectId, isStart, normalForce, tangentialForce)
	if otherObjectId == g_currentMission.terrainRootNode then
		self.hasGroundContact = isStart or normalForce > 0 or tangentialForce > 0;
	end;
end;

function TreePlanter:setFillLevel(oldFunc, fillLevel, fillType, force)
	oldFunc(self, fillLevel, fillType, force);
	
	if fillLevel == 0 then
		self:setIsTurnedOn(false);
	end;
	
	if fillLevel == 1 then
		fillLevel = fillLevel - 1;
	end;
	
	for a=1, table.getn(self.treeSeedlings) do
		if a <= fillLevel then
			setVisibility(self.treeSeedlings[a], true);
		else
			setVisibility(self.treeSeedlings[a], false);
		end;
	end;
end;

function TreePlanter:fillTreePlanter() 
	local source = self.seedlingFillTriggers[1];
	local fillType = Fillable.fillTypeNameToInt["seedling"];
	if self.isServer and source ~= nil then
		local maxAmount = self.capacity - self.fillLevel;
		
		if source.amountLimited ~= nil and source.amountLimited and source.fillLevel ~= nil and source.setFillLevel ~= nil then -- e.g. pallet
			local amount = math.min(maxAmount, source.fillLevel);
			self:setFillLevel(self.fillLevel + amount, fillType);
			source:setFillLevel(source.fillLevel - amount, fillType);
		else -- e.g. garden market
			self:setFillLevel(self.fillLevel + maxAmount, fillType);
			if source.payBill ~= nil then
				source:payBill(maxAmount);
			end;
		end;
		
		if source.fillLevel ~= nil and source.fillLevel == 0 then
			for a=1, table.getn(self.seedlingFillTriggers) do
				if self.seedlingFillTriggers[a] == source then
					table.remove(self.seedlingFillTriggers, a);
				end;
			end;
		end;
	end;
	
	if self.fillLevel > 0 then
		g_currentMission.treeManager.forrestModTutorial:checkShowTutorial("plantingTrees");
	end;
end;

function TreePlanter:resetWorkerAnimation()
	setAnimTrackTime(self.workerAnimCharSet, 1, 0);
	self.distSinceLastTree = 0;
end;