--  author: fruktor, rafftnix 
--	free of charge for non-commercial use

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

SwitchMouseControl = {};

function SwitchMouseControl.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(MouseControlsVehicle, specializations);
end;

function SwitchMouseControl:load(xmlFile)
	self.setActiveMC = SpecializationUtil.callSpecializationsFunction("setActiveMC");
	self.setMCIconsActive = SpecializationUtil.callSpecializationsFunction("setMCIconsActive");

	self.isSelectable = true;
	self.activeMC = 1;
	self.mcIconsActive = true;
	self.mcIconsActivateable = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.switchMouseControl#activateableMouseControlIcons"), false);

	self.mcPairs = {};
	
	local i = 1;
	while true do 
		local key = string.format("vehicle.switchMouseControl.mc(%s)", i-1);
		local name = getXMLString(xmlFile, key.."#name");
		if name == nil then
			name = getXMLString(xmlFile, key.."#textName");
			if name == nil then
				break;
			end;
			name = g_i18n:getText(name);
		end;
		local onlyOnMotorStarted = Utils.getNoNil( getXMLBool(xmlFile, key.."#onlyOnMotorStarted"), false );

		local mcPair = {}
		mcPair.name = name;
		mcPair.onlyOnMotorStarted = onlyOnMotorStarted;
		mcPair.indices = {}
		mcPair.mouseControlOverlays = {}

		local r = 1;
		while true do
			local idx = getXMLInt(xmlFile, key..string.format("#index%s", r));
			if idx == nil then 
				break;
			else
				table.insert(mcPair.indices, idx);
			end;
			r = r + 1;
		end;
		
		local num = 0;
		while true do
			local overlayKey = key..".mouseControlOverlays.mouseControl("..num..")";
			local filename = getXMLString(xmlFile, overlayKey.."#iconFilename");
			local axis = getXMLString(xmlFile, overlayKey.."#axis");
			if filename ~= nil and axis ~= nil then
				local overlay = {}
				overlay.iconFilename = Utils.getFilename(filename, self.baseDirectory);
				overlay.foldMinLimit = 0;
				overlay.foldMaxLimit = 1;
				g_mouseControlsHelp:addIconFilename(overlay.iconFilename);
				mcPair.mouseControlOverlays[axis] = overlay;
			else
				break;
			end;
			num = num + 1;
		end;
		
		table.insert(self.mcPairs, mcPair);
		i = i + 1;
	end;
	
	for i,tool in pairs(self.movingTools) do
		if tool.rotSpeed ~= nil then
			tool.rotSpeedBackupMC = tool.rotSpeed;
		end;
		if tool.transSpeed ~= nil then
			tool.transSpeedBackupMC = tool.transSpeed;
		end;
	end;	
	
	self:setActiveMC(self.activeMC);
end;

function SwitchMouseControl:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if self.mcIconsActivateable then
		self:setMCIconsActive(Utils.getNoNil(getXMLBool(xmlFile, key.."#mcIconsActive"), true));
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function SwitchMouseControl:getSaveAttributesAndNodes(nodeIdent)
	local attributes = "";
	if self.mcIconsActivateable then
		attributes = 'mcIconsActive="'..tostring(self.mcIconsActive)..'"';
	end;
	return attributes, nil;
end;

function SwitchMouseControl:delete()
end;

function SwitchMouseControl:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SwitchMouseControl:keyEvent(unicode, sym, modifier, isDown)
end;

function SwitchMouseControl:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.SWITCHMC) then
			local tmp = self.activeMC + 1;
			if self.mcPairs[tmp] == nil then 
				tmp = 1;
			end;
			self:setActiveMC(tmp);
		end;
		
		if self.mcIconsActivateable then
			if self.mcIconsActive ~= g_currentMission.showHelpText then
				self:setMCIconsActive(g_currentMission.showHelpText);
			end;
		end;
	end;
end;

function SwitchMouseControl:updateTick(dt)
	local started = false;
	if self.attacherVehicle ~= nil then
		local vehicle = self.attacherVehicle;
		while vehicle.attacherVehicle ~= nil do
			vehicle = vehicle.attacherVehicle;
		end;
		if vehicle.isMotorStarted ~= nil then
			started = vehicle.isMotorStarted;
		end;
	else
		if self.isMotorStarted ~= nil then
			started = self.isMotorStarted;
		end;
	end;
	if self.lastStarted ~= started then
		self.lastStarted = started;
		self:setActiveMC(self.activeMC);
	end;
end;

function SwitchMouseControl:draw()
	if self:getIsActiveForInput() then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("SWITCHMC"), self.mcPairs[self.activeMC].name), InputBinding.SWITCHMC);
	end;
end;

function SwitchMouseControl:setActiveMC(idx)
	self.activeMC = idx;
	for i, mcPair in pairs(self.mcPairs) do
		for k, index in pairs(mcPair.indices) do 
			if self.movingTools[index].rotSpeedBackupMC ~= nil then
				self.movingTools[index].rotSpeed = 0;
			end;
			if self.movingTools[index].transSpeedBackupMC ~= nil then
				self.movingTools[index].transSpeed = 0;
			end;
		end;
	end;

	local started = false;
	if self.attacherVehicle ~= nil then
		local vehicle = self.attacherVehicle;
		while vehicle.attacherVehicle ~= nil do
			vehicle = vehicle.attacherVehicle;
		end;
		if vehicle.isMotorStarted ~= nil then
			started = vehicle.isMotorStarted;
		end;
	else
		if self.isMotorStarted ~= nil then
			started = self.isMotorStarted;
		end;
	end;
	if not self.mcPairs[idx].onlyOnMotorStarted or (self.mcPairs[idx].onlyOnMotorStarted and started) then 
		for k, index in pairs(self.mcPairs[idx].indices) do
			if self.movingTools[index].rotSpeedBackupMC ~= nil then
				if self.currentMovingToolSpeedFactor == nil then
					self.movingTools[index].rotSpeed = self.movingTools[index].rotSpeedBackupMC;
				else
					self.movingTools[index].rotSpeed = self.movingTools[index].rotSpeedBackupMC * self.currentMovingToolSpeedFactor;
				end;
			end;
			if self.movingTools[index].transSpeedBackupMC ~= nil then
				if self.currentMovingToolSpeedFactor == nil then
					self.movingTools[index].transSpeed = self.movingTools[index].transSpeedBackupMC;
				else
					self.movingTools[index].transSpeed = self.movingTools[index].transSpeedBackupMC * self.currentMovingToolSpeedFactor;
				end
			end;
		end;
	end;
	
	self:setMCIconsActive(self.mcIconsActive);
end;

function SwitchMouseControl:setMCIconsActive(active)
	if self.mouseControlsIcons ~= nil then
		if active then
			self.mouseControlsIcons = self.mcPairs[self.activeMC].mouseControlOverlays;
		elseif self.mcIconsActivateable then
			self.mouseControlsIcons = {};
		end;
		self.mcIconsActive = active;
	end;
end;