-- author: rafftnix
-- date: 12.11.2013

-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

StorageTipTrigger = {}
StorageTipTrigger_mt = Class(StorageTipTrigger, Object);

function onCreate(self, id) 
	local trigger = StorageTipTrigger:new(g_server ~= nil, g_client ~= nil);
	if trigger:load(id) then
		g_currentMission:addOnCreateLoadedObject(trigger);
		trigger:register(true);
		g_currentMission:addOnCreateLoadedObjectToSave(trigger);
	else
		trigger:delete();
	end;
end;

function StorageTipTrigger:new(isServer, isClient, mt)
	if mt == nil then
		mt = StorageTipTrigger_mt;
	end;
	
	local self = Object:new(isServer, isClient, mt);
	g_currentMission:addTipTrigger(self);
	
	self.storageTipTriggerDirtyFlag = self:getNextDirtyFlag();
	
	return self;
end;

function StorageTipTrigger:load(nodeId)
	self.isStorageTipTrigger = true;
	self.triggerId = nodeId;
	self.isEnabled = true;
	self.showFillLevel = false;
	self.vehiclesInTrigger = {}
	self.playerInTrigger = nil;
	
	self.capacity = Utils.getNoNil(getUserAttribute(nodeId, "capacity"), 10000);
	self.fillLevel = 0;
	
	local fillTypeStr = getUserAttribute(nodeId, "fillType");
	self.acceptedFillType = Fillable.fillTypeNameToInt[fillTypeStr];
	self.acceptedFillTypes = {}
	self.priceMultipliers = {}
	self.acceptedFillTypes[self.acceptedFillType] = true;
	self.priceMultipliers[self.acceptedFillType] = 0;
	
	self.trailersInTrigger = {}
	addTrigger(nodeId, "triggerCallback", self);
	
	if getUserAttribute(nodeId, "infoTriggerIndex") ~= nil then
		self.infoTriggerId = Utils.indexToObject(getParent(nodeId), getUserAttribute(nodeId, "infoTriggerIndex"));
		addTrigger(self.infoTriggerId, "triggerCallback", self);
	end;
	
	-- create shovel trigger
	if g_server ~= nil and getUserAttribute(self.triggerId, "shovelTriggerIndex") then
		local shovelTriggerNode = Utils.indexToObject(getParent(self.triggerId), getUserAttribute(self.triggerId, "shovelTriggerIndex"));
		self.shovelTrigger = StorageShovelTrigger:new();
		self.shovelTrigger:load(shovelTriggerNode, self.acceptedFillType, self);
		g_currentMission:addUpdateable(self.shovelTrigger);
	end;
	
	self.triggerTipWidth = Utils.getNoNil(getUserAttribute(id, "triggerTipWidth"), math.huge);
	
	self.isAreaTrigger = Utils.getNoNil(getUserAttribute(nodeId, "isAreaTrigger"), false);
	if self.isAreaTrigger then
		self.triggerStartId = getChildAt(nodeId, 0);
		self.triggerEndId = getChildAt(nodeId, 1);
		self.triggerWidth = Utils.getNoNil(getUserAttribute(nodeId, "triggerWidth"), 3);
	else
		self.triggerStartId = self.triggerId;
	end;
	
	local planeIndex = getUserAttribute(nodeId, "planeIndex");
	local planeMinY = getUserAttribute(nodeId, "planeMinY");
	local planeMaxY = getUserAttribute(nodeId, "planeMaxY");
	if planeIndex ~= nil and planeMinY ~= nil and planeMaxY ~= nil then
		self.planeId = Utils.indexToObject(getParent(nodeId), planeIndex);
		self.planeMinY = planeMinY;
		self.planeMaxY = planeMaxY;
	
		-- to be detected by e.g. shovel 
		g_currentMission:addNodeObject(self.planeId, self);
	end;
	
	return true;
end;

function StorageTipTrigger:delete()
	g_currentMission:removeOnCreateLoadedObjectToSave(self);

	if self.shovelTrigger ~= nil then
		self.shovelTrigger:delete();
		self.shovelTrigger = nil;
	end;
	
	if self.triggerId ~= nil then
		removeTrigger(self.triggerId);
		self.triggerId = nil;
		
		if self.planeId ~= nil then
			g_currentMission:removeNodeObject(self.planeId);
		end;
		
		g_currentMission:removeTipTrigger(self);
	end;
	
	if self.infoTriggerId ~= nil then
		removeTrigger(self.infoTriggerId);
		self.infoTriggerId = nil;
	end;
end;

function StorageTipTrigger:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	self.fillLevel = math.min(self.capacity, Utils.getNoNil(getXMLFloat(xmlFile, key.."#fillLevel"), 0));
	return true;
end;

function StorageTipTrigger:getSaveAttributesAndNodes(nodeIdent)
	local attributes, nodes = "", "";
	attributes = ' fillLevel="'..tostring(self.fillLevel)..'"';
	return attributes, nodes;
end;

function StorageTipTrigger:readStream(streamId, connection)
	if not self.isServer then 
		self.fillLevel = math.abs((streamReadInt16(streamId)/32768)*self.capacity);
	end;
end;

function StorageTipTrigger:writeStream(streamId, connection)
	if self.isServer then 
		streamWriteInt16(streamId, math.floor((self.fillLevel/self.capacity)*32768));
	end;
end;

function StorageTipTrigger:readUpdateStream(streamId, timestamp, connection)
	StorageTipTrigger.readStream(self, streamId, connection)
end;

function StorageTipTrigger:writeUpdateStream(streamId, connection, dirtyMask)
	StorageTipTrigger.writeStream(self, streamId, connection);
end;

function StorageTipTrigger:update(dt)
	if self.fillLevel > 0 and self.showFillLevel then
		g_currentMission:addExtraPrintText(g_i18n:getText("fillLevel") .. ": " .. tostring(math.floor(self.fillLevel)) .. "l (" .. tostring(math.floor(self.fillLevel / self.capacity * 100)) .. "%)");
	end;
end;

function StorageTipTrigger:updateTick(dt)
	if self.planeId ~= nil then
		local x, y, z = getTranslation(self.planeId);
		local newY = self.planeMinY + ((self.planeMaxY-self.planeMinY) * (self.fillLevel/self.capacity));
		setTranslation(self.planeId, x, newY, z);
	end;
	
	local showInfos = self.playerInTrigger;
	if not showInfos then
		for a=1, table.getn(self.vehiclesInTrigger) do
			if self.vehiclesInTrigger[a]:getIsActiveForInput(false) then
				showInfos = true;
				break;
			end;
		end;
	end;
	self.showFillLevel = showInfos;
end;

function StorageTipTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	TipTrigger.triggerCallback(self, triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)

	local vehicle = g_currentMission.nodeToVehicle[otherId];
	if vehicle ~= nil then
		if onEnter then
			table.insert(self.vehiclesInTrigger, vehicle);
		elseif onLeave then
			for a=1, table.getn(self.vehiclesInTrigger) do
				if self.vehiclesInTrigger[a] == vehicle then
					table.remove(self.vehiclesInTrigger, a);
					break;
				end;
			end;
		end;
	end;
	
	if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		if onEnter then
			self.playerInTrigger = true;
		elseif onLeave then
			self.playerInTrigger = false;
		end;
	end;
end;

function StorageTipTrigger:updateTrailerTipping(trailer, fillDelta, fillType)
	if fillDelta < 0 then
		self.fillLevel = math.min(self.fillLevel - fillDelta, self.capacity);
		if self.fillLevel == self.capacity then
			trailer:onEndTip();
		end;
		self:raiseDirtyFlags(self.storageTipTriggerDirtyFlag);
	end;
end;

function StorageTipTrigger:getTipInfoForTrailer(trailer, tipReferencePointIndex)
	local isAllowed, minDistance, bestPoint = TipTrigger.getTipInfoForTrailer(self, trailer, tipReferencePointIndex);
	
	if self.fillLevel == self.capacity or trailer.currentFillType ~= self.acceptedFillType then
		isAllowed = false;
	end;

	return isAllowed, minDistance, bestPoint;
end;

function StorageTipTrigger:getTipDistanceFromTrailer(trailer, tipReferencePointIndex)
	return TipTrigger.getTipDistanceFromTrailer(self, trailer, tipReferencePointIndex);
end;

function StorageTipTrigger:updateMoving(notNeeded)
	self:raiseDirtyFlags(self.storageTipTriggerDirtyFlag);
end;

function StorageTipTrigger:addShovelFillLevel(shovel, delta, fillType)
	delta = math.min(self.capacity-self.fillLevel, delta);
	self.fillLevel = self.fillLevel + delta;
	self:raiseDirtyFlags(self.storageTipTriggerDirtyFlag);
	return delta;
end;

function StorageTipTrigger:getAllowShovelFillType(fillType)
	return fillType == self.acceptedFillType and self.fillLevel < self.capacity;
end;

function StorageTipTrigger:getNoAllowedText(trailer)
	return TipTrigger.getNoAllowedText(self, trailer);
end;